/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.LengthRestrictedJTextField;
import DE.siemens.ad.logo.util.LogoError;
import java.io.UnsupportedEncodingException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class PasswordField
extends LengthRestrictedJTextField {
    protected boolean fIME_Observed = false;

    public PasswordField() {
    }

    public PasswordField(int cols) {
        super(cols);
    }

    protected Document createDefaultModel() {
        return new PasswordDocument();
    }

    public boolean isNewPartsValidString(String str) {
        byte[] b;
        boolean fDebug = true;
        if (this.fIME_Observed) {
            return true;
        }
        try {
            b = str.getBytes("UTF-16BE");
            System.out.print("\n" + str + " with following bytes: ");
            for (int i = 0; i < b.length; ++i) {
                System.out.print("<" + b[i] + ">");
            }
        }
        catch (Exception e) {
            b = new byte[]{};
        }
        if (b[0] != 0 || b.length > 2) {
            this.fIME_Observed = true;
            if (b[0] != 0) {
                this.showError();
            }
            return true;
        }
        if (b[1] < 65 || b[1] > 90) {
            this.showError();
            return false;
        }
        return true;
    }

    private void showError() {
        System.out.print(" < error!> ");
        new LogoError(this, "dialog.error.passwordField.wrongChar", "Wrong value! Only A...Z allowed.").display();
    }

    public void paste() {
    }

    public void copy() {
    }

    public void cut() {
    }

    public boolean checkFieldContents() {
        byte[] b;
        boolean fSupportUTF16 = true;
        try {
            b = this.getText().getBytes("UTF-16BE");
        }
        catch (UnsupportedEncodingException e1) {
            fSupportUTF16 = false;
            System.out.println("This JRE do not support UTF-16BE");
            b = this.getText().getBytes();
        }
        if (fSupportUTF16) {
            int i;
            for (i = 0; i < b.length; i += 2) {
                if (b[i] == 0) continue;
                this.showError();
                return false;
            }
            for (i = 1; i < b.length; i += 2) {
                if (b[i] >= 65 && b[i] <= 90) continue;
                this.showError();
                return false;
            }
        } else {
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 65 && b[i] <= 90) continue;
                this.showError();
                return false;
            }
        }
        return true;
    }

    public class PasswordDocument
    extends LengthRestrictedJTextField.LengthRestrictedDocument {
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            str = str.toUpperCase();
            String currentString = this.getText(0, this.getLength());
            String tempString = currentString.substring(0, offs) + str + currentString.substring(offs);
            if (currentString.length() != 0 || str.length() == 1) {
                // empty if block
            }
            if (PasswordField.this.isValidString(tempString) && PasswordField.this.isNewPartsValidString(str)) {
                super.insertString(offs, str, a);
            } else {
                PasswordField.this.getToolkit().beep();
            }
        }
    }
}

