/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.LengthRestrictedJTextField;
import DE.siemens.ad.logo.dialog.comp.AnalogInputArrangePanel;
import DE.siemens.ad.logo.dialog.comp.AnalogOutputPropertyPanel;
import DE.siemens.ad.logo.dialog.comp.AnalogOutputTypePanel;
import DE.siemens.ad.logo.dialog.comp.PasswordField;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.PropertiesIfc;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToolTip;

public class PCLogoPropertyPanel
extends DataInputPanel {
    private PropertiesIfc fModel;
    private JLabel fProgramNameLabel;
    private LengthRestrictedJTextField fProgramName;
    private JPanel fInputPanel;
    private JLabel fNewPasswordLabel;
    private JLabel fOldPasswordLabel;
    private JLabel fNewPasswordLabel1;
    private PasswordField fNewPassword;
    private PasswordField fNewPassword1;
    private PasswordField fOldPassword;
    private JRadioButton fStartScreenClockButton;
    private JRadioButton fStartScreenIOButton;
    private AnalogOutputPropertyPanel fAnalogOutputPropertyPanel;
    private AnalogOutputTypePanel fAnalogOutputTypePanel;
    private AnalogInputArrangePanel fAnalogInputArrangePanel;
    private Hardware fHardware;
    private BorderJPanel fPasswordPanel;
    private BorderJPanel fStartScreenPanel;
    private BorderJPanel fAQInStopPanel;
    private BorderJPanel fAQTypePanel;
    private BorderJPanel fAIPanel;

    public PCLogoPropertyPanel(PropertiesIfc model, LogoDrawing logoDrawing) {
        this.fModel = model;
        this.initialize();
        this.fHardware = logoDrawing.getWiringDiagram().getHardware();
    }

    public String getTitle() {
        return Language.getString("dialog.pcLogoPropertyPanel.title", "PC<-->device");
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add(this.getProgramNamePanel(), "North");
        this.add((Component)this.getInputPanel(), "Center");
    }

    private Component getProgramNamePanel() {
        JTextField field = new JTextField();
        field.setEditable(false);
        field.setText(Language.getString("dialog.pcLogoPropertyPanel.hint", "Fieldcontent is available on device:"));
        field.setForeground(Color.BLUE);
        field.setBackground(new JToolTip().getBackground());
        field.setHorizontalAlignment(0);
        return field;
    }

    private JPanel getInputPanel() {
        if (this.fInputPanel == null) {
            try {
                this.fInputPanel = new JPanel();
                this.fInputPanel.setName("InputPanel");
                this.fInputPanel.setLayout(new GridBagLayout());
                int line = 0;
                this.fProgramNameLabel = new JLabel(Language.getString("dialog.properties.generalTab.programName", "Programname:"));
                this.fProgramName = new LengthRestrictedJTextField();
                this.fProgramName.setInitialValue("");
                this.fProgramName.setMaxLength(16);
                this.fProgramName.setMask(LengthRestrictedJTextField.ASCII);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = line;
                gbc.weightx = 0.0;
                gbc.weighty = 0.0;
                gbc.anchor = 17;
                gbc.fill = 2;
                gbc.insets = new Insets(20, 15, 5, 5);
                this.fInputPanel.add((Component)this.fProgramNameLabel, gbc);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = line++;
                gbc.ipadx = 80;
                gbc.weightx = 1.0;
                gbc.weighty = 0.0;
                gbc.anchor = 17;
                gbc.fill = 2;
                gbc.insets = new Insets(20, 5, 5, 5);
                this.fInputPanel.add((Component)this.fProgramName, gbc);
                this.fOldPasswordLabel = new JLabel(Language.getString("dialog.changePassword.oldPassword", "Old Password:"));
                this.fNewPasswordLabel = new JLabel(Language.getString("dialog.changePassword.newPassword", "New Password:"));
                this.fNewPasswordLabel1 = new JLabel(Language.getString("dialog.changePassword.newPassword1", "New Password:"));
                this.fOldPassword = new PasswordField();
                this.fNewPassword = new PasswordField();
                this.fNewPassword.setMaxLength(10);
                this.fNewPassword.setToolTipText(Language.getString("dialog.changePassword.tooltip", "A...Z allowed."));
                this.fNewPassword1 = new PasswordField();
                this.fNewPassword1.setMaxLength(10);
                this.fNewPassword1.setToolTipText(Language.getString("dialog.changePassword.tooltip", "A...Z allowed."));
                this.fPasswordPanel = new BorderJPanel(new GridLayout(3, 2));
                this.fPasswordPanel.setTitle(Language.getString("dialog.pcLogoPropertyPanel.prgPassword", "Program password"));
                this.fPasswordPanel.add(this.fOldPasswordLabel);
                this.fPasswordPanel.add(this.fOldPassword);
                this.fPasswordPanel.add(this.fNewPasswordLabel);
                this.fPasswordPanel.add(this.fNewPassword);
                this.fPasswordPanel.add(this.fNewPasswordLabel1);
                this.fPasswordPanel.add(this.fNewPassword1);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = line++;
                gbc.gridwidth = 2;
                gbc.fill = 2;
                gbc.insets = new Insets(5, 5, 5, 5);
                this.fInputPanel.add((Component)this.fPasswordPanel, gbc);
                this.fStartScreenClockButton = new JRadioButton(Language.getString("dialog.pcLogoPropertyPanel.startScreen.clock", ""));
                this.fStartScreenIOButton = new JRadioButton(Language.getString("dialog.pcLogoPropertyPanel.startScreen.io", "In-/Output"));
                this.fStartScreenPanel = new BorderJPanel(new GridLayout(2, 1));
                this.fStartScreenPanel.setTitle(Language.getString("dialog.pcLogoPropertyPanel.startScreen.label", "Start screen"));
                this.fStartScreenPanel.add(this.fStartScreenClockButton);
                this.fStartScreenPanel.add(this.fStartScreenIOButton);
                ButtonGroup group = new ButtonGroup();
                group.add(this.fStartScreenClockButton);
                group.add(this.fStartScreenIOButton);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = line++;
                gbc.gridwidth = 2;
                gbc.fill = 2;
                gbc.insets = new Insets(5, 5, 5, 5);
                this.fInputPanel.add((Component)this.fStartScreenPanel, gbc);
                this.fAQInStopPanel = new BorderJPanel(new BorderLayout());
                this.fAQInStopPanel.setTitle(Language.getString("dialog.pcLogoPropertyPanel.aqStopModeLabel", "AQ in STOP mode"));
                this.fAnalogOutputPropertyPanel = new AnalogOutputPropertyPanel(this.fModel);
                this.fAQInStopPanel.add(this.fAnalogOutputPropertyPanel);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = line++;
                gbc.gridwidth = 2;
                gbc.fill = 2;
                gbc.insets = new Insets(5, 5, 5, 5);
                this.fInputPanel.add((Component)this.fAQInStopPanel, gbc);
                this.fAQTypePanel = new BorderJPanel(new BorderLayout());
                this.fAQTypePanel.setTitle(Language.getString("dialog.pcLogoPropertyPanel.aqType", "AQ Range Type"));
                this.fAnalogOutputTypePanel = new AnalogOutputTypePanel(this.fModel);
                this.fAQTypePanel.add(this.fAnalogOutputTypePanel);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = line++;
                gbc.gridwidth = 2;
                gbc.fill = 2;
                gbc.insets = new Insets(5, 5, 5, 5);
                this.fInputPanel.add((Component)this.fAQTypePanel, gbc);
                this.fAIPanel = new BorderJPanel(new BorderLayout());
                this.fAIPanel.setTitle(Language.getString("dialog.pcLogoPropertyPanel.AISetting", "AI3 and AI4 setting"));
                this.fAnalogInputArrangePanel = new AnalogInputArrangePanel(this.fModel);
                this.fAIPanel.add(this.fAnalogInputArrangePanel);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = line;
                gbc.gridwidth = 2;
                gbc.fill = 2;
                gbc.insets = new Insets(5, 5, 25, 5);
                this.fInputPanel.add((Component)this.fAIPanel, gbc);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return this.fInputPanel;
    }

    public boolean checkChanged() {
        return !this.fModel.getProgramName().equals(this.fProgramName.getText()) || !this.fModel.getPassword().equals(this.fNewPassword.getText()) || this.fModel.isStartScreenIO() != this.fStartScreenIOButton.isSelected() || this.fAnalogOutputPropertyPanel.checkChanged() || this.fAnalogOutputTypePanel.checkChanged() || this.fAnalogInputArrangePanel.checkChanged();
    }

    public boolean checkFieldContents() {
        return this.fNewPassword.checkFieldContents() && this.fNewPassword1.checkFieldContents() && this.checkPassword() && this.fAnalogOutputPropertyPanel.checkFieldContents() && this.fAnalogOutputTypePanel.checkFieldContents() && this.fAnalogInputArrangePanel.checkFieldContents();
    }

    private boolean checkPassword() {
        if (this.fOldPassword.checkChanged() || this.fNewPassword.checkChanged() || this.fNewPassword1.checkChanged()) {
            if (this.fOldPassword.getText().equals(this.fModel.getPassword())) {
                if (this.fNewPassword.getText().equals(this.fNewPassword1.getText())) {
                    return true;
                }
                new LogoError(this, "dialog.password.wrongNewPassword", "New Passwords are different").display();
                return false;
            }
            new LogoError(this, "dialog.password.wrongOldPassword", "Old Password is wrong").display();
            return false;
        }
        return true;
    }

    public void loadFieldContents() throws ProgramException {
        this.fProgramName.setText(this.fModel.getProgramName());
        this.fOldPassword.setInitialValue("");
        this.fNewPassword.setInitialValue("");
        this.fNewPassword1.setInitialValue("");
        boolean visible = this.fModel.getPassword().length() > 0;
        this.fOldPassword.setEnabled(visible);
        this.fOldPasswordLabel.setEnabled(visible);
        if (this.fModel.isStartScreenIO()) {
            this.fStartScreenIOButton.setSelected(true);
        } else {
            this.fStartScreenClockButton.setSelected(true);
        }
        this.fAnalogOutputPropertyPanel.loadFieldContents();
        this.fAnalogOutputTypePanel.loadFieldContents();
        this.fAnalogInputArrangePanel.loadFieldContents();
    }

    public void storeFieldContents() {
        this.fModel.setProgramName(this.fProgramName.getText());
        if (this.fOldPassword.checkChanged() || this.fNewPassword.checkChanged()) {
            this.fModel.setPassword(this.fNewPassword.getText());
        }
        this.fModel.setStartScreenIO(this.fStartScreenIOButton.isSelected());
        this.fAnalogOutputPropertyPanel.storeFieldContents();
        this.fAnalogOutputTypePanel.storeFieldContents();
        this.fAnalogInputArrangePanel.storeFieldContents();
    }

    public void setLabels() {
        boolean programNameAvailable = this.fHardware.supports("prgName");
        boolean passwortAvailable = this.fHardware.supports("password");
        boolean aqInStopAvailable = this.fHardware.supports("aqStop");
        boolean startScreenAvailable = this.fHardware.supports("startScreen");
        boolean aqTypeAvailable = this.fHardware.supports("aqType");
        boolean aiSettingAvailable = this.fHardware.supports("Analog_4_or_2_config");
        if (!programNameAvailable) {
            this.fProgramName.setVisible(false);
            this.fProgramNameLabel.setVisible(false);
        }
        if (!passwortAvailable) {
            this.fPasswordPanel.setVisible(false);
        }
        if (!startScreenAvailable) {
            this.fStartScreenPanel.setVisible(false);
        }
        if (!aqInStopAvailable) {
            this.fAQInStopPanel.setVisible(false);
        }
        if (!aqTypeAvailable) {
            this.fAQTypePanel.setVisible(false);
        }
        if (!aiSettingAvailable) {
            this.fAIPanel.setVisible(false);
        }
    }

    public boolean hasElements() {
        boolean programNameAvailable = this.fHardware.supports("prgName");
        boolean passwortAvailable = this.fHardware.supports("password");
        boolean aqInStopAvailable = this.fHardware.supports("aqStop");
        boolean startScreenAvailable = this.fHardware.supports("startScreen");
        return programNameAvailable || passwortAvailable || aqInStopAvailable || startScreenAvailable;
    }
}

