/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.app.comp.NumericSpinnerListener;
import DE.siemens.ad.logo.dialog.comp.SpinnerChangedEvent;
import DE.siemens.ad.logo.model.MessageManager;
import DE.siemens.ad.logo.model.block.MessageBlock;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.MessageGlobalInfo;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class MessageGlobalSettingPanel
extends DataInputPanel {
    private static final long serialVersionUID = 1L;
    private MessageGlobalInfo fModel = null;
    private JPanel fMessageGeneral = null;
    private JLabel fMessageLangLabel1 = null;
    private JComboBox fMessageLang1 = null;
    private JLabel fMessageLangLabel2 = null;
    private JComboBox fMessageLang2 = null;
    private JLabel fAnalogInputFilterLabel;
    private JPanel fAnalogInputFilterPanel;
    private JComboBox fAnalogInputFilter;
    private BorderJPanel fTickerTimer = null;
    private LogoDrawing fLogoDrawing = null;
    private Hashtable<String, String> filterTimer = new Hashtable();
    private static Hashtable<String, String> convertFilterTimer = new Hashtable();
    private EditableNumericSpinner cTickerTimer = null;
    private EditableNumericSpinner lTickerTimer = null;
    private JLabel cTickerTimerLabel = null;
    private JLabel lTickerTimerLabel = null;
    private Dimension fPageDimension = null;
    private int fCurCharSetID = 0;
    private ButtonGroup buttonGroup = null;
    private JRadioButton radioButton1 = null;
    private JRadioButton radioButton2 = null;
    private JTextArea character1;
    private JTextArea character2;
    private BorderJPanel infoPanel;
    private BorderJPanel defaultSettingPanel = null;
    private BorderJPanel langBorderPanel = null;
    private JCheckBox useNewFeature = null;
    private JCheckBox useAsDefault = null;

    public MessageGlobalSettingPanel(LogoDrawing logoDrawing) {
        this.fModel = logoDrawing.getWiringDiagram().getMessageGlobalInfo();
        this.fLogoDrawing = logoDrawing;
        this.initialize();
    }

    private void initialize() {
        this.filterTimer.put("1", "100");
        this.filterTimer.put("2", "200");
        this.filterTimer.put("4", "400");
        this.filterTimer.put("8", "800");
        this.filterTimer.put("10", "1000");
        this.setName(Language.getString("dialog.parameter.message.menu.title", "Message Text Setting"));
        this.setBounds(0, 0, 600, 400);
        this.setLayout(this.getPropertyPanelBorderLayout());
        this.setSize(562, 400);
        this.add((Component)this.getGeneral(), "Center");
    }

    private JPanel getGeneral() {
        if (this.fMessageGeneral == null) {
            try {
                this.fMessageGeneral = new JPanel();
                this.fMessageGeneral.setLayout(new GridBagLayout());
                this.fMessageGeneral.setVisible(true);
                this.fMessageGeneral.setMinimumSize(new Dimension(0, 0));
                GridBagConstraints constraintstDefaultPanel = new GridBagConstraints();
                constraintstDefaultPanel.gridx = 0;
                constraintstDefaultPanel.gridy = 0;
                constraintstDefaultPanel.gridheight = 4;
                constraintstDefaultPanel.gridwidth = 3;
                constraintstDefaultPanel.fill = 2;
                constraintstDefaultPanel.anchor = 17;
                constraintstDefaultPanel.insets = new Insets(4, 4, 4, 4);
                this.fMessageGeneral.add((Component)this.getDefaultSettingPanel(), constraintstDefaultPanel);
                GridBagConstraints constraintstTickerTimer = new GridBagConstraints();
                constraintstTickerTimer.gridx = 0;
                constraintstTickerTimer.gridy = 4;
                constraintstTickerTimer.gridheight = 2;
                constraintstTickerTimer.gridwidth = 3;
                constraintstTickerTimer.fill = 2;
                constraintstTickerTimer.anchor = 17;
                constraintstTickerTimer.insets = new Insets(4, 4, 4, 4);
                this.fMessageGeneral.add((Component)this.getTickerTimer(), constraintstTickerTimer);
                GridBagConstraints constraintstAnalogLabel = new GridBagConstraints();
                constraintstAnalogLabel.gridx = 0;
                constraintstAnalogLabel.gridy = 6;
                constraintstAnalogLabel.anchor = 17;
                constraintstAnalogLabel.insets = new Insets(4, 4, 4, 2);
                this.fMessageGeneral.add((Component)this.getAnalogInputFilterPanel(), constraintstAnalogLabel);
                GridBagConstraints constraintstInfo = new GridBagConstraints();
                constraintstInfo.gridx = 0;
                constraintstInfo.gridy = 7;
                constraintstInfo.gridwidth = 3;
                constraintstInfo.gridheight = 6;
                constraintstInfo.fill = 3;
                constraintstInfo.anchor = 17;
                constraintstInfo.insets = new Insets(4, 4, 4, 4);
                this.fMessageGeneral.add((Component)this.getInfoPanel(), constraintstInfo);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.fMessageGeneral;
    }

    private JPanel getInfoPanel() {
        if (null == this.infoPanel) {
            this.infoPanel = new BorderJPanel(new BorderLayout());
            this.infoPanel.setTitle(Language.getString("dialog.parameter.message.menu.supportingLanguage", "Supporting Language"));
            this.character1 = new JTextArea();
            this.character1.setLineWrap(true);
            this.character1.setWrapStyleWord(true);
            this.character1.setEditable(false);
            this.character1.setBackground(this.infoPanel.getBackground());
            this.character1.setColumns(38);
            this.character1.setRows(2);
            this.character2 = new JTextArea();
            this.character2.setLineWrap(true);
            this.character2.setWrapStyleWord(true);
            this.character2.setBackground(this.infoPanel.getBackground());
            this.character2.setColumns(38);
            this.character2.setEditable(false);
            this.character2.setRows(2);
            this.infoPanel.add((Component)this.character1, "North");
            this.infoPanel.add((Component)this.character2, "Center");
        }
        return this.infoPanel;
    }

    private BorderJPanel getTickerTimer() {
        if (this.fTickerTimer == null) {
            try {
                this.fTickerTimer = new BorderJPanel(new GridLayout(2, 1));
                this.fTickerTimer.setTitle(Language.getString("dialog.parameter.message.menu.setMessageTickerTimer", "Ticker Timer Setting"));
                this.cTickerTimer = new EditableNumericSpinner();
                this.cTickerTimer.setName("cTickerTimer");
                this.cTickerTimer.setMinMax(100, 10000);
                this.cTickerTimer.setIncrement(100);
                this.cTickerTimerLabel = new JLabel();
                this.cTickerTimerLabel.setText(Language.getString("dialog.parameter.message.tickerType0", "Character by character"));
                this.lTickerTimer = new EditableNumericSpinner();
                this.lTickerTimer.setName("lTickerTimer");
                this.lTickerTimer.setMinMax(1000, 100000);
                this.lTickerTimer.setIncrement(1000);
                this.lTickerTimer.setEnabled(false);
                this.lTickerTimerLabel = new JLabel();
                this.lTickerTimerLabel.setText(Language.getString("dialog.parameter.message.tickerType1", "Line by line"));
                JLabel cTimeUnit = new JLabel(Language.getString("dialog.parameter.message.menu.tickerTimeUnit", "ms"));
                JLabel lTimeUnit = new JLabel(Language.getString("dialog.parameter.message.menu.tickerTimeUnit", "ms"));
                JPanel cPanel = new JPanel(new FlowLayout(0));
                cPanel.add(this.cTickerTimerLabel);
                cPanel.add(this.cTickerTimer);
                cPanel.add(cTimeUnit);
                JPanel lPanel = new JPanel(new FlowLayout(0));
                lPanel.add(this.lTickerTimerLabel);
                lPanel.add(this.lTickerTimer);
                lPanel.add(lTimeUnit);
                this.fTickerTimer.add(cPanel);
                this.fTickerTimer.add(lPanel);
                this.cTickerTimer.addNumericSpinnerListener(new NumericSpinnerListener(){

                    public void spinnerChanged(SpinnerChangedEvent se) {
                        MessageGlobalSettingPanel.this.lTickerTimer.setValue(MessageGlobalSettingPanel.this.cTickerTimer.getValue() * 10);
                    }
                });
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.fTickerTimer;
    }

    private JPanel getAnalogInputFilterPanel() {
        if (this.fAnalogInputFilterPanel == null) {
            this.fAnalogInputFilterPanel = new JPanel();
            this.fAnalogInputFilterLabel = new JLabel();
            this.fAnalogInputFilterLabel.setText(Language.getString("dialog.parameter.message.menu.setMessageAnalogTimer", "Analog input filter timer"));
            String[] value = new String[]{"100", "200", "400", "800", "1000"};
            this.fAnalogInputFilter = new JComboBox<String>(value);
            this.fAnalogInputFilter.setName("AnalogInputFilter");
            JLabel timeUnit = new JLabel(Language.getString("dialog.parameter.message.menu.tickerTimeUnit", "ms"));
            this.fAnalogInputFilterPanel.add(this.fAnalogInputFilterLabel);
            this.fAnalogInputFilterPanel.add(this.fAnalogInputFilter);
            this.fAnalogInputFilterPanel.add(timeUnit);
        }
        return this.fAnalogInputFilterPanel;
    }

    private JLabel getMessageLangLabel1() {
        if (this.fMessageLangLabel1 == null) {
            try {
                this.fMessageLangLabel1 = new JLabel();
                this.fMessageLangLabel1.setText(Language.getString("dialog.parameter.message.menu.setMessageLanguageLabel1", "Character Set 1:"));
                this.fMessageLangLabel1.setLocation(new Point(8, 27));
                this.fMessageLangLabel1.setMaximumSize(new Dimension(45, 17));
                this.fMessageLangLabel1.setBounds(new Rectangle(8, 27, 120, 15));
                this.fMessageLangLabel1.setMinimumSize(new Dimension(45, 17));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.fMessageLangLabel1;
    }

    private JComboBox getMessageLang1() {
        if (this.fMessageLang1 == null) {
            try {
                String[][] charSetMap = MessageGlobalInfo.getCharSetMap();
                String[] value = new String[charSetMap.length];
                for (int i = 0; i < charSetMap.length; ++i) {
                    value[i] = charSetMap[i][0];
                }
                this.fMessageLang1 = new JComboBox<String>(value);
                this.fMessageLang1.setName("tLangID1");
                this.fMessageLang1.setLocation(new Point(140, 23));
                this.fMessageLang1.setBounds(new Rectangle(140, 23, 247, 19));
                this.fMessageLang1.addItemListener(new CharsetDisselectedListener());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.fMessageLang1;
    }

    private JLabel getMessageLangLabel2() {
        if (this.fMessageLangLabel2 == null) {
            try {
                this.fMessageLangLabel2 = new JLabel();
                this.fMessageLangLabel2.setLocation(new Point(8, 27));
                this.fMessageLangLabel2.setText(Language.getString("dialog.parameter.message.menu.setMessageLanguageLabel2", "Character Set 2:"));
                this.fMessageLangLabel2.setMaximumSize(new Dimension(45, 17));
                this.fMessageLangLabel2.setBounds(new Rectangle(8, 27, 120, 15));
                this.fMessageLangLabel2.setMinimumSize(new Dimension(45, 17));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.fMessageLangLabel2;
    }

    private JComboBox getMessageLang2() {
        if (this.fMessageLang2 == null) {
            try {
                String[][] charSetMap = MessageGlobalInfo.getCharSetMap();
                String[] value = new String[charSetMap.length];
                for (int i = 0; i < MessageGlobalInfo.getCharSetMap().length; ++i) {
                    value[i] = MessageGlobalInfo.getCharSetMap()[i][0];
                }
                this.fMessageLang2 = new JComboBox<String>(value);
                this.fMessageLang2.setName("tLangID2");
                this.fMessageLang2.setLocation(new Point(140, 23));
                this.fMessageLang2.setBounds(new Rectangle(140, 23, 247, 19));
                this.fMessageLang2.addItemListener(new CharsetDisselectedListener());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.fMessageLang2;
    }

    private BorderLayout getPropertyPanelBorderLayout() {
        BorderLayout ivjPropertyPanelBorderLayout = null;
        try {
            ivjPropertyPanelBorderLayout = new BorderLayout();
            ivjPropertyPanelBorderLayout.setVgap(0);
            ivjPropertyPanelBorderLayout.setHgap(0);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjPropertyPanelBorderLayout;
    }

    private void handleException(Throwable exception) {
        exception.printStackTrace();
    }

    public void loadFieldContents() throws ProgramException {
        this.useNewFeature.setSelected(this.fModel.isFUseNewFeature());
        if (!this.fModel.isFUseNewFeature()) {
            this.fMessageLang1.setSelectedItem("ISO_8859_1");
            this.fMessageLang1.setEnabled(false);
            this.fMessageLang2.setEnabled(false);
            this.radioButton1.setSelected(true);
            this.radioButton1.setEnabled(false);
            this.radioButton2.setEnabled(false);
            this.character1.setText(this.fModel.getSupportedLanguage(this.fModel.getSelectedCharSet(0)));
            this.character2.setText("");
        } else {
            this.fCurCharSetID = this.fModel.getCurCharSetID();
            if (1 == this.fCurCharSetID) {
                this.radioButton2.setSelected(true);
            } else {
                this.radioButton1.setSelected(true);
            }
            this.fMessageLang1.setSelectedItem(MessageGlobalInfo.getCharSetName(this.fModel.getSelectedCharSet(0)));
            this.fMessageLang2.setSelectedItem(MessageGlobalInfo.getCharSetName(this.fModel.getSelectedCharSet(1)));
            this.character1.setText(this.fModel.getSupportedLanguage(this.fModel.getSelectedCharSet(0)));
            this.character2.setText(this.fModel.getSupportedLanguage(this.fModel.getSelectedCharSet(1)));
        }
        this.fAnalogInputFilter.setSelectedItem(this.filterTimer.get(new Integer(this.fModel.getAnalogRefreshInterval()).toString()));
        this.cTickerTimer.setValue(this.fModel.getTickerInterval() * 100);
        this.lTickerTimer.setValue(this.fModel.getTickerInterval() * 1000);
    }

    public String getHelpIdString() {
        return "file.messagetextsettings";
    }

    public void storeFieldContents() {
        int lang1 = 0;
        int lang2 = 0;
        if (this.fMessageLang1.getSelectedItem() != null) {
            lang1 = MessageGlobalInfo.getCharSetKey(this.fMessageLang1.getSelectedItem().toString());
        }
        if (this.fMessageLang2.getSelectedItem() != null) {
            lang2 = MessageGlobalInfo.getCharSetKey(this.fMessageLang2.getSelectedItem().toString());
        }
        if (this.fModel.getSelectedCharSet(0) != lang1) {
            this.getMsgManager().transferToNewCharset(0, MessageGlobalInfo.getCharSetKey(this.fMessageLang1.getSelectedItem().toString()));
        }
        if (this.fModel.getSelectedCharSet(1) != lang2) {
            this.getMsgManager().transferToNewCharset(1, MessageGlobalInfo.getCharSetKey(this.fMessageLang2.getSelectedItem().toString()));
        }
        if (convertFilterTimer.isEmpty()) {
            Enumeration<String> keyOfFilterTimer = this.filterTimer.keys();
            while (keyOfFilterTimer.hasMoreElements()) {
                String key = keyOfFilterTimer.nextElement();
                convertFilterTimer.put(this.filterTimer.get(key), key);
            }
        }
        int fAnalogRefreshInterval = 0;
        if (this.fAnalogInputFilter.getSelectedItem() != null) {
            fAnalogRefreshInterval = new Integer(convertFilterTimer.get(this.fAnalogInputFilter.getSelectedItem()));
        }
        if (this.radioButton1.isSelected()) {
            this.fModel.setCurCharSet(0);
        } else {
            this.fModel.setCurCharSet(1);
        }
        this.fModel.setFUseNewFeature(this.useNewFeature.isSelected());
        this.fModel.setSelectedCharSets(lang1, 0);
        this.fModel.setSelectedCharSets(lang2, 1);
        this.fModel.setAnalogRefreshInterval(fAnalogRefreshInterval);
        this.fModel.setTickerInterval(this.cTickerTimer.getValue() / 100);
        if (this.useAsDefault.isSelected()) {
            this.fModel.saveAsDefault();
        }
        this.fLogoDrawing.setModified(true);
        this.updateDrawing();
    }

    private void updateDrawing() {
        MessageBlock[] blocks = this.fLogoDrawing.getWiringDiagram().getMessageManager().getMessageBlocks();
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i].getParameter().fireParameterSetEvent();
        }
    }

    public boolean checkChanged() {
        return this.getMessageLang1().getSelectedItem() != null && this.fModel.getSelectedCharSet(0) == MessageGlobalInfo.getCharSetKey(this.getMessageLang1().getSelectedItem().toString()) || this.getMessageLang2().getSelectedItem() != null && this.fModel.getSelectedCharSet(1) == MessageGlobalInfo.getCharSetKey(this.getMessageLang2().getSelectedItem().toString()) || this.fAnalogInputFilter.getSelectedItem() != null && !new Integer(this.fModel.getTickerInterval()).toString().equals(this.filterTimer.get(this.fAnalogInputFilter.getSelectedItem())) || this.fModel.getTickerInterval() * 100 != this.cTickerTimer.getValue();
    }

    public boolean checkFieldContents() {
        return this.cTickerTimer.checkValue(true);
    }

    public Dimension getPageDimension() {
        if (this.fPageDimension == null) {
            this.fPageDimension = new Dimension(60, 40);
        }
        return this.fPageDimension;
    }

    public void activateParameterTab() {
    }

    private BorderJPanel getDefaultSettingPanel() {
        if (this.defaultSettingPanel == null) {
            this.defaultSettingPanel = new BorderJPanel(new BorderLayout());
            this.buttonGroup = new ButtonGroup();
            this.radioButton1 = new JRadioButton(Language.getString("dialog.parameter.message.menu.setMessageDefaultLabel", "Default"));
            this.radioButton2 = new JRadioButton(Language.getString("dialog.parameter.message.menu.setMessageDefaultLabel", "Default"));
            this.buttonGroup.add(this.radioButton1);
            this.buttonGroup.add(this.radioButton2);
            this.useNewFeature = new JCheckBox();
            this.useNewFeature.setText(Language.getString("dialog.parameter.message.menu.setMessageFeature", "Use new feature"));
            this.useNewFeature.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (MessageGlobalSettingPanel.this.useNewFeature.isSelected()) {
                        LogoError dlg = new LogoError((Component)MessageGlobalSettingPanel.this.fMessageGeneral, "dialog.parameter.message.menu.setToRTFNotification", "New Feature selected. All information in texts will be transferred to new style.\nBut when you want to set back, all information will missing!\nAre you sure to do that?", 2, 2);
                        dlg.setHelpKey("block.Message");
                        int ret = dlg.display();
                        if (ret == 2) {
                            if (MessageGlobalSettingPanel.this.fLogoDrawing.getWiringDiagram().getMessageManager().transferToRTF()) {
                                MessageGlobalSettingPanel.this.radioButton1.setEnabled(true);
                                MessageGlobalSettingPanel.this.radioButton2.setEnabled(true);
                                MessageGlobalSettingPanel.this.fMessageLang1.setEnabled(true);
                                MessageGlobalSettingPanel.this.fMessageLang2.setEnabled(true);
                                MessageGlobalSettingPanel.this.character2.setText(MessageGlobalSettingPanel.this.fModel.getSupportedLanguage(MessageGlobalInfo.getCharSetKey(MessageGlobalSettingPanel.this.fMessageLang2.getSelectedItem().toString())));
                                MessageGlobalSettingPanel.this.character2.setVisible(true);
                            } else {
                                Log.println(Language.getString("dialog.parameter.message.menu.transferFailed", "transfer failed."));
                                MessageGlobalSettingPanel.this.useNewFeature.setSelected(false);
                            }
                        } else {
                            MessageGlobalSettingPanel.this.useNewFeature.setSelected(false);
                        }
                    } else {
                        LogoError dlg = new LogoError((Component)MessageGlobalSettingPanel.this.fMessageGeneral, "dialog.parameter.message.menu.setToNonRTFNotification", "New Feature disselected. All text information will missing!\nAre you sure to do that?", 2, 2);
                        dlg.setHelpKey("block.Message");
                        int ret = dlg.display();
                        if (ret == 2) {
                            if (MessageGlobalSettingPanel.this.fLogoDrawing.getWiringDiagram().getMessageManager().transferToPlain()) {
                                MessageGlobalSettingPanel.this.radioButton1.setSelected(true);
                                MessageGlobalSettingPanel.this.radioButton1.setEnabled(false);
                                MessageGlobalSettingPanel.this.radioButton2.setEnabled(false);
                                MessageGlobalSettingPanel.this.fMessageLang1.setSelectedItem("ISO_8859_1");
                                MessageGlobalSettingPanel.this.fMessageLang1.setEnabled(false);
                                MessageGlobalSettingPanel.this.fMessageLang2.setEnabled(false);
                                MessageGlobalSettingPanel.this.character1.setText(MessageGlobalSettingPanel.this.fModel.getSupportedLanguage(MessageGlobalInfo.getCharSetKey(MessageGlobalSettingPanel.this.fMessageLang1.getSelectedItem().toString())));
                                MessageGlobalSettingPanel.this.character2.setVisible(false);
                            } else {
                                Log.println(Language.getString("dialog.parameter.message.menu.transferFailed", "transfer failed."));
                                MessageGlobalSettingPanel.this.useNewFeature.setSelected(true);
                            }
                        } else {
                            MessageGlobalSettingPanel.this.useNewFeature.setSelected(true);
                        }
                    }
                }
            });
            this.useAsDefault = new JCheckBox();
            this.useAsDefault.setText(Language.getString("dialog.format.default", "Use as default"));
            this.langBorderPanel = new BorderJPanel(new GridLayout(2, 3));
            this.langBorderPanel.setTitle(Language.getString("dialog.parameter.message.menu.setMessageLanguageString", "Language setting"));
            this.langBorderPanel.add(this.getMessageLangLabel1());
            this.langBorderPanel.add(this.getMessageLang1());
            this.langBorderPanel.add(this.radioButton1);
            this.langBorderPanel.add(this.getMessageLangLabel2());
            this.langBorderPanel.add(this.getMessageLang2());
            this.langBorderPanel.add(this.radioButton2);
            this.defaultSettingPanel.add((Component)this.useNewFeature, "North");
            this.defaultSettingPanel.add((Component)this.langBorderPanel, "Center");
            this.defaultSettingPanel.add((Component)this.useAsDefault, "South");
        }
        return this.defaultSettingPanel;
    }

    private MessageManager getMsgManager() {
        return this.fLogoDrawing.getWiringDiagram().getMessageManager();
    }

    private class CharsetDisselectedListener
    implements ItemListener {
        private CharsetDisselectedListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (!MessageGlobalSettingPanel.this.useNewFeature.isSelected()) {
                return;
            }
            if (e.getSource() instanceof JComboBox && e.getStateChange() == 1) {
                int charSetID = e.getSource() == MessageGlobalSettingPanel.this.fMessageLang1 ? 0 : 1;
                int curCharSet = this.getMsgInfo().getSelectedCharSet(charSetID);
                int newCharSet = MessageGlobalInfo.getCharSetKey(((JComboBox)e.getSource()).getSelectedItem().toString());
                if (newCharSet != curCharSet && MessageGlobalSettingPanel.this.getMsgManager().isTextExisted(charSetID)) {
                    LogoError dlg = new LogoError((Component)MessageGlobalSettingPanel.this.fMessageGeneral, "dialog.parameter.message.menu.changeCharSetNotify", "Message text content exists in the deselected character set.\nThis text will be deleted when you deselect this character set.\nDo you want to continue?", 2, 2);
                    int ret = dlg.display();
                    if (ret == 2) {
                        if (charSetID == 0) {
                            MessageGlobalSettingPanel.this.character1.setText(MessageGlobalSettingPanel.this.fModel.getSupportedLanguage(newCharSet));
                        } else {
                            MessageGlobalSettingPanel.this.character2.setText(MessageGlobalSettingPanel.this.fModel.getSupportedLanguage(newCharSet));
                        }
                    } else {
                        ((JComboBox)e.getSource()).setSelectedItem(MessageGlobalInfo.getCharSetName(curCharSet));
                    }
                } else if (charSetID == 0) {
                    MessageGlobalSettingPanel.this.character1.setText(MessageGlobalSettingPanel.this.fModel.getSupportedLanguage(newCharSet));
                } else {
                    MessageGlobalSettingPanel.this.character2.setText(MessageGlobalSettingPanel.this.fModel.getSupportedLanguage(newCharSet));
                }
            }
        }

        private MessageGlobalInfo getMsgInfo() {
            return MessageGlobalSettingPanel.this.fLogoDrawing.getWiringDiagram().getMessageGlobalInfo();
        }
    }
}

