/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.dialog.comp.MessageReceiptListener;
import DE.siemens.ad.logo.dialog.comp.display.AIDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.AIDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.BarDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.BarDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DetailsParameterDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.DisplayCellEditor;
import DE.siemens.ad.logo.dialog.comp.display.DisplayCellEditorListener;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayFocusEvent;
import DE.siemens.ad.logo.dialog.comp.display.DisplayFocusListener;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModelEvent;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModelListener;
import DE.siemens.ad.logo.dialog.comp.display.DisplayToolTipProvider;
import DE.siemens.ad.logo.dialog.comp.display.IONameDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.IONameDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.LogoDisplay;
import DE.siemens.ad.logo.dialog.comp.display.MessageDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.MessageParameterDisplayModelPlain;
import DE.siemens.ad.logo.dialog.comp.display.MessageParameterDisplayModelRTF;
import DE.siemens.ad.logo.dialog.comp.display.MultiLinesDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.MutiCharSetDisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.ParameterItemDisplayCellRenderer;
import DE.siemens.ad.logo.dialog.comp.display.SimulationDisplayCellEditorAllocator;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.MessageManager;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterUpdateEvent;
import DE.siemens.ad.logo.model.ParameterUpdateListener;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.MessageLine;
import DE.siemens.ad.logo.util.ValueOrItemReference;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;

public class MessageDisplay
extends BorderJPanel
implements Comparable,
ParameterUpdateListener {
    private JToggleButton fBtDetails;
    private JToggleButton fBtEditParameterItemValue;
    private LogoDisplay fLogoDisplay;
    private MessageLine[] fMessageModel;
    private MessageParameter fMessageParameter;
    private JCheckBox fReceiptCheckbox = null;
    private ArrayList fMessageReceiptListener;
    private JPanel fDisplayContainer = null;
    private JComponent fButtonPanel;
    private Timer fTickerTimer;
    private Timer fAnalogFilterTimer;
    private TickerDisplayModel[] fTickerDisplayModels;
    private static DisplayModel fNoMessageModel;

    protected MessageDisplay() {
        this.initialize();
        this.registerListners();
    }

    public void activateDeactivateEditButton() {
        DisplayElement displayElement = this.fLogoDisplay.getModel().getElementAt(this.fLogoDisplay.getFocusPosition());
        if (displayElement instanceof ParameterItem && displayElement.isEditable()) {
            if (((ParameterItem)displayElement).getValue() instanceof ValueOrItemReference && ((ValueOrItemReference)((ParameterItem)displayElement).getValue()).isReference()) {
                this.fBtEditParameterItemValue.setEnabled(false);
                return;
            }
            this.fBtEditParameterItemValue.setEnabled(true);
        } else {
            this.fBtEditParameterItemValue.setEnabled(false);
        }
    }

    private void registerListners() {
        this.fBtDetails.addActionListener(new DetailsButtonHandler());
        this.fLogoDisplay.addDisplayFocusListener(new DisplayFocusListener(){

            public void displayFocusPositionChanged(DisplayFocusEvent displayFocusEvent) {
                MessageDisplay.this.activateDeactivateEditButton();
            }
        });
        this.fBtEditParameterItemValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Point focusPosition = MessageDisplay.this.fLogoDisplay.getFocusPosition();
                MessageDisplay.this.fLogoDisplay.editCellAt(focusPosition.y, focusPosition.x, new EventObject(MessageDisplay.this.fLogoDisplay));
                DisplayCellEditor displayCellEditor = MessageDisplay.this.fLogoDisplay.getCurrentCellEditor();
            }
        });
        this.getReceiptCheckbox().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                MessageDisplay.this.fireMessageReceiptEvent();
            }
        });
        this.fLogoDisplay.addDisplayCellEditorListener(new DisplayCellEditorHandler());
    }

    public MessageDisplay(MessageParameter messageParameter) {
        this();
        this.setMessageParameter(messageParameter);
        this.setMessageModel(messageParameter.getMessage());
        this.fLogoDisplay.setFocusPosition(new Point(0, 0));
        this.activateDeactivateEditButton();
    }

    public void activateUpdate() {
        MessageManager msgManager = this.getMessageManager();
        MessageParameterDisplayModelPlain mpdm = null;
        if (msgManager.isRTFMessage()) {
            this.fTickerDisplayModels = new TickerDisplayModel[2];
            if (this.getMessageParameter().getMessageRTF(0) != null) {
                this.fTickerDisplayModels[0] = new TickerDisplayModel(this.getMessageParameter(), 0);
            }
            if (this.getMessageParameter().getMessageRTF(1) != null) {
                this.fTickerDisplayModels[1] = new TickerDisplayModel(this.getMessageParameter(), 1);
            }
            this.updateDisplayModelRTF();
            this.initTickerTimer();
            this.initAnalogFilterTimer();
        } else {
            mpdm = new MessageParameterDisplayModelPlain(this.getMessageParameter());
            this.getLogoDisplay().setModel(mpdm);
            mpdm.addAsParameterUpdateListener();
            mpdm.addAsParameterSetListener(this.getMessageParameter());
        }
        Dimension dm = this.getLogoDisplay().getPreferredSize();
        this.setPreferredSize(new Dimension(dm.width * 2, dm.height * 2));
    }

    public boolean updateDisplayModelRTF() {
        if (!this.getMessageManager().isRTFMessage() || this.fTickerDisplayModels == null) {
            return false;
        }
        MessageManager msgManager = this.getMessageManager();
        DisplayModel mpdm = this.fTickerDisplayModels[msgManager.getActiveCurCharSetID()];
        if (mpdm == null) {
            mpdm = this.getNoMessageModel();
        }
        if (mpdm != this.getLogoDisplay().getModel()) {
            if (this.getLogoDisplay().getModel() instanceof MessageDisplayModel) {
                ((MessageDisplayModel)this.getLogoDisplay().getModel()).removeAsParameterUpdateListener();
                ((MessageDisplayModel)this.getLogoDisplay().getModel()).removeAsParameterSetListener(this.getMessageParameter());
            }
            this.getLogoDisplay().setModel(mpdm);
            if (mpdm instanceof MessageDisplayModel) {
                ((MessageDisplayModel)mpdm).addAsParameterUpdateListener();
                ((MessageDisplayModel)mpdm).addAsParameterSetListener(this.getMessageParameter());
            }
            return true;
        }
        return false;
    }

    private DisplayModel getNoMessageModel() {
        if (fNoMessageModel == null) {
            fNoMessageModel = new MultiLinesDisplayModel(new Dimension(12, 4));
            String noMsg = "No message  for current charset";
            for (int i = 0; i < noMsg.length(); ++i) {
                fNoMessageModel.setElementAt(new DefaultDisplayElement(Character.valueOf(noMsg.charAt(i)), 1, 1), new Point(i % 12, (i + 1) / 12));
            }
        }
        return fNoMessageModel;
    }

    private MessageManager getMessageManager() {
        return this.getMessageParameter().getBlock().getWiringDiagram().getMessageManager();
    }

    public void addMessageReceiptListener(MessageReceiptListener newMessageReceiptListener) {
        if (this.fMessageReceiptListener == null) {
            this.fMessageReceiptListener = new ArrayList(4);
        }
        if (!this.fMessageReceiptListener.contains(newMessageReceiptListener)) {
            this.fMessageReceiptListener.add(newMessageReceiptListener);
        }
    }

    public int compareTo(Object obj) {
        return Integer.valueOf(this.getName()).compareTo(Integer.valueOf(((MessageDisplay)obj).getName()));
    }

    public void deactivateUpdate() {
        if (this.getLogoDisplay().getModel() instanceof MessageDisplayModel) {
            ((MessageDisplayModel)this.getLogoDisplay().getModel()).removeAsParameterUpdateListener();
            ((MessageDisplayModel)this.getLogoDisplay().getModel()).removeAsParameterSetListener(this.fMessageParameter);
        }
        if (this.getMessageManager().isRTFMessage()) {
            this.fTickerTimer.cancel();
            this.fAnalogFilterTimer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMessageReceiptEvent() {
        if (this.getReceiptCheckbox().isSelected() && this.fMessageReceiptListener != null) {
            ArrayList list;
            MessageDisplay messageDisplay = this;
            synchronized (messageDisplay) {
                list = (ArrayList)this.fMessageReceiptListener.clone();
            }
            Iterator e = list.iterator();
            while (e.hasNext()) {
                ((MessageReceiptListener)e.next()).messageReceipt(this);
            }
        }
    }

    private JPanel getDisplayContainer() {
        if (this.fDisplayContainer == null) {
            this.fDisplayContainer = new JPanel();
            this.fDisplayContainer.setName("DummyPanelWest");
            this.fDisplayContainer.setLayout(new BorderLayout());
            JPanel fFixSizePanel = new JPanel();
            fFixSizePanel.add(this.getLogoDisplay());
            this.fDisplayContainer.add((Component)new JScrollPane(fFixSizePanel), "Center");
            this.fDisplayContainer.add((Component)this.getButtonPanel(), "North");
        }
        return this.fDisplayContainer;
    }

    public JComponent getButtonPanel() {
        if (this.fButtonPanel == null) {
            this.fButtonPanel = new JToolBar();
            ((JToolBar)this.fButtonPanel).setFloatable(false);
            this.fBtDetails = new JToggleButton("Details");
            this.fButtonPanel.add(this.fBtDetails);
            this.fBtEditParameterItemValue = new JToggleButton(Global.getIcon("Editable.gif"));
            this.fButtonPanel.add(this.fBtEditParameterItemValue);
        }
        return this.fButtonPanel;
    }

    public LogoDisplay getLogoDisplay() {
        if (this.fLogoDisplay == null) {
            this.fLogoDisplay = new LogoDisplay();
            this.fLogoDisplay.setDynamicCellDimensionEnabled(false);
            this.fLogoDisplay.setSimulationMode(true);
            this.fLogoDisplay.setCellRenderer(ParameterItem.class, new ParameterItemDisplayCellRenderer());
            this.fLogoDisplay.setCellRenderer(BarDisplayElement.class, new BarDisplayCellRenderer());
            this.fLogoDisplay.setCellRenderer(IONameDisplayElement.class, new IONameDisplayCellRenderer());
            this.fLogoDisplay.setCellRenderer(AIDisplayElement.class, new AIDisplayCellRenderer());
            try {
                SimulationDisplayCellEditorAllocator editorAllocator = new SimulationDisplayCellEditorAllocator();
                this.fLogoDisplay.setDisplayCellEditorAllocator(editorAllocator);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fLogoDisplay.setToolTipProvider(new SimulationDisplayToolTipProvider());
        }
        return this.fLogoDisplay;
    }

    private MessageLine[] getMessageModel() {
        if (this.fMessageModel == null) {
            this.fMessageModel = new MessageLine[0];
        }
        return this.fMessageModel;
    }

    public MessageParameter getMessageParameter() {
        return this.fMessageParameter;
    }

    private JCheckBox getReceiptCheckbox() {
        if (this.fReceiptCheckbox == null) {
            try {
                this.fReceiptCheckbox = new JCheckBox();
                this.fReceiptCheckbox.setName("ReceiptCheckbox");
                this.fReceiptCheckbox.setText("Receipt");
                this.fReceiptCheckbox.setActionCommand("");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.fReceiptCheckbox;
    }

    private void handleException(Throwable exception) {
    }

    private void initialize() {
        this.setName("MessageDisplay");
        this.setLayout(new BorderLayout());
        this.add((Component)this.getReceiptCheckbox(), "South");
        this.add((Component)this.getDisplayContainer(), "Center");
    }

    private void initTickerTimer() {
        this.resetTicker();
        this.fTickerTimer = new Timer();
        this.fTickerTimer.schedule(new TimerTask(){

            public void run() {
                DisplayModel model = MessageDisplay.this.getLogoDisplay().getModel();
                if (model instanceof TickerDisplayModel) {
                    ((TickerDisplayModel)model).ticker();
                }
            }
        }, 0L, (long)this.getTickerInterval());
    }

    private void resetTicker() {
        if (this.fTickerDisplayModels == null) {
            return;
        }
        for (int i = 0; i < this.fTickerDisplayModels.length; ++i) {
            if (this.fTickerDisplayModels[i] == null) continue;
            this.fTickerDisplayModels[i].resetTicker();
        }
    }

    private int getTickerInterval() {
        int scale = 100;
        return this.fMessageParameter.getBlock().getWiringDiagram().getMessageGlobalInfo().getTickerInterval() * 100;
    }

    private void initAnalogFilterTimer() {
        this.fAnalogFilterTimer = new Timer();
        this.fAnalogFilterTimer.schedule(new TimerTask(){

            public void run() {
                DisplayModel model = MessageDisplay.this.getLogoDisplay().getModel();
                boolean hasAIFilter = false;
                for (int i = 0; i < model.getDisplayDimension().width; ++i) {
                    for (int j = 0; j < model.getDisplayDimension().height; ++j) {
                        DisplayElement disp = model.getElementAt(new Point(i, j));
                        if (!(disp instanceof AIDisplayElement)) continue;
                        hasAIFilter = true;
                        ((AIDisplayElement)disp).updateFilter();
                    }
                }
                if (hasAIFilter) {
                    MessageDisplay.this.getLogoDisplay().repaint();
                }
            }
        }, 0L, (long)this.getAnalogFilterTime());
    }

    private int getAnalogFilterTime() {
        int scale = 100;
        int ret = this.fMessageParameter.getBlock().getWiringDiagram().getMessageGlobalInfo().getAnalogRefreshInterval() * 100;
        if (ret == 0) {
            System.err.println("Error analog filter time");
            ret = 100;
        }
        return ret;
    }

    public boolean isChecked() {
        return this.getReceiptCheckbox().isSelected();
    }

    public boolean isReceiptVisible() {
        return this.getReceiptCheckbox().isVisible();
    }

    public void parameterUpdated(ParameterUpdateEvent pue) {
        boolean receptEnabled = false;
        if (pue.getEventSource().equals("I0")) {
            receptEnabled = !((MessageParameter)pue.getSource()).getEnableInput();
            final boolean re = receptEnabled;
            Runnable r = new Runnable(){

                public void run() {
                    MessageDisplay.this.setReceiptEnabled(re);
                }
            };
            SwingUtilities.invokeLater(r);
            if (this.fLogoDisplay != null && this.getMessageManager().isRTFMessage()) {
                this.fLogoDisplay.repaint();
            }
        } else if (pue.getEventSource().equals("timeUpdated")) {
            this.fLogoDisplay.repaint();
        }
    }

    public void removeMessageReceiptListener(MessageReceiptListener messageReceiptListener) {
        this.fMessageReceiptListener.remove(messageReceiptListener);
    }

    public void resetReceipt() {
        if (this.fMessageParameter.isReceipt()) {
            this.getReceiptCheckbox().setSelected(false);
        }
    }

    public void setEnabled(boolean status) {
        super.setEnabled(status);
        if (status) {
            this.setReceiptEnabled(this.fMessageParameter.isReceiptAllowed());
        }
        this.resetTicker();
    }

    public void setLabels() {
        this.setTitle(Language.getString("dialog.parameter.message.messageBorder", "Display"));
        this.getReceiptCheckbox().setText(Language.getString("dialog.messageDisplay.receipt", "Receipt"));
        this.fBtDetails.setText(Language.getString("dialog.parameter.message.details", "Details"));
    }

    private void setMessageModel(MessageLine[] messages) {
        this.fMessageModel = messages;
    }

    private void setMessageParameter(MessageParameter newMessageParameter) {
        this.fMessageParameter = newMessageParameter;
        this.getReceiptCheckbox().setVisible(this.fMessageParameter.isReceipt());
        this.getReceiptCheckbox().setSelected(this.fMessageParameter.isReceiptAllowed());
    }

    public void setReceiptEnabled(boolean value) {
        this.getReceiptCheckbox().setEnabled(value);
    }

    public void setReceiptVisible(boolean value) {
        this.getReceiptCheckbox().setVisible(value);
        this.getReceiptCheckbox().setEnabled(this.fMessageParameter.isReceiptAllowed());
    }

    public String toString() {
        StringBuffer str = new StringBuffer(this.getMessageParameter().toString());
        return str.delete(7, 16).toString();
    }

    protected static class TickerDisplayModel
    implements MessageDisplayModel,
    MutiCharSetDisplayModel {
        private int[] fDeltas;
        private int fTickerTimes = 0;
        private transient long[] fTickerDelay;
        MessageParameterDisplayModelRTFExt fModel = null;

        public TickerDisplayModel(MessageParameter messageParameter, int charSetID) {
            this.fModel = new MessageParameterDisplayModelRTFExt(messageParameter, charSetID);
            this.fDeltas = new int[this.fModel.getDisplayDimension().height];
            this.fTickerDelay = new long[this.fDeltas.length];
            this.fModel.removeAsParameterUpdateListener();
            this.fModel.addAsParameterUpdateListener();
        }

        public Dimension getDisplayDimension() {
            Dimension ret = new Dimension(this.fModel.getDisplayDimension());
            ret.width = this.getScreenSize();
            return ret;
        }

        private int getScreenSize() {
            return this.fModel.getDisplayDimension().width / 2;
        }

        private Point getRealPoing(Point location) {
            Point ret = new Point(location);
            ret.x += this.fDeltas[location.y];
            return ret;
        }

        public Rectangle getElementBounds(Point location) {
            Point newPoint = this.getRealPoing(location);
            if (newPoint.x < 0 || newPoint.y < 0) {
                System.err.println("getElementBounds(): Error location");
                return new Rectangle();
            }
            Rectangle ret = this.fModel.getElementBounds(newPoint);
            ret.x -= newPoint.x - location.x;
            if (ret.x + ret.width <= 0) {
                System.err.println("TickerDisplayModel: Error element bound;");
                ret.x = 1 - ret.width;
            }
            return ret;
        }

        public DisplayElement getElementAt(Point location) {
            return this.fModel.getElementAt(this.getRealPoing(location));
        }

        public boolean setElementAt(DisplayElement element, Point position) {
            return false;
        }

        public void resetTicker() {
            for (int i = 0; i < this.fDeltas.length; ++i) {
                this.fDeltas[i] = 0;
            }
            this.fTickerTimes = 0;
        }

        public void ticker() {
            ++this.fTickerTimes;
            boolean hasTickerLine = false;
            for (int i = 0; i < this.fDeltas.length; ++i) {
                if (!this.isTickerLine(i)) continue;
                if (this.isTickerByChar()) {
                    if (this.isScreenStart(i) && this.fTickerDelay[i] == 0L) {
                        this.fTickerDelay[i] = System.currentTimeMillis();
                        continue;
                    }
                    if (System.currentTimeMillis() - this.fTickerDelay[i] <= 2000L) continue;
                    this.stepChar(i);
                    this.fTickerDelay[i] = 0L;
                    hasTickerLine = true;
                    continue;
                }
                if (this.fTickerTimes < 10) continue;
                this.stepToNextScreen(i);
                hasTickerLine = true;
            }
            if (this.fTickerTimes >= 10) {
                this.fTickerTimes = 0;
            }
            if (hasTickerLine) {
                this.fModel.fireModelChangedEvent();
            }
        }

        private boolean isScreenStart(int lineNum) {
            return this.fDeltas[lineNum] == this.getScreenSize() || this.fDeltas[lineNum] == 0;
        }

        private void stepChar(int lineNum) {
            int stepLength = 0;
            int returnPoint = this.getScreenSize() + 1;
            stepLength = this.fModel.isBiWidthCharacterset() ? 2 : 1;
            int n = lineNum;
            this.fDeltas[n] = this.fDeltas[n] + stepLength;
            int n2 = lineNum;
            this.fDeltas[n2] = this.fDeltas[n2] % returnPoint;
        }

        private void stepToNextScreen(int lineNum) {
            this.fDeltas[lineNum] = this.fDeltas[lineNum] == 0 ? this.getScreenSize() : 0;
        }

        private MessageParameter.MessageText getMessageText() {
            return this.fModel.getMessageParameter().getMessageRTF(this.fModel.getCharSetID());
        }

        private boolean isTickerLine(int line) {
            if (this.getMessageText() != null) {
                return this.getMessageText().getMessageLineRTF()[line].isTickerLine();
            }
            return false;
        }

        private boolean isTickerByChar() {
            if (this.getMessageText() != null) {
                return this.getMessageText().getTickerType() == 0;
            }
            return false;
        }

        public String getErrorInsertString() {
            return this.fModel.getErrorInsertString();
        }

        public Hashtable getSpecialCharactersTable() {
            return this.fModel.getSpecialCharactersTable();
        }

        public void addAsParameterSetListener(MessageParameter msgParam) {
            this.fModel.addAsParameterSetListener(msgParam);
        }

        public void removeAsParameterSetListener(MessageParameter msgParam) {
            this.fModel.removeAsParameterSetListener(msgParam);
        }

        public void addAsParameterUpdateListener() {
            this.fModel.addAsParameterUpdateListener();
        }

        public void removeAsParameterUpdateListener() {
            this.fModel.removeAsParameterUpdateListener();
        }

        public void addDisplayModelListener(DisplayModelListener displayModelListener) {
            this.fModel.addDisplayModelListener(displayModelListener);
        }

        public void removeDisplayModelListener(DisplayModelListener displayModelListener) {
            this.fModel.removeDisplayModelListener(displayModelListener);
        }

        public boolean isCellEditable(Point location) {
            DisplayElement displayElement = this.getElementAt(location);
            if (displayElement == null) {
                return false;
            }
            return displayElement.isEditable();
        }

        public boolean canInsert(DisplayElement displayElement, Point destination) {
            return false;
        }

        public boolean copyCells(List cells, Point destination) {
            return false;
        }

        public boolean deleteCells(List cells) {
            return false;
        }

        public boolean deleteElement(Point location) {
            return false;
        }

        public boolean insertElement(DisplayElement value, Point position) {
            return false;
        }

        public boolean moveCells(List cells, Point destination) {
            return false;
        }

        public void setDisplayDimension(Dimension displayDimension) {
        }

        public int getCharSet() {
            return this.fModel.getCharSet();
        }

        public boolean isBiWidthCharacterset() {
            return this.fModel.isBiWidthCharacterset();
        }

        public void setCharSet(int charSet) {
            this.fModel.setCharSet(charSet);
        }

        private static class MessageParameterDisplayModelRTFExt
        extends MessageParameterDisplayModelRTF {
            private long lastPaintTime = 0L;
            private final int REFRESH_TIME = 100;

            public MessageParameterDisplayModelRTFExt(MessageParameter messageParameter, int charSetID) {
                super(messageParameter, charSetID);
            }

            public void fireModelChangedEvent() {
                super.fireModelChangedEvent();
            }

            protected void fireModelChangedEvent(DisplayModelEvent displayModelEvent) {
                if (displayModelEvent.getArea() == null) {
                    super.fireModelChangedEvent(displayModelEvent);
                    return;
                }
                if (System.currentTimeMillis() - this.lastPaintTime > 100L) {
                    this.lastPaintTime = System.currentTimeMillis();
                    this.fireModelChangedEvent();
                }
            }
        }
    }

    protected class SimulationDisplayToolTipProvider
    implements DisplayToolTipProvider {
        protected SimulationDisplayToolTipProvider() {
        }

        public String getToolTipText(LogoDisplay display, DisplayElement displayElement) {
            if (displayElement instanceof ParameterItem) {
                ParameterItem parameterItem = (ParameterItem)displayElement;
                BlockParameter parameter = parameterItem.getParameter();
                boolean editable = parameterItem.isEditable() && !MessageDisplay.this.fMessageParameter.getProtection();
                StringBuffer tooltip = new StringBuffer("<html><b>");
                tooltip.append(parameter.getBlock().getNumberString()).append(" " + parameterItem.getLocalisedName()).append("</b>");
                if (parameterItem.getParameterValueType() == 1) {
                    String actualUrlString = this.getClass().getResource("/DE/siemens/ad/logo/images/Refresh.gif").toString();
                    tooltip.append("<img src=\"").append(actualUrlString).append("\" alt=\"actual value\">");
                }
                if (editable && parameter instanceof ProtectionParameter && ((ProtectionParameter)parameter).getProtection()) {
                    editable = false;
                }
                if (editable) {
                    String cutUrlString = this.getClass().getResource("/DE/siemens/ad/logo/images/Editable.gif").toString();
                    tooltip.append("<img src=\"").append(cutUrlString).append("\" alt=\"editable\">");
                    tooltip.append("<br>(").append(Language.getString("dialog.messageDisplay.tooltip.doubleClickToEdit", "Doubleclick to edit")).append(")");
                }
                tooltip.append("<p>");
                tooltip.append(Language.getString("dialog.messageDisplay.tooltip.useRightMouse", "Use right mouse button!"));
                return tooltip.append("</html>").toString();
            }
            return null;
        }
    }

    protected class DetailsButtonHandler
    implements ActionListener {
        protected DetailsButtonHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (MessageDisplay.this.fBtDetails.isSelected()) {
                MessageDisplay.this.getLogoDisplay().setCellRenderer(ParameterItem.class, new DetailsParameterDisplayCellRenderer());
            } else {
                MessageDisplay.this.getLogoDisplay().setCellRenderer(ParameterItem.class, new ParameterItemDisplayCellRenderer());
            }
            MessageDisplay.this.getLogoDisplay().repaint();
        }
    }

    protected class DisplayCellEditorHandler
    implements DisplayCellEditorListener {
        protected DisplayCellEditorHandler() {
        }

        public void editingStarted(ChangeEvent e) {
            MessageDisplay.this.fBtEditParameterItemValue.setSelected(true);
        }

        public void editingCanceled(ChangeEvent e) {
            MessageDisplay.this.fBtEditParameterItemValue.setSelected(false);
        }

        public void editingStopped(ChangeEvent e) {
            MessageDisplay.this.fBtEditParameterItemValue.setSelected(false);
        }
    }
}

