/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.DoubleNumericSpinner;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.app.comp.NumericSpinnerListener;
import DE.siemens.ad.logo.dialog.comp.Measurement;
import DE.siemens.ad.logo.dialog.comp.SpinnerChangedEvent;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.logo.util.Util;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class MeasurementPanel
extends DataInputPanel {
    private Hashtable fSensorPanelDictionary;
    private Measurement.Sensor fSensor;
    private JPanel fSensorsPanel;
    private SensorPanel fCurrentSensorPanel;
    private JLabel fLblSensorSelectionLabel;
    private Measurement fMeasurement;
    private JComboBox fCbxSensor;
    private JPanel fSensorSelectionPanel;

    public MeasurementPanel() {
        this.initComponents();
        this.initListeners();
        this.fSensorPanelDictionary = new Hashtable();
    }

    public MeasurementPanel(Measurement measurement) {
        this();
        this.fMeasurement = measurement;
    }

    private void setSensor(Measurement.Sensor sensor) {
        if (this.fCurrentSensorPanel != null) {
            this.fCurrentSensorPanel.storeFieldContents();
        }
        sensor.loadPropertiesFrom(this.fSensor);
        this.fSensor = sensor;
        this.fCurrentSensorPanel = this.getSensorPanel(sensor);
        this.fCurrentSensorPanel.setSensor(sensor);
        this.fCurrentSensorPanel.setLabels();
        try {
            this.fCurrentSensorPanel.loadFieldContents();
        }
        catch (ProgramException programException) {
            // empty catch block
        }
        ((CardLayout)this.fSensorsPanel.getLayout()).show(this.fSensorsPanel, sensor.getNameKey());
        this.fCurrentSensorPanel = this.getSensorPanel(sensor);
    }

    private SensorPanel getSensorPanel(Measurement.Sensor sensor) {
        if (!this.fSensorPanelDictionary.containsKey(sensor.getClass())) {
            SensorPanel sensorPanel = null;
            if (sensor.getClass() == Measurement.Sensor0to10V.class) {
                sensorPanel = new SensorAdjustableMeasurementRangePanel();
            }
            if (sensor.getClass() == Measurement.Sensor4to20mA.class) {
                sensorPanel = new SensorAdjustableMeasurementRangePanel();
            }
            if (sensor.getClass() == Measurement.Sensor0to20mA.class) {
                sensorPanel = new SensorAdjustableMeasurementRangePanel();
            }
            if (sensor.getClass() == Measurement.SensorPT100.class) {
                sensorPanel = new SensorPT100Panel();
            }
            if (sensor.getClass() == Measurement.SensorPT100Invers.class) {
                sensorPanel = new SensorPT100Panel();
            }
            if (sensorPanel == null) {
                sensorPanel = new SensorPanel();
            }
            this.fSensorPanelDictionary.put(sensor.getClass(), sensorPanel);
        }
        return (SensorPanel)this.fSensorPanelDictionary.get(sensor.getClass());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.fSensorSelectionPanel = new JPanel(new BorderLayout(5, 0));
        this.fLblSensorSelectionLabel = new JLabel("Sensor");
        this.fCbxSensor = new JComboBox();
        this.fCbxSensor.setRenderer(new SensorListCellRenderer());
        this.fSensorSelectionPanel.add((Component)this.fLblSensorSelectionLabel, "West");
        this.fSensorSelectionPanel.add((Component)this.fCbxSensor, "Center");
        this.add((Component)this.fSensorSelectionPanel, "North");
        this.fSensorsPanel = new JPanel(new CardLayout());
        this.add((Component)this.fSensorsPanel, "Center");
    }

    private void initListeners() {
        this.fCbxSensor.addItemListener(new SensorSelectionHandler());
    }

    public void loadFieldContents() throws ProgramException {
        try {
            this.fSensor = (Measurement.Sensor)this.fMeasurement.getSensor().clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        DefaultComboBoxModel<Measurement.Sensor> sensorModel = new DefaultComboBoxModel<Measurement.Sensor>();
        for (Measurement.Sensor currentSensor : this.fMeasurement.getAvailableSensors()) {
            if (currentSensor.getClass() == this.fSensor.getClass()) {
                sensorModel.addElement(this.fSensor);
            } else {
                sensorModel.addElement(currentSensor);
            }
            this.fSensorsPanel.add((Component)this.getSensorPanel(currentSensor), currentSensor.getNameKey());
        }
        this.fCbxSensor.setModel(sensorModel);
        if (this.fSensor != null) {
            this.fCbxSensor.setSelectedItem(this.fSensor);
        }
        this.setSensor(this.fSensor);
    }

    public void storeFieldContents() {
        this.fCurrentSensorPanel.storeFieldContents();
        try {
            this.fMeasurement.setSensor((Measurement.Sensor)this.fSensor.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    public void setLabels() {
        super.setLabels();
        this.fLblSensorSelectionLabel.setText(Language.getString("comp.measurement.sensorBorder", "Sensor"));
    }

    public void setModel(Measurement measurement) {
        this.fMeasurement = measurement;
    }

    public boolean checkValue(boolean message) {
        return this.fCurrentSensorPanel.checkFieldContents();
    }

    public boolean checkChanged() {
        this.fCurrentSensorPanel.storeFieldContents();
        if (this.fMeasurement.getSensor().getClass() != this.fSensor.getClass()) {
            return true;
        }
        return !this.fMeasurement.getSensor().equalTo(this.fSensor);
    }

    public JPanel getSensorSelectionPanel() {
        return this.fSensorSelectionPanel;
    }

    private static class SensorPanel
    extends DataInputPanel {
        protected BorderJPanel fGainOffsetPanel;
        private JLabel fLblPercent;
        protected DoubleNumericSpinner fGainSpinner;
        protected EditableNumericSpinner fOffsetSpinner;
        private JLabel fLblGain;
        private JLabel fLblOffset;
        protected Measurement.Sensor fPanelSensor;

        public SensorPanel() {
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            this.fGainOffsetPanel = new BorderJPanel(new GridBagLayout());
            GridBagConstraints gbc = null;
            this.fLblGain = new JLabel("Gain");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            this.fGainOffsetPanel.add((Component)this.fLblGain, gbc);
            this.fGainSpinner = new DoubleNumericSpinner();
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 5, 0, 5);
            this.fGainOffsetPanel.add((Component)this.fGainSpinner, gbc);
            this.fLblPercent = new JLabel("%");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            this.fGainOffsetPanel.add((Component)this.fLblPercent, gbc);
            this.fLblOffset = new JLabel("Offset");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.anchor = 17;
            this.fGainOffsetPanel.add((Component)this.fLblOffset, gbc);
            this.fOffsetSpinner = new EditableNumericSpinner();
            this.fOffsetSpinner.setColumns(6);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 5, 0, 5);
            this.fGainOffsetPanel.add((Component)this.fOffsetSpinner, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            this.add(this.fGainOffsetPanel);
            gbc = new GridBagConstraints();
            gbc.gridx = 10;
            gbc.gridy = 10;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.add((Component)new JPanel(), gbc);
        }

        public void loadFieldContents() throws ProgramException {
            double quotient = 1.0;
            String pattern = null;
            Measurement.AnalogCalculationMethod analogCalculationMethod = this.fPanelSensor.getAnalogCalculationMethod();
            if (analogCalculationMethod.getClass() == Measurement.AnalogCalculation0BA5.class) {
                quotient = 100.0;
                pattern = "##.##";
                this.fLblPercent.setVisible(false);
            } else if (analogCalculationMethod.getClass() == Measurement.AnalogCalculation0BA4.class) {
                quotient = 100.0;
                pattern = "##.##";
                this.fLblPercent.setVisible(false);
            } else {
                pattern = "####";
                this.fLblPercent.setVisible(true);
            }
            if (analogCalculationMethod.getGainBounds().getMin() < 0) {
                pattern = "-" + pattern;
            }
            this.fGainSpinner.setPattern(pattern);
            IntValueProperties gainProperties = this.fPanelSensor.getGainProperties();
            double minGain = (double)gainProperties.getMin() / quotient;
            double maxGain = (double)gainProperties.getMax() / quotient;
            this.fGainSpinner.setMax(maxGain);
            this.fGainSpinner.setMin(minGain);
            this.fGainSpinner.setIncrement(1.0 / quotient);
            this.fGainSpinner.setValue((double)gainProperties.getCurrentValue() / quotient);
            String invalidValue = Language.getString("error.dialog.invalidFloatValue", "invalidValue", new Object[]{new Double((double)gainProperties.getMin() / quotient), new Double((double)gainProperties.getMax() / quotient)});
            this.fGainSpinner.setError(new LogoError(this, invalidValue));
            this.fGainSpinner.setToolTipText(Language.getString("comp.spinner.tooltip", "", new Object[]{new Double(minGain), new Double(maxGain)}));
            this.fOffsetSpinner.setProperties(this.fPanelSensor.getOffsetProperties());
        }

        public boolean checkFieldContents() {
            return super.checkFieldContents() && this.fGainSpinner.checkValue(true) && this.fOffsetSpinner.checkValue(true);
        }

        public boolean checkChanged() {
            return super.checkChanged() || this.fGainSpinner.checkChanged() || this.fOffsetSpinner.checkChanged();
        }

        public void setLabels() {
            super.setLabels();
            this.fLblGain.setText(Language.getString("comp.measurement.gain", "Gain"));
            this.fLblOffset.setText(Language.getString("comp.measurement.offset", "Offset"));
            this.fGainOffsetPanel.setTitle(Language.getString("comp.measurement.parameterBorder", "Parameter"));
        }

        public void storeFieldContents() {
            int quotient = 100;
            if (this.fPanelSensor.getAnalogCalculationMethod().getClass() == Measurement.AnalogCalculation0BA3.class) {
                quotient = 1;
            }
            this.fPanelSensor.setGainOffset((int)Math.round(this.fGainSpinner.getValue() * (double)quotient), this.fOffsetSpinner.getValue());
        }

        public Measurement.Sensor getPanelSensor() {
            return this.fPanelSensor;
        }

        public void setSensor(Measurement.Sensor sensor) {
            this.fPanelSensor = sensor;
        }
    }

    private class SensorSelectionHandler
    implements ItemListener {
        private SensorSelectionHandler() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                Measurement.Sensor selectedSensor = (Measurement.Sensor)MeasurementPanel.this.fCbxSensor.getSelectedItem();
                MeasurementPanel.this.setSensor(selectedSensor);
            }
        }
    }

    private static class SensorAdjustableMeasurementRangePanel
    extends SensorPanel {
        private boolean fRecalculatingValues;
        protected JTextArea fMessageLabel;
        protected BorderJPanel fMeasurementRangePanel;
        protected EditableNumericSpinner fMinSpinner;
        protected EditableNumericSpinner fMaxSpinner;
        private JLabel fLblMin;
        private JLabel fLblMax;

        public SensorAdjustableMeasurementRangePanel() {
            this.initComponents();
            this.initListeners();
        }

        private void initComponents() {
            this.removeAll();
            this.fMeasurementRangePanel = new BorderJPanel(new GridBagLayout());
            GridBagConstraints gbc = null;
            this.fLblMin = new JLabel("Min");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            this.fMeasurementRangePanel.add((Component)this.fLblMin, gbc);
            this.fMinSpinner = new EditableNumericSpinner();
            this.fMinSpinner.setColumns(6);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 5, 0, 5);
            this.fMeasurementRangePanel.add((Component)this.fMinSpinner, gbc);
            this.fLblMax = new JLabel("Max");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.anchor = 13;
            this.fMeasurementRangePanel.add((Component)this.fLblMax, gbc);
            this.fMaxSpinner = new EditableNumericSpinner();
            this.fMaxSpinner.setColumns(6);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 5, 0, 5);
            this.fMeasurementRangePanel.add((Component)this.fMaxSpinner, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            this.add((Component)this.fMeasurementRangePanel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            this.add((Component)this.fGainOffsetPanel, gbc);
            this.fMessageLabel = new JTextArea("");
            this.fMessageLabel.setLineWrap(true);
            this.fMessageLabel.setWrapStyleWord(true);
            this.fMessageLabel.setEditable(false);
            this.fMessageLabel.setFocusable(false);
            this.fMessageLabel.setBorder(null);
            this.fMessageLabel.setForeground(Color.RED);
            this.fMessageLabel.setPreferredSize(new Dimension(25, 50));
            this.fMessageLabel.setMinimumSize(new Dimension(25, 50));
            this.fMessageLabel.setOpaque(false);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 3;
            gbc.fill = 1;
            gbc.insets = new Insets(10, 10, 10, 10);
            gbc.anchor = 11;
            this.add((Component)this.fMessageLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 10;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.add((Component)new JPanel(), gbc);
        }

        private void initListeners() {
            NumericSpinnerListener changeListener = new NumericSpinnerListener(){

                public void spinnerChanged(SpinnerChangedEvent se) {
                    SensorAdjustableMeasurementRangePanel.this.recalculateValues(se.getSource());
                }
            };
            this.fMaxSpinner.addNumericSpinnerListener(changeListener);
            this.fMinSpinner.addNumericSpinnerListener(changeListener);
            this.fGainSpinner.addNumericSpinnerListener(changeListener);
            this.fOffsetSpinner.addNumericSpinnerListener(changeListener);
        }

        private void recalculateValues(Object source) {
            if (!this.fRecalculatingValues) {
                this.fRecalculatingValues = true;
                Measurement.SensorAdjustableMeasurementRange sensor = (Measurement.SensorAdjustableMeasurementRange)this.fPanelSensor;
                if (source == this.fOffsetSpinner || source == this.fGainSpinner) {
                    super.storeFieldContents();
                    this.fMaxSpinner.setValue(sensor.getMaxAmplifiedValue());
                    this.fMinSpinner.setValue(sensor.getMinAmplifiedValue());
                    this.fMessageLabel.setText("");
                }
                if (source == this.fMinSpinner || source == this.fMaxSpinner) {
                    boolean possible = sensor.setMinMaxAmplifiedValue(this.fMinSpinner.getValue(), this.fMaxSpinner.getValue());
                    try {
                        super.loadFieldContents();
                    }
                    catch (ProgramException e) {
                        e.printStackTrace();
                    }
                    if (!possible) {
                        String s = Language.getString("error.dialog.adjustMeasurementRange", "Rounding error in measurement range.\nUsed: % to %", new Object[]{new Integer(sensor.getMinAmplifiedValue()), new Integer(sensor.getMaxAmplifiedValue())});
                        this.fMessageLabel.setText(s);
                    } else {
                        this.fMessageLabel.setText("");
                    }
                }
                this.fRecalculatingValues = false;
            }
        }

        public void loadFieldContents() throws ProgramException {
            this.fRecalculatingValues = true;
            super.loadFieldContents();
            this.fMinSpinner.setProperties(this.fPanelSensor.getMinAmplifiedValueProperties());
            this.fMaxSpinner.setProperties(this.fPanelSensor.getMaxAmplifiedValueProperties());
            this.fRecalculatingValues = false;
        }

        public void storeFieldContents() {
            Measurement.SensorAdjustableMeasurementRange sensor = (Measurement.SensorAdjustableMeasurementRange)this.fPanelSensor;
            sensor.setGainOffset((int)(this.fGainSpinner.getValue() * 100.0), this.fOffsetSpinner.getValue());
            sensor.setMinMaxAmplifiedValue(this.fMinSpinner.getValue(), this.fMaxSpinner.getValue());
        }

        public void setLabels() {
            super.setLabels();
            this.fLblMin.setText(Language.getString("comp.measurement.minMeasuredValue", "Minimum"));
            this.fLblMax.setText(Language.getString("comp.measurement.maxMeasuredValue", "Maximum"));
            this.fMeasurementRangePanel.setTitle(Language.getString("comp.measurement.measurementBorder", "Measurement range"));
        }

        public boolean checkFieldContents() {
            return super.checkFieldContents() && this.fMaxSpinner.checkValue(true) && this.fMinSpinner.checkValue(true);
        }

        public boolean checkChanged() {
            return super.checkChanged() || this.fMinSpinner.checkChanged() || this.fMaxSpinner.checkChanged();
        }
    }

    private static class SensorPT100Panel
    extends SensorAdjustableMeasurementRangePanel {
        private BorderJPanel fUnitPanel;
        private JRadioButton fRbFarenheit;
        private JRadioButton fRbCelsius;
        private BorderJPanel fResolutionPanel;
        private JRadioButton fRbOneDegree;
        private JRadioButton fRbTenthDegree;

        public SensorPT100Panel() {
            this.initComponents();
            this.initListeners();
        }

        private void initComponents() {
            this.fUnitPanel = new BorderJPanel();
            this.fUnitPanel.setLayout(new BoxLayout(this.fUnitPanel, 1));
            this.fRbCelsius = new JRadioButton("Celsius");
            this.fRbFarenheit = new JRadioButton("Farenheit");
            ButtonGroup unitGroup = new ButtonGroup();
            unitGroup.add(this.fRbCelsius);
            unitGroup.add(this.fRbFarenheit);
            this.fUnitPanel.add(this.fRbCelsius);
            this.fUnitPanel.add(this.fRbFarenheit);
            this.fResolutionPanel = new BorderJPanel();
            this.fResolutionPanel.setLayout(new BoxLayout(this.fResolutionPanel, 1));
            this.fRbOneDegree = new JRadioButton("x 1");
            this.fRbTenthDegree = new JRadioButton("x 0.1");
            ButtonGroup resolutionGroup = new ButtonGroup();
            resolutionGroup.add(this.fRbOneDegree);
            resolutionGroup.add(this.fRbTenthDegree);
            this.fResolutionPanel.add(this.fRbOneDegree);
            this.fResolutionPanel.add(this.fRbTenthDegree);
            GridBagConstraints gbc = null;
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            this.add((Component)this.fUnitPanel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.weightx = 1.0;
            gbc.fill = 1;
            this.add((Component)this.fResolutionPanel, gbc);
            Util.setEnabledRecursive(this.fGainOffsetPanel, false);
            Util.setEnabledRecursive(this.fMeasurementRangePanel, false);
            this.fMessageLabel.setVisible(false);
        }

        private void initListeners() {
            ActionListener changeListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SensorPT100Panel.this.storeFieldContents();
                    try {
                        SensorPT100Panel.this.loadFieldContents();
                    }
                    catch (ProgramException e1) {
                        e1.printStackTrace();
                    }
                }
            };
            this.fRbCelsius.addActionListener(changeListener);
            this.fRbFarenheit.addActionListener(changeListener);
            this.fRbOneDegree.addActionListener(changeListener);
            this.fRbTenthDegree.addActionListener(changeListener);
        }

        public void loadFieldContents() throws ProgramException {
            super.loadFieldContents();
            Measurement.SensorPT100 pt100 = (Measurement.SensorPT100)this.fPanelSensor;
            this.fRbTenthDegree.setSelected(pt100.isHighResolution());
            this.fRbOneDegree.setSelected(!pt100.isHighResolution());
            if (pt100.getUnit().equals("farenheit")) {
                this.fRbFarenheit.setSelected(true);
            } else {
                this.fRbCelsius.setSelected(true);
            }
        }

        public void storeFieldContents() {
            Measurement.SensorPT100 pt100 = (Measurement.SensorPT100)this.fPanelSensor;
            pt100.setHighResolution(this.fRbTenthDegree.isSelected());
            if (this.fRbCelsius.isSelected()) {
                pt100.setUnit("celsius");
            }
            if (this.fRbFarenheit.isSelected()) {
                pt100.setUnit("farenheit");
            }
        }

        public void setLabels() {
            super.setLabels();
            this.fResolutionPanel.setTitle(Language.getString("comp.measurement.resolutionBorder", "Resolution"));
            this.fRbOneDegree.setText(Language.getString("comp.measurement.resolution1", "x 1"));
            this.fRbTenthDegree.setText(Language.getString("comp.measurement.resolution01", "x 0.1"));
            this.fUnitPanel.setTitle(Language.getString("comp.measurement.unitBorder", "Unit"));
            this.fRbCelsius.setText(Language.getString("comp.measurement.celsiusButton", "Celsius"));
            this.fRbFarenheit.setText(Language.getString("comp.measurement.farenheitButton", "Farenheit"));
        }
    }

    private class SensorListCellRenderer
    extends DefaultListCellRenderer {
        private SensorListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Measurement.Sensor) {
                Measurement.Sensor sensor = (Measurement.Sensor)value;
                this.setText(Language.getString(sensor.getNameKey(), sensor.getName()));
            }
            return this;
        }
    }
}

