/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.dialog.comp.BlockListCellRenderer;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.ValueOrItemReference;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class IntegerOrReferencePanel
extends JPanel {
    ValueOrItemReference fValue;
    EditableNumericSpinner fIntValueField;
    JToggleButton fReferenceButton = null;
    protected JComboBox fReferenceList;
    protected JPanel fInputPanel;
    protected CardLayout fInputManager;

    public IntegerOrReferencePanel() {
        this.initialize();
    }

    protected void initialize() {
        this.setLayout(new GridBagLayout());
        this.fInputManager = new CardLayout(1, 1);
        this.fInputPanel = new JPanel(this.fInputManager);
        this.add(this.fInputPanel);
        JPanel intPanel = new JPanel(new FlowLayout(2));
        this.fInputPanel.add((Component)intPanel, "Value");
        this.fIntValueField = new EditableNumericSpinner();
        this.fIntValueField.setColumns(6);
        intPanel.add(this.fIntValueField);
        this.fReferenceList = new JComboBox();
        this.fInputPanel.add((Component)this.fReferenceList, "Reference");
        BlockListCellRenderer renderer = new BlockListCellRenderer(true);
        renderer.setScale(0.7f);
        this.fReferenceList.setRenderer(renderer);
        this.fReferenceButton = new JToggleButton("Reference");
        this.fReferenceButton.addActionListener(new ReferenceButtonListener());
        this.add(this.fReferenceButton);
        this.setLabels();
    }

    protected void setLabels() {
        this.fReferenceButton.setText(Language.getString("integerOrReferencePanel.referenceButtonText", "Reference"));
    }

    public boolean checkValue(boolean b) {
        return this.fIntValueField.checkValue(b);
    }

    public boolean checkChanged() {
        if (this.fValue.isReference() != this.fReferenceButton.isSelected()) {
            return true;
        }
        if (((IntegerOrBlockReference)this.fValue).getIntValueProperties().getCurrentValue() != this.fIntValueField.getValue()) {
            return true;
        }
        return this.fValue.isReference() && this.fValue.getReference() != this.fReferenceList.getSelectedItem();
    }

    public void setProperties(IntegerOrBlockReference properties) {
        this.fValue = properties;
        boolean reference = properties.isReference();
        if (reference) {
            this.selectItemInReferenceList(properties);
            this.fReferenceButton.setSelected(true);
        }
        this.fIntValueField.setProperties(properties.getIntValueProperties());
        this.setReference(reference);
    }

    protected void selectItemInReferenceList(ValueOrItemReference value) {
        ParameterItem item;
        int i;
        ParameterItem newItem = value.getReference();
        ComboBoxModel model = this.fReferenceList.getModel();
        int size = model.getSize();
        for (i = 0; i < size && !this.equalItems(item = (ParameterItem)model.getElementAt(i), newItem); ++i) {
        }
        this.fReferenceList.setSelectedIndex(i);
    }

    protected boolean equalItems(ParameterItem item1, ParameterItem item2) {
        return item1.getParameterNumber() == item2.getParameterNumber() && item1.getParameter().getBlock().getNumber() == item2.getParameter().getBlock().getNumber();
    }

    public IntegerOrBlockReference getValue() {
        IntegerOrBlockReference result = new IntegerOrBlockReference();
        if (this.fReferenceButton.isSelected()) {
            result.setReference((ParameterItem)this.fReferenceList.getSelectedItem());
        } else {
            result.setIntValue(this.fIntValueField.getValue());
        }
        return result;
    }

    public void setReferenceVisability(boolean visable) {
        this.fReferenceButton.setVisible(visable);
    }

    protected void setReference(boolean referenceEnabled) {
        if (referenceEnabled) {
            this.fInputManager.last(this.fInputPanel);
        } else {
            this.fInputManager.first(this.fInputPanel);
        }
        this.validate();
    }

    public JComboBox getReferenceList() {
        return this.fReferenceList;
    }

    public void setReferenceList(ArrayList paramItems) {
        this.fReferenceList.setModel(new DefaultComboBoxModel<Object>(paramItems.toArray()));
        this.fReferenceButton.setEnabled(paramItems.size() > 0);
    }

    protected void referenceButtonPressed(boolean b) {
        this.setReference(this.fReferenceButton.isSelected());
    }

    public class ReferenceButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            IntegerOrReferencePanel.this.referenceButtonPressed(IntegerOrReferencePanel.this.fReferenceButton.isSelected());
        }
    }
}

