/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class IconCheckBox
extends JPanel
implements ActionListener {
    protected JCheckBox fCheckBox;
    protected JButton fButton;

    public IconCheckBox() {
        this.initializeComponents();
    }

    public IconCheckBox(String text) {
        this.initializeComponents();
        this.getButton().setText(text);
    }

    public IconCheckBox(String text, Icon icon) {
        this.initializeComponents();
        this.getButton().setText(text);
        this.getButton().setIcon(icon);
    }

    protected void initializeComponents() {
        this.setLayout(new FlowLayout(0, 2, 1));
        this.add(this.getCheckBox());
        this.getButton().setBorderPainted(false);
        this.add(this.getButton());
        this.setOpaque(false);
        this.setBackground(Color.blue);
        this.getButton().addActionListener(this);
    }

    public boolean isSelected() {
        return this.getCheckBox().isSelected();
    }

    public void setSelected(boolean selected) {
        this.getCheckBox().setSelected(selected);
        this.getButton().setSelected(selected);
    }

    public void setText(String text) {
        this.getButton().setText(text);
    }

    public void setOpaque(boolean opaque) {
        super.setOpaque(opaque);
        this.getCheckBox().setOpaque(opaque);
        this.getButton().setOpaque(opaque);
    }

    public String getText() {
        return this.getButton().getText();
    }

    public void setIcon(Icon icon) {
        this.getButton().setIcon(icon);
    }

    public void paintComponent(Graphics g) {
        super.setOpaque(this.hasFocus());
        if (this.hasFocus()) {
            this.setBackground(Color.blue);
        }
        super.paintComponent(g);
    }

    public Icon getIcon() {
        return this.getButton().getIcon();
    }

    protected JButton getButton() {
        if (this.fButton == null) {
            this.fButton = new JButton();
            this.fButton.setMargin(new Insets(2, 3, 2, 2));
            this.fButton.setBorder(null);
            this.fButton.setFocusPainted(false);
        }
        return this.fButton;
    }

    protected JCheckBox getCheckBox() {
        if (this.fCheckBox == null) {
            this.fCheckBox = new JCheckBox(){

                public boolean isFocusTraversable() {
                    return false;
                }
            };
            this.fCheckBox.setFocusPainted(false);
            this.fCheckBox.setMargin(new Insets(0, 0, 0, 0));
        }
        return this.fCheckBox;
    }

    public void actionPerformed(ActionEvent e) {
        this.getCheckBox().setSelected(!this.getCheckBox().isSelected());
    }

    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.getCheckBox().setToolTipText(text);
        this.getButton().setToolTipText(text);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

