/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.app.comp.NumericSpinnerListener;
import DE.siemens.ad.logo.dialog.comp.SpinnerChangedEvent;
import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.model.AnalogMathsParameter;
import DE.siemens.ad.logo.util.Language;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class EnOutputOptionsPanel
extends DataInputPanel {
    private Analog fAnalog;
    private JLabel fLblDescription;
    private EditableNumericSpinner fDecimalPlacesSpinner;
    private JLabel fLblPreview;
    private int optionID;
    private JRadioButton[] options;
    private String[] optionLabels = new String[]{"0", Language.getString("dialog.parameter.analogMaths.lastValue", "Last Value")};
    protected JPanel fInputPanel;
    protected CardLayout fInputManager;

    public EnOutputOptionsPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.fInputManager = new CardLayout(1, 1);
        this.fInputPanel = new JPanel(this.fInputManager);
        this.add(this.fInputPanel);
        JPanel intPanel = new JPanel(new FlowLayout(2));
        this.fInputPanel.add((Component)intPanel, "Value");
        this.fLblDescription = new JLabel("   " + Language.getString("dialog.parameter.analogMaths.lastValuePre", "When En='0', output is") + " ");
        intPanel.add(this.fLblDescription);
        Action[] action = new Action[2];
        ButtonGroup optionsGroup = new ButtonGroup();
        this.options = new JRadioButton[2];
        for (int i = 0; i < this.options.length; ++i) {
            action[i] = new AbstractAction(this.optionLabels[i]){

                public void actionPerformed(ActionEvent evt) {
                    for (int j = 0; j < EnOutputOptionsPanel.this.optionLabels.length; ++j) {
                        if (!evt.getActionCommand().equals(EnOutputOptionsPanel.this.optionLabels[j])) continue;
                        EnOutputOptionsPanel.this.setOptionID(j);
                        break;
                    }
                }
            };
            this.options[i] = new JRadioButton(action[i]);
            optionsGroup.add(this.options[i]);
            this.add(this.options[i]);
        }
        this.setOptionID(0);
        this.options[0].setSelected(true);
    }

    public void setLabels() {
        this.fLblDescription.setText(Language.getString("dialog.parameter.analogTrigger.decimalPlaces", "Decimal places:"));
    }

    public void setOptionID(int optionID) {
        this.optionID = optionID;
    }

    public int getOptionID() {
        return this.optionID;
    }

    public boolean checkFieldContents() {
        return this.fDecimalPlacesSpinner.checkValue(true);
    }

    public boolean checkChanged() {
        return ((AnalogMathsParameter)this.fAnalog).getEnOutputOptionID() != this.optionID;
    }

    public void setAnalog(Analog analog) {
        this.fAnalog = analog;
    }

    public void loadFieldContents() {
        if (this.fAnalog == null) {
            throw new IllegalStateException("Before a EnOutputOptionsPanel can be use a Reference to an Analog block must be set with 'setAnalog'");
        }
        this.setOptionID(((AnalogMathsParameter)this.fAnalog).getEnOutputOptionID());
        this.options[((AnalogMathsParameter)this.fAnalog).getEnOutputOptionID()].setSelected(true);
    }

    public void storeFieldContents() {
        if (this.fAnalog == null) {
            throw new IllegalStateException("Before using a EnOutputOptionsPanel you have to set a reference to an AnalogBlockParameter with 'setAnalog'");
        }
        ((AnalogMathsParameter)this.fAnalog).setEnOutputOptionID(this.optionID);
    }

    private class DecimalPlacesSpinnerHandler
    implements NumericSpinnerListener {
        private DecimalPlacesSpinnerHandler() {
        }

        public void spinnerChanged(SpinnerChangedEvent se) {
            if (EnOutputOptionsPanel.this.fDecimalPlacesSpinner.checkValue(true)) {
                // empty if block
            }
        }
    }
}

