/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.app.comp.NumericSpinnerListener;
import DE.siemens.ad.logo.dialog.comp.SpinnerChangedEvent;
import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.util.Language;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DecimalPlacePanel
extends DataInputPanel {
    private Analog fAnalog;
    private JLabel fLblDescription;
    private EditableNumericSpinner fDecimalPlacesSpinner;
    private JLabel fLblPreview;

    public DecimalPlacePanel() {
        this.initComponents();
        this.initListeners();
    }

    private void initListeners() {
        this.fDecimalPlacesSpinner.addNumericSpinnerListener(new DecimalPlacesSpinnerHandler());
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 0));
        this.fLblDescription = new JLabel("Number of decimal places:");
        this.add(this.fLblDescription);
        this.add(Box.createHorizontalStrut(5));
        this.fDecimalPlacesSpinner = new EditableNumericSpinner();
        this.fDecimalPlacesSpinner.setMaximumSize(this.fDecimalPlacesSpinner.getPreferredSize());
        this.add(this.fDecimalPlacesSpinner);
        this.add(Box.createHorizontalStrut(10));
        this.fLblPreview = new JLabel();
        Font font = this.fLblPreview.getFont();
        this.fLblPreview.setFont(new Font(font.getName(), 1, 14));
        this.add(this.fLblPreview);
        this.setPreviewLabelText();
        this.add(Box.createGlue());
        this.add(new JPanel());
    }

    public void setLabels() {
        this.fLblDescription.setText(Language.getString("dialog.parameter.analogTrigger.decimalPlaces", "Decimal places:"));
    }

    private String getAnalogValueString(int decimalPlaces) {
        int value = 12345;
        char sign = value < 0 ? (char)'-' : '+';
        value = Math.abs(value);
        int width = 5;
        StringBuffer sb = new StringBuffer(Integer.toString(value));
        while (sb.length() < width) {
            sb.insert(0, "0");
        }
        if (decimalPlaces > 0) {
            sb.insert(sb.length() - decimalPlaces, ".");
        }
        sb.insert(0, sign);
        return sb.toString();
    }

    public boolean checkFieldContents() {
        return this.fDecimalPlacesSpinner.checkValue(true);
    }

    public boolean checkChanged() {
        return this.fDecimalPlacesSpinner.getValue() != this.fAnalog.getDecimalPlace();
    }

    public void setAnalog(Analog analog) {
        this.fAnalog = analog;
    }

    public void loadFieldContents() {
        if (this.fAnalog == null) {
            throw new IllegalStateException("Before a DecimalPlacePanel can be use a Reference to an Analog block must be set with 'setAnalog'");
        }
        this.fDecimalPlacesSpinner.setProperties(this.fAnalog.getDecimalPlaceProperties());
        this.setVisible(this.fAnalog.isAnalogValueDecimalPlacesAvailable());
        this.setPreviewLabelText();
    }

    public void storeFieldContents() {
        if (this.fAnalog == null) {
            throw new IllegalStateException("Before using a DecimalPlacePanel you have to set a reference to an AnalogBlockParameter with 'setAnalog'");
        }
        this.fAnalog.setDecimalPlace(this.fDecimalPlacesSpinner.getValue());
    }

    private void setPreviewLabelText() {
        this.fLblPreview.setText(this.getAnalogValueString(this.fDecimalPlacesSpinner.getValue()));
    }

    private class DecimalPlacesSpinnerHandler
    implements NumericSpinnerListener {
        private DecimalPlacesSpinnerHandler() {
        }

        public void spinnerChanged(SpinnerChangedEvent se) {
            if (DecimalPlacePanel.this.fDecimalPlacesSpinner.checkValue(true)) {
                DecimalPlacePanel.this.setPreviewLabelText();
            }
        }
    }
}

