/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.model.PropertiesIfc;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.MaskFormatter;
import javax.swing.text.NumberFormatter;

public class AnalogOutputPropertyPanel
extends DataInputPanel {
    private JCheckBox fLastValue;
    private JSpinner fFixedValue1;
    private JSpinner fFixedValue2;
    private JLabel fFixedValue2Label;
    private JLabel fFixedValue1Label;
    private PropertiesIfc fModel;

    public AnalogOutputPropertyPanel(PropertiesIfc model) {
        this.fModel = model;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        JPanel lastValuePanel = new JPanel(new GridLayout(2, 1));
        this.add((Component)lastValuePanel, "North");
        this.fLastValue = new JCheckBox(Language.getString("analogOutputPanel.lastValue", "Use last value"));
        lastValuePanel.add(this.fLastValue);
        JPanel fixedValuePanel = new JPanel(new GridLayout(2, 2));
        lastValuePanel.add((Component)fixedValuePanel, "South");
        this.fFixedValue1Label = new JLabel(Language.getString("analogOutputPanel.fixedValueLabel1", "AQ1 Fixed value (0..10V)"));
        fixedValuePanel.add(this.fFixedValue1Label);
        SpinnerNumberModel model = new SpinnerNumberModel(0.0, 0.0, 10.0, 0.2);
        this.fFixedValue1 = new JSpinner(model);
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter("##.00");
        }
        catch (ParseException e) {
            // empty catch block
        }
        JFormattedTextField formattedTextField = new JFormattedTextField(formatter);
        this.fFixedValue1.setEditor(formattedTextField);
        JSpinner.NumberEditor ne = new JSpinner.NumberEditor(this.fFixedValue1, "##.##");
        DecimalFormat decimalFormat = ne.getFormat();
        decimalFormat.setMinimumFractionDigits(2);
        decimalFormat.setDecimalSeparatorAlwaysShown(true);
        NumberFormatterFactory formatterFactory = new NumberFormatterFactory(model, decimalFormat);
        ne.getTextField().setFormatterFactory(formatterFactory);
        this.fFixedValue1.setEditor(ne);
        this.fFixedValue1.setToolTipText(Language.getString("analogOutputPanel.fixedValueTooltip", "0...10V"));
        fixedValuePanel.add(this.fFixedValue1);
        this.fFixedValue2Label = new JLabel(Language.getString("analogOutputPanel.fixedValueLabel2", "AQ2 Fixed value (0..10V)"));
        fixedValuePanel.add(this.fFixedValue2Label);
        model = new SpinnerNumberModel(0.0, 0.0, 10.0, 0.2);
        this.fFixedValue2 = new JSpinner(model);
        try {
            formatter = new MaskFormatter("##.00");
        }
        catch (ParseException e) {
            // empty catch block
        }
        formattedTextField = new JFormattedTextField(formatter);
        this.fFixedValue2.setEditor(formattedTextField);
        ne = new JSpinner.NumberEditor(this.fFixedValue2, "##.##");
        decimalFormat = ne.getFormat();
        decimalFormat.setMinimumFractionDigits(2);
        decimalFormat.setDecimalSeparatorAlwaysShown(true);
        formatterFactory = new NumberFormatterFactory(model, decimalFormat);
        ne.getTextField().setFormatterFactory(formatterFactory);
        this.fFixedValue2.setEditor(ne);
        this.fFixedValue2.setToolTipText(Language.getString("analogOutputPanel.fixedValueTooltip", "0...10V"));
        fixedValuePanel.add(this.fFixedValue2);
        this.fLastValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnalogOutputPropertyPanel.this.setEnableDisable();
            }
        });
    }

    public String getTitle() {
        return Language.getString("AnalogOutputPropertyPanel.title", "Analog Output Table");
    }

    public boolean checkChanged() {
        return this.fLastValue.isSelected() != this.fModel.getAnalogOutputLastValueStatus() || ((Double)this.fFixedValue1.getValue()).doubleValue() != this.fModel.getAnalogOutputFixedValue1() || ((Double)this.fFixedValue2.getValue()).doubleValue() != this.fModel.getAnalogOutputFixedValue2();
    }

    public boolean checkFieldContents() {
        double value = (Double)this.fFixedValue1.getValue();
        if (value < 0.0 || value > 10.0) {
            new LogoError(this, "dialog.error.analogOutputProperty.aq1", "Wrong value AQ1").display();
            return false;
        }
        value = (Double)this.fFixedValue2.getValue();
        if (value < 0.0 || value > 10.0) {
            new LogoError(this, "dialog.error.analogOutputProperty.aq2", "Wrong value AQ2").display();
            return false;
        }
        return true;
    }

    public void loadFieldContents() {
        this.fLastValue.setSelected(this.fModel.getAnalogOutputLastValueStatus());
        this.fFixedValue1.setValue(new Double(this.fModel.getAnalogOutputFixedValue1()));
        this.fFixedValue2.setValue(new Double(this.fModel.getAnalogOutputFixedValue2()));
        this.setEnableDisable();
    }

    public void storeFieldContents() {
        this.fModel.setAnalogOutputLastValueStatus(this.fLastValue.isSelected());
        this.fModel.setAnalogOutputFixedValue1((Double)this.fFixedValue1.getValue());
        this.fModel.setAnalogOutputFixedValue2((Double)this.fFixedValue2.getValue());
    }

    private void setEnableDisable() {
        boolean enabledState = !this.fLastValue.isSelected();
        this.fFixedValue1Label.setEnabled(enabledState);
        this.fFixedValue1.setEnabled(enabledState);
        this.fFixedValue2Label.setEnabled(enabledState);
        this.fFixedValue2.setEnabled(enabledState);
    }

    private class LogoNumberEditorFormatter
    extends NumberFormatter {
        private final SpinnerNumberModel model;

        LogoNumberEditorFormatter(SpinnerNumberModel model, NumberFormat format) {
            super(format);
            this.model = model;
            this.setValueClass(model.getValue().getClass());
        }

        public void setMinimum(Comparable min) {
            this.model.setMinimum(min);
        }

        public Comparable getMinimum() {
            return new Double(Double.NEGATIVE_INFINITY);
        }

        public void setMaximum(Comparable max) {
            this.model.setMaximum(max);
        }

        public Comparable getMaximum() {
            return new Double(Double.MAX_VALUE);
        }
    }

    private class NumberFormatterFactory
    extends JFormattedTextField.AbstractFormatterFactory {
        private SpinnerNumberModel fModel;
        private NumberFormat fFormat;

        public NumberFormatterFactory(SpinnerNumberModel model, NumberFormat format) {
            this.fModel = model;
            this.fFormat = format;
        }

        public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
            return new LogoNumberEditorFormatter(this.fModel, this.fFormat);
        }
    }

    private class JSpinnerInputVerifier
    extends InputVerifier {
        private JSpinnerInputVerifier() {
        }

        public boolean verify(JComponent input) {
            return true;
        }
    }
}

