/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.block.PIDBlock;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.GregorianCalendar;
import javax.swing.JPanel;

public class TrendViewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static int numHorizon = 15;
    private static int horizonGranu = 4;
    private static int numValue = numHorizon * horizonGranu + 1;
    private static int numVerti = 6;
    private PIDBlock fBlock = null;
    private String fParamName = null;
    private boolean fIsOnlineTest = false;
    private transient double[] fValues = null;
    private transient int fValueCount = 0;
    private transient double scaleMax = 0.0;
    private transient double scaleMin = 0.0;
    private static int pixScaleX = 5;
    private Point2D origin;
    private Point2D usage;
    private Point2D time;
    private Line2D timeLine;
    private Line2D usageLine1;
    private Line2D usageLine2;
    private String[] times = new String[numHorizon + 1];
    private double[] scaleVer = new double[numVerti + 1];
    private float[] dashPatternVer = new float[]{10.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 10.0f};
    private float[] dashPatternHori = new float[]{12.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f};

    public TrendViewPanel(String title, String paramName, Block block, boolean isOnlineTest) {
        this(title);
        this.fBlock = (PIDBlock)block;
        this.fParamName = paramName;
        this.fIsOnlineTest = isOnlineTest;
    }

    private TrendViewPanel(String title) {
        int i;
        for (i = 0; i < this.times.length; ++i) {
            this.times[i] = "";
        }
        this.setBackground(Color.white);
        this.fValues = new double[numValue];
        for (i = 0; i < this.fValues.length; ++i) {
            this.fValues[i] = 0.0;
        }
        this.origin = new Point2D.Double(50.0, 150.0);
        this.usage = new Point2D.Double(this.origin.getX(), 30.0);
        this.time = new Point2D.Double(this.origin.getX() + (double)(numHorizon * horizonGranu * pixScaleX), this.origin.getY());
        this.timeLine = new Line2D.Double(this.origin, this.time);
        this.usageLine1 = new Line2D.Double(this.origin, this.usage);
        this.usageLine2 = new Line2D.Double(this.time.getX() + 1.0, this.time.getY(), this.time.getX() + 1.0, this.usage.getY());
    }

    private void setMinMax() {
        double max = this.fValues[this.fValues.length - 1];
        double min = this.fValues[this.fValues.length - 1];
        for (int i = this.fValues.length - 1; i >= this.fValues.length - this.fValueCount; --i) {
            if (this.fValues[i] > max) {
                max = this.fValues[i];
            }
            if (!(this.fValues[i] < min)) continue;
            min = this.fValues[i];
        }
        if (max < this.scaleMax && min > this.scaleMin && max > this.scaleMax - (this.scaleMax - this.scaleMin) * 0.8 && min < this.scaleMin + (this.scaleMax - this.scaleMin) * 0.2) {
            return;
        }
        this.scaleMax = max + 0.1 * (max - min) + 3.0;
        this.scaleMin = min - 0.1 * (max - min) - 3.0;
    }

    private double getActualX(int index) {
        return this.origin.getX() + (double)(index * pixScaleX) + 1.0;
    }

    private double getActualY(double value) {
        if (this.scaleMax == this.scaleMin) {
            return this.origin.getY();
        }
        return this.origin.getY() - (value - this.scaleMin) * (this.origin.getY() - this.usage.getY()) / (this.scaleMax - this.scaleMin);
    }

    private void setScaleValue() {
        this.setMinMax();
        double distance = (this.scaleMax - this.scaleMin) / (double)numVerti;
        for (int i = 0; i < numVerti + 1; ++i) {
            this.scaleVer[i] = this.scaleMin + (double)i * distance;
        }
    }

    public void paintComponent(Graphics g) {
        int i;
        int i2;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.fValueCount >= 2) {
            g2.setStroke(new BasicStroke(2.0f));
            g2.setPaint(Color.BLUE);
            this.setScaleValue();
            for (i2 = this.fValues.length - 1; i2 >= this.fValues.length - this.fValueCount + 1; --i2) {
                Line2D.Double temp = new Line2D.Double(this.getActualX(i2), this.getActualY(this.fValues[i2]), this.getActualX(i2 - 1), this.getActualY(this.fValues[i2 - 1]));
                g2.draw(temp);
            }
            g2.setPaint(Color.BLACK);
        }
        g2.draw(this.timeLine);
        g2.draw(this.usageLine1);
        g2.draw(this.usageLine2);
        g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, this.dashPatternVer, 0.0f));
        for (i2 = 0; i2 < numVerti; ++i2) {
            Line2D.Double scaleVer = new Line2D.Double(this.origin.getX() - 5.0, this.origin.getY() - (double)(i2 * 20), this.time.getX() + 5.0, this.origin.getY() - (double)(i2 * 20));
            g2.draw(scaleVer);
        }
        g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, this.dashPatternHori, 0.0f));
        for (i2 = 0; i2 <= numHorizon; ++i2) {
            Line2D.Double scaleHori = new Line2D.Double(this.origin.getX() + (double)(i2 * 20), this.origin.getY() + 10.0, this.origin.getX() + (double)(i2 * 20), this.usage.getY());
            g2.draw(scaleHori);
        }
        g.drawString(this.fParamName, (int)this.origin.getX(), (int)this.usage.getY() - 10);
        FontRenderContext context = g2.getFontRenderContext();
        Font f = g2.getFont();
        for (i = 0; i < this.scaleVer.length; ++i) {
            Rectangle2D bounds = f.getStringBounds((int)this.scaleVer[i] + "", context);
            g2.drawString((int)this.scaleVer[i] + "", (int)(this.origin.getX() - bounds.getWidth() - 10.0), (int)(this.origin.getY() - (double)(i * 20) + 5.0));
            g2.drawString((int)this.scaleVer[i] + "", (int)(this.time.getX() + 10.0), (int)(this.origin.getY() - (double)(i * 20) + 5.0));
        }
        for (i = 0; i < this.times.length; ++i) {
            AffineTransform oldTransform = g2.getTransform();
            g2.transform(AffineTransform.getRotateInstance(Math.toRadians(-90.0), this.time.getX() - (double)(i * 20) + 5.0, this.origin.getY() + 55.0));
            g.drawString(this.times[this.times.length - i - 1], (int)(this.time.getX() - (double)(i * 20) + 5.0), (int)(this.origin.getY() + 55.0));
            g2.setTransform(oldTransform);
        }
    }

    private double getNewData() {
        try {
            if (this.fParamName.equals("AQ")) {
                return this.fBlock.getTrendviewAQ(this.fIsOnlineTest);
            }
            if (this.fParamName.equals("PV")) {
                return this.fBlock.getTrendviewPV(this.fIsOnlineTest);
            }
            return 0.0;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public void nextCycle() {
        if (this.fValueCount < this.fValues.length) {
            ++this.fValueCount;
        }
        for (int i = 1; i < this.fValues.length; ++i) {
            this.fValues[i - 1] = this.fValues[i];
        }
        this.fValues[this.fValues.length - 1] = this.getNewData();
        this.resetTimeStrings();
        this.repaint();
    }

    private void resetTimeStrings() {
        GregorianCalendar now = new GregorianCalendar();
        for (int i = this.times.length - 1; i >= 0; --i) {
            this.times[i] = this.getTimeString(now);
            now.add(13, -1 * horizonGranu * 1);
        }
    }

    private String getTimeString(GregorianCalendar now) {
        int hour = now.get(11);
        int minute = now.get(12);
        int second = now.get(13);
        return (hour > 9 ? "" + hour : "0" + hour) + ":" + (minute > 9 ? "" + minute : "0" + minute) + ":" + (second > 9 ? "" + second : "0" + second);
    }

    private double getLineAverage() {
        if (this.fValueCount == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (int i = this.fValues.length - 1; i >= this.fValues.length - this.fValueCount; --i) {
            sum += this.fValues[i];
        }
        return sum / (double)this.fValueCount;
    }

    public boolean isBlockInfoAvailable() {
        return !this.fIsOnlineTest || this.fBlock.isOnlineTestObserved();
    }

    public void clearHistory() {
        this.fValueCount = 0;
    }

    public String getBlockNumberString() {
        if (this.fBlock != null) {
            return this.fBlock.getNumberString();
        }
        return "";
    }
}

