/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.dialog.comp.DateParameterJPanel;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.ProgramException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class SummerWinterPanel
extends DataInputPanel {
    private EditableNumericSpinner ivjDelay = null;
    private JCheckBox ivjTimeChangeActive = null;
    private JRadioButton ivjUK = null;
    private JRadioButton ivjUS1 = null;
    private JRadioButton ivjUS2 = null;
    private JRadioButton ivjAUS = null;
    private JRadioButton ivjTAS = null;
    private JRadioButton ivjNZ = null;
    private JRadioButton ivjUserDefined = null;
    private BorderJPanel ivjDelayBorder = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private BorderJPanel ivjSummertimeBorder = null;
    private ButtonGroup ivjButtonGroup = null;
    private JRadioButton ivjEU = null;
    private DateParameterJPanel ivjEndDate = null;
    private DateParameterJPanel ivjStartDate = null;
    private BorderJPanel ivjModeBorder = null;
    private int[] fInitialSetting;
    private String fSettingString;

    public SummerWinterPanel() {
        this.initialize();
    }

    public boolean checkChanged() {
        if (this.getSetting() != this.fInitialSetting) {
            return true;
        }
        if (this.getStartDate().checkChanged()) {
            return true;
        }
        if (this.getEndDate().checkChanged()) {
            return true;
        }
        return this.getDelay().checkChanged();
    }

    public boolean checkFieldContents() {
        boolean result = this.getStartDate().checkFieldContents();
        if (result) {
            result = this.getEndDate().checkFieldContents();
        }
        if (result) {
            result = this.getDelay().checkValue(true);
        }
        return result;
    }

    private void connChangeActive_ItemStateChanged(ItemEvent arg1) {
        try {
            this.timeChangeActive_ItemStateChanged(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connUserDefined_itemStateChanged(ItemEvent arg1) {
        try {
            this.enableDisableUserDefinedInput();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void disableSummerWintertimeInputs() {
        this.getModeBorder().setEnabled(false);
        this.getSummertimeBorder().setEnabled(false);
    }

    private void enableDisableUserDefinedInput() {
        this.getSummertimeBorder().setEnabled(this.getUserDefined().isSelected());
    }

    private void enableSummerWintertimeInputs() {
        this.getModeBorder().setEnabled(true);
        this.getEU().setSelected(true);
        this.enableDisableUserDefinedInput();
    }

    private ButtonGroup getButtonGroup() {
        if (this.ivjButtonGroup == null) {
            try {
                this.ivjButtonGroup = new ButtonGroup();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonGroup;
    }

    private EditableNumericSpinner getDelay() {
        if (this.ivjDelay == null) {
            try {
                this.ivjDelay = new EditableNumericSpinner();
                this.ivjDelay.setName("Delay");
                this.ivjDelay.setMax(180);
                this.ivjDelay.setBounds(11, 20, 50, 22);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDelay;
    }

    private BorderJPanel getDelayBorder() {
        if (this.ivjDelayBorder == null) {
            try {
                this.ivjDelayBorder = new BorderJPanel();
                this.ivjDelayBorder.setLayout(new FlowLayout(0));
                this.ivjDelayBorder.setName("DelayBorder");
                this.ivjDelayBorder.setTitleColor(Color.black);
                this.ivjDelayBorder.setBounds(7, 103, 366, 51);
                this.ivjDelayBorder.setTitle("Delay (minutes)");
                this.getDelayBorder().add((Component)this.getDelay(), this.getDelay().getName());
                this.getDelayBorder().add(new JLabel(Language.getString("dialog.setClock.minute", "Minutes")));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDelayBorder;
    }

    private DateParameterJPanel getEndDate() {
        if (this.ivjEndDate == null) {
            try {
                this.ivjEndDate = new DateParameterJPanel();
                this.ivjEndDate.setName("EndDate");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjEndDate;
    }

    private JRadioButton getEU() {
        if (this.ivjEU == null) {
            try {
                this.ivjEU = new JRadioButton();
                this.ivjEU.setName("EU");
                this.ivjEU.setText("Europe");
                this.ivjEU.setIcon(Global.getIcon("EUns.gif"));
                this.ivjEU.setSelectedIcon(Global.getIcon("EU.gif"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjEU;
    }

    private BorderJPanel getModeBorder() {
        if (this.ivjModeBorder == null) {
            try {
                this.ivjModeBorder = new BorderJPanel();
                this.ivjModeBorder.setName("ModeBorder");
                this.ivjModeBorder.setLayout(new GridLayout(0, 2));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjModeBorder;
    }

    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    private int[] getSetting() {
        int[] result = new int[6];
        result[1] = this.getEndDate().getMonth();
        result[2] = this.getEndDate().getDay();
        result[3] = this.getStartDate().getMonth();
        result[4] = this.getStartDate().getDay();
        result[5] = this.getDelay().getValue();
        if (this.getTimeChangeActive().isSelected()) {
            ButtonGroup group = this.getButtonGroup();
            if (group.isSelected(this.getEU().getModel())) {
                result[0] = 1;
                this.fSettingString = "EU";
            } else if (group.isSelected(this.getUK().getModel())) {
                result[0] = 2;
                this.fSettingString = "UK";
            } else if (group.isSelected(this.getUS1().getModel())) {
                result[0] = 3;
                this.fSettingString = "US1";
            } else if (group.isSelected(this.getUserDefined().getModel())) {
                result[0] = 4;
                this.fSettingString = result[4] + "." + result[3] + " - " + result[2] + "." + result[1] + " / " + result[5];
            } else if (group.isSelected(this.getAUS().getModel())) {
                result[0] = 5;
                this.fSettingString = "AUS";
            } else if (group.isSelected(this.getTAS().getModel())) {
                result[0] = 6;
                this.fSettingString = "TAS";
            } else if (group.isSelected(this.getNZ().getModel())) {
                result[0] = 7;
                this.fSettingString = "NZ";
            } else if (group.isSelected(this.getUS2().getModel())) {
                result[0] = 8;
                this.fSettingString = "US2";
            } else {
                this.fSettingString = Language.getString("error.internalError", "Internal error %", "SummerWinterPanel.getSetting()");
                Log.println(this.fSettingString);
                new LogoError(this.fSettingString).display();
            }
        } else {
            result[0] = 0;
            this.fSettingString = Language.getString("msg.noSWT", "Summer-/Wintertime deactivated");
        }
        return result;
    }

    private DateParameterJPanel getStartDate() {
        if (this.ivjStartDate == null) {
            try {
                this.ivjStartDate = new DateParameterJPanel();
                this.ivjStartDate.setName("StartDate");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStartDate;
    }

    private BorderJPanel getSummertimeBorder() {
        if (this.ivjSummertimeBorder == null) {
            try {
                this.ivjSummertimeBorder = new BorderJPanel();
                this.ivjSummertimeBorder.setName("SummertimeBorder");
                this.ivjSummertimeBorder.setLayout(new GridLayout(0, 2));
                this.ivjSummertimeBorder.setTitle("Summertime");
                this.getSummertimeBorder().add((Component)this.getStartDate(), this.getStartDate().getName());
                this.getSummertimeBorder().add((Component)this.getEndDate(), this.getEndDate().getName());
                this.getSummertimeBorder().add((Component)this.getDelayBorder(), this.getDelayBorder().getName());
                this.ivjSummertimeBorder.setEnabled(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSummertimeBorder;
    }

    private JCheckBox getTimeChangeActive() {
        if (this.ivjTimeChangeActive == null) {
            try {
                this.ivjTimeChangeActive = new JCheckBox();
                this.ivjTimeChangeActive.setSelected(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTimeChangeActive;
    }

    public String getTitle() {
        return Language.getString("dialog.summerWinter.title", "Summer-/Wintertime");
    }

    private JRadioButton getUK() {
        if (this.ivjUK == null) {
            try {
                this.ivjUK = new JRadioButton();
                this.ivjUK.setName("UK");
                this.ivjUK.setText("United Kingdom");
                this.ivjUK.setIcon(Global.getIcon("UKns.gif"));
                this.ivjUK.setSelectedIcon(Global.getIcon("UK.gif"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjUK;
    }

    private JRadioButton getUS1() {
        if (this.ivjUS1 == null) {
            try {
                this.ivjUS1 = new JRadioButton();
                this.ivjUS1.setName("US1");
                this.ivjUS1.setText("United States");
                this.ivjUS1.setIcon(Global.getIcon("USns.gif"));
                this.ivjUS1.setSelectedIcon(Global.getIcon("US.gif"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjUS1;
    }

    private JRadioButton getUS2() {
        if (this.ivjUS2 == null) {
            try {
                this.ivjUS2 = new JRadioButton();
                this.ivjUS2.setName("US2");
                this.ivjUS2.setText("United States");
                this.ivjUS2.setIcon(Global.getIcon("USns.gif"));
                this.ivjUS2.setSelectedIcon(Global.getIcon("US.gif"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjUS2;
    }

    private JRadioButton getAUS() {
        if (this.ivjAUS == null) {
            try {
                this.ivjAUS = new JRadioButton();
                this.ivjAUS.setName("AUS");
                this.ivjAUS.setText("Australia");
                this.ivjAUS.setIcon(Global.getIcon("AUSns.gif"));
                this.ivjAUS.setSelectedIcon(Global.getIcon("AUS.gif"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjAUS;
    }

    private JRadioButton getTAS() {
        if (this.ivjTAS == null) {
            try {
                this.ivjTAS = new JRadioButton();
                this.ivjTAS.setName("TAS");
                this.ivjTAS.setText("Tasmania");
                this.ivjTAS.setIcon(Global.getIcon("TASns.gif"));
                this.ivjTAS.setSelectedIcon(Global.getIcon("TAS.gif"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTAS;
    }

    private JRadioButton getNZ() {
        if (this.ivjNZ == null) {
            try {
                this.ivjNZ = new JRadioButton();
                this.ivjNZ.setName("NZ");
                this.ivjNZ.setText("New Zealand");
                this.ivjNZ.setIcon(Global.getIcon("NZns.gif"));
                this.ivjNZ.setSelectedIcon(Global.getIcon("NZ.gif"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjNZ;
    }

    private JRadioButton getUserDefined() {
        if (this.ivjUserDefined == null) {
            try {
                this.ivjUserDefined = new JRadioButton();
                this.ivjUserDefined.setName("UserDefined");
                this.ivjUserDefined.setText("User defined");
                this.ivjUserDefined.setIcon(Global.getIcon("UCns.gif"));
                this.ivjUserDefined.setSelectedIcon(Global.getIcon("UC.gif"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjUserDefined;
    }

    private void handleException(Throwable exception) {
    }

    private void initConnections() throws Exception {
        this.getTimeChangeActive().addItemListener(this.ivjEventHandler);
        this.getUserDefined().addItemListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("SummerWinterPanel");
            this.setLayout(new GridBagLayout());
            GridBagConstraints constraintsTimeChangeActive = new GridBagConstraints();
            constraintsTimeChangeActive.gridx = 0;
            constraintsTimeChangeActive.gridy = 0;
            constraintsTimeChangeActive.anchor = 17;
            constraintsTimeChangeActive.insets = new Insets(7, 16, 1, 121);
            this.add((Component)this.getTimeChangeActive(), constraintsTimeChangeActive);
            GridBagConstraints constraintsModeBorder = new GridBagConstraints();
            constraintsModeBorder.gridx = 0;
            constraintsModeBorder.gridy = 1;
            constraintsModeBorder.fill = 1;
            constraintsModeBorder.weightx = 1.0;
            this.add((Component)this.getModeBorder(), constraintsModeBorder);
            GridBagConstraints constraintsSummertimeBorder = new GridBagConstraints();
            constraintsSummertimeBorder.gridx = 0;
            constraintsSummertimeBorder.gridy = 2;
            constraintsSummertimeBorder.fill = 1;
            constraintsSummertimeBorder.weightx = 1.0;
            constraintsSummertimeBorder.weighty = 1.0;
            this.add((Component)this.getSummertimeBorder(), constraintsSummertimeBorder);
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void loadFieldContents() throws ProgramException {
        Log.printStartSequence("log.msg.readSWT", "Read Summer-/Wintertimeparameter");
        DataTransfer dt = null;
        try {
            dt = DataTransfer.openConnection(true);
            if (!dt.isTransmissionPossible((JComponent)this.getParent())) {
                throw new ExceptionAlreadyHandledException();
            }
        }
        catch (ExceptionAlreadyHandledException eahe) {
            throw new ProgramException();
        }
        boolean tryAgain = true;
        while (tryAgain) {
            tryAgain = false;
            try {
                dt.reset();
                Hardware hw = dt.getHardware();
                Log.println(hw.getLocalizedPath() + hw.getLocalizedName());
                this.getButtonGroup().add(this.getEU());
                this.getButtonGroup().add(this.getUS1());
                this.getButtonGroup().add(this.getUS2());
                this.getButtonGroup().add(this.getUK());
                this.getButtonGroup().add(this.getTAS());
                this.getButtonGroup().add(this.getNZ());
                this.getButtonGroup().add(this.getAUS());
                this.getButtonGroup().add(this.getUserDefined());
                this.getModeBorder().add((Component)this.getEU(), this.getEU().getName());
                this.getModeBorder().add((Component)this.getUK(), this.getUK().getName());
                this.getModeBorder().add((Component)this.getUS1(), this.getUS1().getName());
                if (hw.supports("newRuleUsaDst")) {
                    this.getModeBorder().add((Component)this.getUS2(), this.getUS2().getName());
                }
                if (hw.supports("swtExt")) {
                    this.getModeBorder().add((Component)this.getAUS(), this.getAUS().getName());
                    this.getModeBorder().add((Component)this.getTAS(), this.getTAS().getName());
                    this.getModeBorder().add((Component)this.getNZ(), this.getNZ().getName());
                }
                this.getModeBorder().add((Component)this.getUserDefined(), this.getUserDefined().getName());
                this.setSummerWintertime(((Logo)dt.getHardware()).uploadSummerWintertime(dt));
                Log.println(this.fSettingString);
                Log.println(Language.getString("msg.readSuccessful", "Reading successful"));
            }
            catch (TransmissionFailedException tfe) {
                tryAgain = LogoError.checkRepeatTransmission(tfe);
                if (tryAgain) continue;
                Log.printStartSequence("log.err.readSummerWintertimeNotOK", "Read Summer-/Wintertimeparameter failed");
                throw new ProgramException();
            }
            catch (UnsupportedOperationException e) {
                Hardware hw = dt.getHardware();
                String s = Language.getString("err.hardwareNoSummerWintertime", "% doesn't support Summer-/Wintertime", hw.getLocalizedPath() + hw.getLocalizedName());
                Log.println(s);
                throw new ProgramException().setUser(s);
            }
            finally {
                dt.closePort();
            }
        }
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            SummerWinterPanel aSummerWinterPanel = new SummerWinterPanel();
            frame.setContentPane(aSummerWinterPanel);
            frame.setSize(aSummerWinterPanel.getSize());
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of DE.siemens.ad.logo.dialog.SplittedDlgEditPanel");
            exception.printStackTrace(System.out);
        }
    }

    public void setLabels() {
        this.getTimeChangeActive().setText(Language.getString("panel.swt.activate", "Activate Summer-/Wintertime"));
        this.getEU().setText(Language.getString("panel.swt.eu", "Europe"));
        this.getUK().setText(Language.getString("panel.swt.uk", "United Kingdom"));
        this.getUS1().setText(Language.getString("panel.swt.us1", "US1"));
        this.getUS2().setText(Language.getString("panel.swt.us2", "US2"));
        this.getAUS().setText(Language.getString("panel.swt.aus", "Australia"));
        this.getTAS().setText(Language.getString("panel.swt.tas", "Tasmania"));
        this.getNZ().setText(Language.getString("panel.swt.nz", "New Zealand"));
        this.getUserDefined().setText(Language.getString("panel.swt.ud", "User defined"));
        this.getEU().setToolTipText(Language.getString("panel.swt.eu.tooltip", "Last sunday in march till fourth sunday in oktober"));
        this.getUK().setToolTipText(Language.getString("panel.swt.uk.tooltip", "Last sunday in march till last sunday in oktober"));
        this.getUS1().setToolTipText(Language.getString("panel.swt.us1.tooltip", "First sunday in april till last sunday in oktober"));
        this.getUS2().setToolTipText(Language.getString("panel.swt.us2.tooltip", "Second Sunday in March till first Sunday in November"));
        this.getAUS().setToolTipText(Language.getString("panel.swt.aus.tooltip", "Last sunday in october till last sunday in march"));
        this.getTAS().setToolTipText(Language.getString("panel.swt.tas.tooltip", "First sunday in october till last sunday in march"));
        this.getNZ().setToolTipText(Language.getString("panel.swt.nz.tooltip", "First sunday in october till third sunday in march"));
        this.getUserDefined().setToolTipText(Language.getString("panel.swt.ud.tooltip", "Define your own settings"));
        this.getSummertimeBorder().setTitle(Language.getString("panel.swt.summertimeBorder", "Summertime"));
        this.getStartDate().setTitle(Language.getString("panel.swt.start", "Start"));
        this.getEndDate().setTitle(Language.getString("panel.swt.end", "End"));
        this.getDelayBorder().setTitle(Language.getString("panel.swt.delay", "Time-Delay (minutes)"));
    }

    public void setSummerWintertime(int[] param) {
        this.fInitialSetting = param;
        switch (param[0]) {
            case 0: {
                this.getTimeChangeActive().setSelected(false);
                this.fSettingString = Language.getString("msg.noSWT", "Summer-/Wintertime deactivated");
                return;
            }
            case 1: {
                this.getTimeChangeActive().setSelected(true);
                this.getEU().setSelected(true);
                this.fSettingString = "EU";
                break;
            }
            case 2: {
                this.getTimeChangeActive().setSelected(true);
                this.getUK().setSelected(true);
                this.fSettingString = "UK";
                break;
            }
            case 3: {
                this.getTimeChangeActive().setSelected(true);
                this.getUS1().setSelected(true);
                this.fSettingString = "US1";
                break;
            }
            case 4: {
                this.getTimeChangeActive().setSelected(true);
                this.getUserDefined().setSelected(true);
                this.getEndDate().setDateValue(param[1], param[2]);
                this.getStartDate().setDateValue(param[3], param[4]);
                this.getDelay().setValue(param[5]);
                this.fSettingString = param[4] + "." + param[3] + " - " + param[2] + "." + param[1] + " / " + param[5];
                break;
            }
            case 5: {
                this.getTimeChangeActive().setSelected(true);
                this.getAUS().setSelected(true);
                this.fSettingString = "AUS";
                break;
            }
            case 6: {
                this.getTimeChangeActive().setSelected(true);
                this.getTAS().setSelected(true);
                this.fSettingString = "TAS";
                break;
            }
            case 7: {
                this.getTimeChangeActive().setSelected(true);
                this.getNZ().setSelected(true);
                this.fSettingString = "NZ";
                break;
            }
            case 8: {
                this.getTimeChangeActive().setSelected(true);
                this.getUS2().setSelected(true);
                this.fSettingString = "US2";
                break;
            }
            default: {
                this.fSettingString = Language.getString("err.summerWinterSettingUnknown", "Hardware-Settings are Unknown");
                new LogoError(this.fSettingString).display();
                Log.println(this.fSettingString + " SY_SW_Time_Setting: " + param[0]);
                return;
            }
        }
    }

    public void storeFieldContents() {
        Log.printStartSequence("log.msg.writeSWT", "Write Summer-/Wintertimeparameter");
        this.storeSummerWintertime(this.getSetting());
    }

    public void storeSummerWintertime(int[] param) {
        DataTransfer dt = null;
        try {
            dt = DataTransfer.openConnection(true);
        }
        catch (ExceptionAlreadyHandledException eahe) {
            return;
        }
        boolean tryAgain = true;
        boolean printLog = true;
        while (tryAgain) {
            try {
                dt.reset();
                ((Logo)dt.getHardware()).downloadSummerWintertime(dt, param);
                Hardware hw = dt.getHardware();
                Log.println(hw.getLocalizedPath() + hw.getLocalizedName());
                Log.println(this.fSettingString);
                Log.println(Language.getString("msg.writeSuccessful", "Writing successful"));
                tryAgain = false;
            }
            catch (TransmissionFailedException tfe) {
                tryAgain = LogoError.checkRepeatTransmission(tfe);
            }
            catch (UnsupportedOperationException e) {
                Hardware hw = dt.getHardware();
                String s = Language.getString("err.hardwareNoSummerWintertime", "% doesn't support Summer-/Wintertime", hw.getLocalizedPath() + hw.getLocalizedName());
                new LogoError(s).display();
                Log.println(s);
                tryAgain = false;
            }
        }
        dt.closePort();
    }

    public void timeChangeActive_ItemStateChanged(ItemEvent itemEvent) {
        if (!((JCheckBox)itemEvent.getItem()).isSelected()) {
            this.disableSummerWintertimeInputs();
        } else {
            this.enableSummerWintertimeInputs();
        }
    }

    class IvjEventHandler
    implements ItemListener {
        IvjEventHandler() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == SummerWinterPanel.this.getTimeChangeActive()) {
                SummerWinterPanel.this.connChangeActive_ItemStateChanged(e);
            }
            if (e.getSource() == SummerWinterPanel.this.getUserDefined()) {
                SummerWinterPanel.this.connUserDefined_itemStateChanged(e);
            }
        }
    }
}

