/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.app.dialog.ControlPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicArrowButton;

public class SplittedMinimizableDlg
extends SplittedDlg {
    private JButton fMinMaxButton = null;
    private JButton fMinButton = null;
    private JButton fMaxButton = null;
    private JPanel fMaximizedPane = null;
    private JPanel fMinimizedPane = null;
    private Component fMinimizedPaneContent = null;
    private Container fMinimizedParent = null;
    private Container fMaximizedContentPane = null;
    private JPanel fMinButtonPanel;

    public SplittedMinimizableDlg(JFrame parent, DataInputPanel dataInputPanel, int controlPanelMode) {
        super(parent);
        this.setDataInputPanel(dataInputPanel);
        ControlPanel controlPanel = new ControlPanel(controlPanelMode);
        this.setControlPanel(controlPanel);
    }

    public SplittedMinimizableDlg(JFrame parent, boolean modal) {
        super(parent);
        this.setModal(modal);
    }

    public JPanel getControlPane() {
        JPanel panel = super.getControlPane();
        if (!(panel.getLayout() instanceof BorderLayout)) {
            panel.setLayout(new BorderLayout());
        }
        return panel;
    }

    private JButton getDirectionButton(int direction) {
        HandleButton buttonHandler = new HandleButton();
        BasicArrowButton button = new BasicArrowButton(direction){

            public Dimension getMinimumSize() {
                return new Dimension(36, 36);
            }
        };
        button.addActionListener(buttonHandler);
        return button;
    }

    private JButton getMaxButton() {
        if (this.fMaxButton == null) {
            this.fMaxButton = this.getDirectionButton(1);
        }
        return this.fMaxButton;
    }

    protected Dimension getMaximizedDimension() {
        return new Dimension(420, 380);
    }

    private JButton getMinButton() {
        if (this.fMinButton == null) {
            this.fMinButton = this.getDirectionButton(5);
        }
        return this.fMinButton;
    }

    private JPanel getMinButtonPanel() {
        if (this.fMinButtonPanel == null) {
            this.fMinButtonPanel = new JPanel();
            JButton button = this.getMinButton();
            this.fMinButtonPanel.add(button);
        }
        return this.fMinButtonPanel;
    }

    protected Dimension getMinimizedDimension() {
        return new Dimension(285, 80);
    }

    private Component getMinimizedPane() {
        if (this.fMinimizedPane == null) {
            this.fMinimizedPane = new JPanel(new BorderLayout());
            this.fMinimizedPane.add((Component)this.getMaxButton(), "East");
            this.fMinimizedPane.add(this.fMinimizedPaneContent, "Center");
        } else {
            this.fMinimizedPane.add(this.fMinimizedPaneContent, "Center");
        }
        return this.fMinimizedPane;
    }

    public JButton getMinMaxButton() {
        return this.fMinMaxButton;
    }

    private void initialize() {
        if (this.fMinButtonPanel != null) {
            this.getControlPane().remove(this.getMinButtonPanel());
            if (this.isMinimized()) {
                this.maxButtonPressed();
            }
        }
        this.fMinButton = null;
        this.fMaxButton = null;
        this.fMinMaxButton = null;
        this.fMaximizedPane = null;
        this.fMaximizedContentPane = null;
        this.fMinimizedPane = null;
        this.fMinimizedPaneContent = null;
        this.fMinimizedParent = null;
        this.fMinButtonPanel = null;
    }

    public boolean isMinimized() {
        boolean result = false;
        if (this.fMaxButton != null) {
            result = this.getMinMaxButton() == this.getMaxButton();
        }
        return result;
    }

    private void maxButtonPressed() {
        this.fMinimizedParent.add(this.fMinimizedPaneContent);
        this.setContentPane(this.fMaximizedContentPane);
        this.setSize(this.getMaximizedDimension());
        this.validate();
        this.fMinMaxButton = this.getMinButton();
    }

    private void minButtonPressed() {
        Container panel;
        this.fMaximizedContentPane = panel = this.getContentPane();
        this.setContentPane((Container)this.getMinimizedPane());
        this.setSize(this.getMinimizedDimension());
        this.validate();
        this.fMinMaxButton = this.getMaxButton();
    }

    protected void refreshView() {
        if (this.isMinimized()) {
            this.setContentPane((Container)this.getMinimizedPane());
            this.setSize(this.getMinimizedDimension());
            this.validate();
        }
    }

    protected void setMinimizedPane(Component newMinimizedPane) {
        if (newMinimizedPane != null) {
            this.fMinimizedPaneContent = newMinimizedPane;
            this.fMinimizedPane = null;
            this.fMinimizedParent = newMinimizedPane.getParent();
            this.getControlPane().add((Component)this.getMinButtonPanel(), "East");
        } else {
            this.initialize();
        }
    }

    class HandleButton
    implements ActionListener {
        HandleButton() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == SplittedMinimizableDlg.this.getMinButton()) {
                SplittedMinimizableDlg.this.minButtonPressed();
            } else if (object == SplittedMinimizableDlg.this.getMaxButton()) {
                SplittedMinimizableDlg.this.maxButtonPressed();
            }
        }
    }
}

