/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.View;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.dialog.comp.IconCheckBox;
import DE.siemens.ad.logo.util.Language;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;

public class SelectDocumentsToSavePanel
extends DataInputPanel {
    protected JPanel fViewsPanel;
    protected Hashtable fCheckboxViewDictionary = new Hashtable();
    protected JButton fSelectAllButton;
    protected JButton fDeselectAllButton;
    protected JLabel fDescription = new JLabel();
    public Collection fSelectedViews;
    protected JCheckBox fSelectAllCheckBox;

    public SelectDocumentsToSavePanel(Collection views) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.fDescription, "North");
        this.fViewsPanel = new JPanel();
        this.fViewsPanel.setBackground(Color.white);
        this.fViewsPanel.setLayout(new BoxLayout(this.fViewsPanel, 1));
        this.fViewsPanel.setBorder(new BevelBorder(1));
        this.add((Component)new JScrollPane(this.fViewsPanel), "Center");
        Iterator e = views.iterator();
        View view = null;
        while (e.hasNext()) {
            view = (View)e.next();
            try {
                IconCheckBox checkBox = new IconCheckBox(view.getModel().getFile().getName(), view.getEditor().getEditorInfo().getIcon());
                checkBox.setSelected(true);
                checkBox.setAlignmentX(0.0f);
                checkBox.setOpaque(false);
                this.fCheckboxViewDictionary.put(checkBox, view);
                this.fViewsPanel.add(checkBox);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.fSelectAllCheckBox = new JCheckBox("select all", true);
        this.fSelectAllCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (SelectDocumentsToSavePanel.this.fSelectAllCheckBox.isSelected()) {
                    SelectDocumentsToSavePanel.this.selectAll();
                } else {
                    SelectDocumentsToSavePanel.this.deselectAll();
                }
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        buttonPanel.add(this.fSelectAllCheckBox);
        this.add((Component)buttonPanel, "South");
        this.fSelectedViews = new Vector(5);
    }

    private void deselectAll() {
        Enumeration e = this.fCheckboxViewDictionary.keys();
        while (e.hasMoreElements()) {
            ((IconCheckBox)e.nextElement()).setSelected(false);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(435, 210);
    }

    public Collection getSelectedViews() {
        this.storeFieldContents();
        return this.fSelectedViews;
    }

    public String getTitle() {
        return Language.getString("dialog.selectDocumentsToSave.title", "Save documents");
    }

    private void selectAll() {
        Enumeration e = this.fCheckboxViewDictionary.keys();
        while (e.hasMoreElements()) {
            ((IconCheckBox)e.nextElement()).setSelected(true);
        }
    }

    public void setLabels() {
        this.fDescription.setText(Language.getString("dialog.selectDocumentsToSave.documentsToSave", "Documents to save:"));
        this.fSelectAllCheckBox.setText(Language.getString("dialog.selectDocumentsToSave.selectAll", "select all"));
    }

    public void storeFieldContents() {
        this.fSelectedViews = new Vector();
        Enumeration e = this.fCheckboxViewDictionary.keys();
        IconCheckBox checkBox = null;
        while (e.hasMoreElements()) {
            checkBox = (IconCheckBox)e.nextElement();
            if (!checkBox.isSelected()) continue;
            this.fSelectedViews.add(this.fCheckboxViewDictionary.get(checkBox));
        }
    }

    public boolean checkChanged() {
        return true;
    }
}

