/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.dialog.TrendViewPanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.PIDBlock;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;

public abstract class PIControllerWindow
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final int SECOND_SCALE = 1;
    private JTabbedPane ivjJTabbedPane = null;
    protected boolean currentVisibility = false;
    private JPanel ivjPIControllerWindowContentPanel = null;
    private Editor fEditor;
    private boolean fIsOnlineTest = false;
    private ArrayList fHidenWindows = null;

    protected PIControllerWindow(JFrame parent) {
        super(parent);
        this.initialize();
    }

    protected PIControllerWindow(JDialog parent) {
        super(parent);
        this.initialize();
    }

    public static PIControllerWindow createPIControllerWindow(Editor editor) {
        PIControllerWindowAQ piControllerWindow = null;
        Window parentWindow = editor.getApplicationSurface().getWindow();
        if (parentWindow instanceof JDialog) {
            piControllerWindow = new PIControllerWindowAQ((JDialog)parentWindow);
        } else if (parentWindow instanceof JFrame) {
            piControllerWindow = new PIControllerWindowAQ((JFrame)parentWindow);
        } else {
            throw new IllegalArgumentException("Parent of a PIControllerWindow must be a JDialog or JFrame.");
        }
        piControllerWindow.setEditor(editor);
        piControllerWindow.setTitle(Language.getString("block.PIController.title", "PI Trend View"));
        return piControllerWindow;
    }

    public boolean isOnlineTest() {
        return this.fIsOnlineTest;
    }

    public void setOnlineTest(boolean isOnlineTest) {
        this.fIsOnlineTest = isOnlineTest;
    }

    protected void clearTabbedPane() {
        this.getJTabbedPane().removeAll();
    }

    protected void updateTabbedPane() {
        TrendViewPanel viewPanel;
        int i;
        for (int i2 = 0; i2 < this.getHidenWindows().size(); ++i2) {
            TrendViewPanel pane = (TrendViewPanel)this.getHidenWindows().get(i2);
            if (!pane.isBlockInfoAvailable()) continue;
            this.getJTabbedPane().add(pane.getBlockNumberString(), pane);
            this.getHidenWindows().remove(i2);
            System.out.println("new panel added: " + this.getHidenWindows().size() + ", " + this.getJTabbedPane().getComponentCount());
        }
        int tabCount = this.getJTabbedPane().getComponentCount();
        for (i = 0; i < tabCount; ++i) {
            viewPanel = (TrendViewPanel)this.getJTabbedPane().getComponentAt(i);
            if (!viewPanel.isBlockInfoAvailable()) continue;
            viewPanel.nextCycle();
        }
        for (i = 0; i < tabCount; ++i) {
            viewPanel = (TrendViewPanel)this.getJTabbedPane().getComponentAt(i);
            if (viewPanel.isBlockInfoAvailable()) continue;
            this.getJTabbedPane().remove(viewPanel);
            viewPanel.clearHistory();
            this.getHidenWindows().add(viewPanel);
            System.out.println("new panel removed");
            --i;
            --tabCount;
        }
    }

    public void endSimulation() {
        this.clearTabbedPane();
    }

    protected void fillTabbedPane() {
        JTabbedPane tabPane = this.getJTabbedPane();
        tabPane.removeAll();
        WiringDiagram wiringDiagram = ((LogoDrawing)((LogoComfort)this.fEditor).drawing()).getWiringDiagram();
        if (this.fHidenWindows != null) {
            this.fHidenWindows.clear();
        } else {
            this.fHidenWindows = new ArrayList(16);
        }
        Enumeration blocks = wiringDiagram.getBlocks().elements();
        Block aBlock = null;
        int piBlocknumber = 0;
        while (blocks.hasMoreElements()) {
            aBlock = (Block)blocks.nextElement();
            if (!(aBlock instanceof PIDBlock)) continue;
            if (!this.isOnlineTest() || ((PIDBlock)aBlock).isOnlineTestObserved()) {
                tabPane.addTab(this.getPIBlockNumberString(aBlock), null, this.getTrendViewPanel(aBlock), aBlock.getNumberString());
                ++piBlocknumber;
                continue;
            }
            this.getHidenWindows().add(this.getTrendViewPanel(aBlock));
        }
        this.setSize(400, (int)(300.0 + (double)(piBlocknumber - 1) * 1.5));
        this.invalidate();
        this.add(tabPane);
    }

    private String getPIBlockNumberString(Block pi) {
        StringBuffer buffer = new StringBuffer(pi.getNumberPrefix());
        if (pi.getNumber() > 0) {
            String string = "00" + Integer.toString(pi.getNumber());
            if (pi.getHardware() != null) {
                int maxBlocks = pi.getHardware().getMaxResource(0);
                buffer.append(string.substring(string.length() - Integer.toString(maxBlocks).length()));
            } else {
                buffer.append(string.substring(2));
            }
        }
        return buffer.toString();
    }

    protected ArrayList getHidenWindows() {
        if (this.fHidenWindows == null) {
            this.fHidenWindows = new ArrayList(16);
        }
        return this.fHidenWindows;
    }

    private TrendViewPanel getTrendViewPanel(Block aBlock) {
        return new TrendViewPanel(aBlock.getNumberString(), this.getParameterName(), aBlock, this.isOnlineTest());
    }

    protected abstract String getParameterName();

    protected JTabbedPane getJTabbedPane() {
        if (this.ivjJTabbedPane == null) {
            this.ivjJTabbedPane = new JTabbedPane();
            this.ivjJTabbedPane.setName("JTabbedPane");
        }
        return this.ivjJTabbedPane;
    }

    private JPanel getPIControllerWindowContentPanel() {
        if (this.ivjPIControllerWindowContentPanel == null) {
            this.ivjPIControllerWindowContentPanel = new JPanel();
            this.ivjPIControllerWindowContentPanel.setName("MessageWindowContentPanel");
            this.ivjPIControllerWindowContentPanel.setLayout(new BorderLayout());
            this.getPIControllerWindowContentPanel().add((Component)this.getJTabbedPane(), "Center");
        }
        return this.ivjPIControllerWindowContentPanel;
    }

    protected void initialize() {
        this.setName("PIControllerWindow");
        this.setFont(new Font("dialog", 0, 8));
        this.setContentPane(this.getPIControllerWindowContentPanel());
    }

    public void setEditorActivated(boolean editorActivated) {
        super.setVisible(editorActivated && this.currentVisibility);
    }

    public void setVisible(boolean visibility) {
        boolean actVisible = visibility;
        if (this.getJTabbedPane().getTabCount() <= 0) {
            actVisible = false;
        }
        super.setVisible(actVisible && this.fEditor.isActivated());
        this.currentVisibility = actVisible;
    }

    public void dispose() {
        this.currentVisibility = false;
        super.dispose();
    }

    public void startSimulation() {
        this.fillTabbedPane();
    }

    protected Editor getEditor() {
        return this.fEditor;
    }

    protected void setEditor(Editor editor) {
        this.fEditor = editor;
    }

    private static class PIControllerWindowPV
    extends PIControllerWindow {
        private static final long serialVersionUID = 1L;
        private PIControllerWindowAQ fAQDialog;

        protected PIControllerWindowPV(PIControllerWindowAQ parent) {
            super(parent);
            this.fAQDialog = parent;
        }

        protected void initialize() {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    PIControllerWindowPV.this.fAQDialog.setButtonSelected(false);
                }
            });
            this.setDefaultCloseOperation(1);
            this.setBounds(100, 450, 410, 270);
            this.setModal(false);
            this.setResizable(false);
        }

        protected String getParameterName() {
            return "PV";
        }
    }

    private static class PIControllerWindowAQ
    extends PIControllerWindow {
        private static final long serialVersionUID = 1L;
        private JToggleButton fBtShowPV;
        private PIControllerWindow fPVDialog;
        private Timer getValueTimer;

        protected PIControllerWindowAQ(JFrame parent) {
            super(parent);
        }

        protected PIControllerWindowAQ(JDialog parent) {
            super(parent);
        }

        protected void initialize() {
            this.setDefaultCloseOperation(2);
            this.fBtShowPV = new JToggleButton(Language.getString("block.PIController.showPV", "Show PV"));
            this.fBtShowPV.setIcon(Global.getIcon("Next.gif"));
            this.add((Component)this.fBtShowPV, "South");
            this.fBtShowPV.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (PIControllerWindowAQ.this.getAQDialog().fBtShowPV.isSelected()) {
                        if (PIControllerWindowAQ.this.getAQDialog().fPVDialog == null) {
                            PIControllerWindowAQ.this.getAQDialog().fPVDialog = new PIControllerWindowPV(PIControllerWindowAQ.this.getAQDialog());
                            PIControllerWindowAQ.this.getAQDialog().fPVDialog.setOnlineTest(PIControllerWindowAQ.this.getAQDialog().isOnlineTest());
                            PIControllerWindowAQ.this.getAQDialog().fPVDialog.setEditor(PIControllerWindowAQ.this.getEditor());
                            PIControllerWindowAQ.this.getAQDialog().fPVDialog.fillTabbedPane();
                        }
                        PIControllerWindowAQ.this.getAQDialog().fPVDialog.setLocation(100, PIControllerWindowAQ.this.getAQDialog().getY() + PIControllerWindowAQ.this.getAQDialog().getHeight());
                        PIControllerWindowAQ.this.getAQDialog().fPVDialog.invalidate();
                        PIControllerWindowAQ.this.getAQDialog().fPVDialog.setVisible(true);
                    } else {
                        PIControllerWindowAQ.this.getAQDialog().fPVDialog.setVisible(false);
                    }
                }
            });
            this.setBounds(100, 150, 410, 300);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    PIControllerWindowAQ.this.cancelTimer();
                    PIControllerWindowAQ.this.getAQDialog().clearTabbedPane();
                    if (PIControllerWindowAQ.this.getAQDialog().fPVDialog != null) {
                        PIControllerWindowAQ.this.getAQDialog().fPVDialog.clearTabbedPane();
                        PIControllerWindowAQ.this.getAQDialog().fPVDialog.dispose();
                        PIControllerWindowAQ.this.getAQDialog().fPVDialog = null;
                    }
                    PIControllerWindowAQ.this.getAQDialog().fBtShowPV.setSelected(false);
                }
            });
            this.setModal(false);
            this.setResizable(false);
        }

        public void startSimulation() {
            super.startSimulation();
            if (this.getJTabbedPane().getComponentCount() + this.getHidenWindows().size() > 0) {
                this.initTimer();
                if (this.getAQDialog().fPVDialog != null) {
                    this.getAQDialog().fPVDialog.startSimulation();
                }
            }
        }

        public void endSimulation() {
            super.endSimulation();
            this.cancelTimer();
        }

        private void initTimer() {
            if (this.getValueTimer != null) {
                this.getValueTimer.cancel();
            }
            this.getValueTimer = new Timer();
            this.getValueTimer.schedule(new TimerTask(){

                public void run() {
                    try {
                        PIControllerWindowAQ.this.getAQDialog().updateTabbedPane();
                        if (PIControllerWindowAQ.this.getAQDialog().fPVDialog != null) {
                            PIControllerWindowAQ.this.getAQDialog().fPVDialog.updateTabbedPane();
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        System.err.println("Trendview panel error");
                    }
                }
            }, 500L, 1000L);
        }

        private void cancelTimer() {
            if (this.getAQDialog().getValueTimer != null) {
                this.getAQDialog().getValueTimer.cancel();
                this.getAQDialog().getValueTimer = null;
            }
        }

        private PIControllerWindowAQ getAQDialog() {
            return this;
        }

        public void setButtonSelected(boolean selected) {
            this.fBtShowPV.setSelected(selected);
        }

        protected String getParameterName() {
            return "AQ";
        }

        protected void updateTabbedPane() {
            super.updateTabbedPane();
            int tabCount = this.getJTabbedPane().getComponentCount();
            if (!this.isVisible()) {
                this.setVisible(tabCount > 0);
            }
        }
    }
}

