/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.comp.LogoJPopupMenu;
import DE.siemens.ad.logo.dialog.comp.MessageDisplay;
import DE.siemens.ad.logo.dialog.comp.MessageReceiptListener;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.LogoDisplay;
import DE.siemens.ad.logo.model.BinaryOutBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.MessageManager;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.logo.model.ParameterUpdateEvent;
import DE.siemens.ad.logo.model.ParameterUpdateListener;
import DE.siemens.ad.logo.model.block.MessageBlock;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.action.EditBlockPropertiesAction;
import DE.siemens.ad.pdraw.action.GotoBlockAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class MessageWindow
extends JDialog
implements MessageReceiptListener,
ParameterSetListener,
ParameterUpdateListener {
    private JTabbedPane ivjJTabbedPane = null;
    private HashMap fParamToDisplay = new HashMap();
    protected MessageManager fMessageManager;
    protected boolean currentVisibility = false;
    protected MessageDisplay fCurrentMessage;
    protected MessageDisplay[] enabledMessageDisplays;
    private JPanel ivjMessageWindowContentPane1 = null;
    private Editor fEditor;
    private int fMaxPrio;
    private MessageWindowGotoBlockAction fGotoBlockAction;
    private MessageWindowEditBlockPropertiesAction fEditBlockPropertiesAction;
    private LogoJPopupMenu fPopupMenu;
    private JLabel fBlockNumberLabel;

    public MessageWindow() {
        this.initialize();
    }

    private MessageWindow(JFrame parent) {
        super(parent);
    }

    private MessageWindow(JDialog parent) {
        super(parent);
    }

    public static MessageWindow createMessageWindow(Editor editor, MessageManager msgManager) {
        MessageWindow messageWindow = null;
        Window parentWindow = editor.getApplicationSurface().getWindow();
        if (parentWindow instanceof JDialog) {
            messageWindow = new MessageWindow((JDialog)parentWindow);
        } else if (parentWindow instanceof JFrame) {
            messageWindow = new MessageWindow((JFrame)parentWindow);
        } else {
            throw new IllegalArgumentException("Parent of a MessageWindow must be a JDialog or JFrame.");
        }
        messageWindow.setEditor(editor);
        messageWindow.initialize();
        messageWindow.setMessageManager(msgManager);
        messageWindow.setTitle(Language.getString("block.Message", "Message"));
        return messageWindow;
    }

    private void clearTabbedPane() {
        int tabCount = this.getJTabbedPane().getComponentCount();
        MessageDisplay messageDisplay = null;
        for (int i = 0; i < tabCount; ++i) {
            messageDisplay = (MessageDisplay)this.getJTabbedPane().getComponentAt(i);
            MessageParameter param = messageDisplay.getMessageParameter();
            param.removeParameterSetListener(this);
            param.removeParameterUpdateListener(this);
            param.removeParameterUpdateListener(messageDisplay);
            messageDisplay.removeMessageReceiptListener(this);
            messageDisplay.removeMessageReceiptListener(param);
        }
        this.getJTabbedPane().removeAll();
    }

    public void endSimulation() {
        this.clearTabbedPane();
    }

    private void fillTabbedPane() {
        Collection values = this.fParamToDisplay.values();
        Iterator sorted = new TreeSet(values).iterator();
        JTabbedPane tabPane = this.getJTabbedPane();
        tabPane.removeAll();
        int i = 0;
        while (sorted.hasNext()) {
            MessageDisplay tab = (MessageDisplay)sorted.next();
            tabPane.add(tab);
            tabPane.setToolTipTextAt(i++, tab.getMessageParameter().getBlock().getNumberString());
        }
        sorted = new TreeSet(values).iterator();
        int tabIndex = 0;
        while (sorted.hasNext()) {
            MessageDisplay tab = (MessageDisplay)sorted.next();
            BinaryOutBlockConnector blockConnector = (BinaryOutBlockConnector)tab.getMessageParameter().getBlock().getOutConnector(0);
            if (blockConnector.getBinaryValue()) {
                tabPane.setForegroundAt(tabIndex, Global.SIMULATION_COLOR_HIGH);
                tabPane.setSelectedIndex(tabIndex);
            } else {
                tabPane.setForegroundAt(tabIndex, Color.gray);
                tab.setEnabled(false);
            }
            ++tabIndex;
        }
        this.pack();
    }

    protected MessageDisplay getActiveMessageDisplay() {
        Component active = null;
        JTabbedPane tabPane = this.getJTabbedPane();
        int tabCount = tabPane.getTabCount();
        for (int i = tabCount - 1; i >= 0; --i) {
            if (!tabPane.getComponentAt(i).isEnabled()) continue;
            active = tabPane.getComponentAt(i);
            break;
        }
        return (MessageDisplay)active;
    }

    protected MessageDisplay getCurrentMessageDisplay() {
        Component selectedComponent = this.ivjJTabbedPane.getSelectedComponent();
        return selectedComponent != null ? (MessageDisplay)selectedComponent : null;
    }

    protected int getActivePriority() {
        int retValue = -1;
        JTabbedPane tabPane = this.getJTabbedPane();
        int tabCount = tabPane.getTabCount();
        for (int i = tabCount - 1; i >= 0; --i) {
            if (!tabPane.getComponentAt(i).isEnabled()) continue;
            retValue = Integer.parseInt(tabPane.getTitleAt(i));
            break;
        }
        return retValue;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.ivjJTabbedPane == null) {
            this.ivjJTabbedPane = new JTabbedPane();
            this.ivjJTabbedPane.setName("JTabbedPane");
        }
        return this.ivjJTabbedPane;
    }

    protected MessageDisplay getMessageDisplay(MessageParameter msgParameter) {
        return (MessageDisplay)this.fParamToDisplay.get(msgParameter);
    }

    public MessageManager getMessageManager() {
        return this.fMessageManager;
    }

    private JPanel getMessageWindowContentPane1() {
        if (this.ivjMessageWindowContentPane1 == null) {
            this.ivjMessageWindowContentPane1 = new JPanel();
            this.ivjMessageWindowContentPane1.setName("MessageWindowContentPane1");
            this.ivjMessageWindowContentPane1.setLayout(new BorderLayout());
            this.getMessageWindowContentPane1().add((Component)this.getJTabbedPane(), "Center");
        }
        return this.ivjMessageWindowContentPane1;
    }

    protected MessageDisplay getSelectedMessageDisplay() {
        JTabbedPane tabPane = this.getJTabbedPane();
        return (MessageDisplay)tabPane.getComponentAt(tabPane.getSelectedIndex());
    }

    protected int getSelectedPriority() {
        return Integer.parseInt(this.getJTabbedPane().getTitleAt(this.getJTabbedPane().getSelectedIndex()));
    }

    private void initialize() {
        this.setName("MessageWindow");
        this.setDefaultCloseOperation(2);
        this.setFont(new Font("dialog", 0, 8));
        this.setContentPane(this.getMessageWindowContentPane1());
        this.enabledMessageDisplays = new MessageDisplay[10];
        this.fBlockNumberLabel = new JLabel("Blocknumber");
        this.fGotoBlockAction = new MessageWindowGotoBlockAction();
        this.fGotoBlockAction.setOwner(this.fEditor);
        this.fEditBlockPropertiesAction = new MessageWindowEditBlockPropertiesAction();
        this.fEditBlockPropertiesAction.setOwner(this.fEditor);
        this.fPopupMenu = new LogoJPopupMenu();
        this.fPopupMenu.add(this.fBlockNumberLabel);
        this.fPopupMenu.addSeparator();
        this.fPopupMenu.add(this.fGotoBlockAction);
        this.fPopupMenu.add(this.fEditBlockPropertiesAction);
    }

    private void initTabbedPane() {
        MessageBlock[] blocks = this.fMessageManager.getMessageBlocks();
        this.fParamToDisplay.clear();
        this.enabledMessageDisplays = new MessageDisplay[10];
        RightClickHandler rightClickHandler = new RightClickHandler();
        GotoMessageBlockButtonHandler gotoMessageBlockButtonHandler = new GotoMessageBlockButtonHandler();
        for (int i = 0; i < blocks.length; ++i) {
            MessageParameter msgParam = (MessageParameter)blocks[i].getParameter();
            MessageDisplay msgDisplay = new MessageDisplay(msgParam);
            msgDisplay.setName(msgParam.getPriority().toString());
            msgDisplay.setLabels();
            msgParam.addParameterUpdateListener(this);
            msgParam.addParameterSetListener(this);
            msgParam.addParameterUpdateListener(msgDisplay);
            msgDisplay.addMessageReceiptListener(this);
            msgDisplay.addMessageReceiptListener(msgParam);
            this.fParamToDisplay.put(msgParam, msgDisplay);
            msgDisplay.getLogoDisplay().addMouseListener(rightClickHandler);
            JButton gotoMessageBlockButton = new JButton(Global.getIcon("Goto.gif"));
            gotoMessageBlockButton.setToolTipText(Language.getString("dialog.messageWindow.gotoMessageBlock.tooltip", "Goto message block %.", new Object[]{blocks[i].getNumberString()}));
            gotoMessageBlockButton.addActionListener(gotoMessageBlockButtonHandler);
            msgDisplay.getButtonPanel().add(gotoMessageBlockButton);
        }
    }

    public void messageReceipt(MessageDisplay messageDisplay) {
        if (messageDisplay.isEnabled()) {
            JTabbedPane tabPane = this.getJTabbedPane();
            int index = tabPane.indexOfComponent(messageDisplay);
            if (index < 0) {
                return;
            }
            messageDisplay.setEnabled(false);
            tabPane.setForegroundAt(index, new Color(50, 130, 200));
            if (messageDisplay == this.getSelectedMessageDisplay()) {
                this.updateTabbedPane();
            }
        }
    }

    public void parameterSet(final Parameter parameter, String newParameterText) {
        Runnable r = new Runnable(){

            public void run() {
                if (parameter instanceof MessageParameter) {
                    MessageParameter msgParam = (MessageParameter)parameter;
                    MessageDisplay msgDisplay = MessageWindow.this.getMessageDisplay(msgParam);
                    int newPrio = msgParam.getPriority();
                    boolean newReceipt = msgParam.isReceipt();
                    if (newPrio != Integer.parseInt(msgDisplay.getName())) {
                        MessageDisplay oldSelectedMsg = MessageWindow.this.getSelectedMessageDisplay();
                        msgDisplay.setName(String.valueOf(newPrio));
                        MessageWindow.this.fillTabbedPane();
                        if (newPrio > MessageWindow.this.getActivePriority() && msgDisplay.isEnabled()) {
                            MessageWindow.this.updateTabbedPane();
                        } else {
                            MessageWindow.this.getJTabbedPane().setSelectedComponent(oldSelectedMsg);
                        }
                    }
                    if (newReceipt != msgDisplay.isReceiptVisible()) {
                        msgDisplay.setReceiptVisible(msgParam.isReceipt());
                    }
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void parameterUpdated(final ParameterUpdateEvent parameterUpdateEvent) {
        if (!parameterUpdateEvent.getEventSource().equals("I0")) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                JTabbedPane tabPane = MessageWindow.this.getJTabbedPane();
                MessageParameter msgParam = (MessageParameter)parameterUpdateEvent.getParameter();
                MessageDisplay messageDisplay = (MessageDisplay)MessageWindow.this.fParamToDisplay.get(msgParam);
                int index = tabPane.indexOfComponent(messageDisplay);
                int newPrio = msgParam.getPriority();
                if (parameterUpdateEvent.getBinaryValue()) {
                    tabPane.setForegroundAt(index, Global.SIMULATION_COLOR_HIGH);
                    tabPane.getComponentAt(index).setEnabled(true);
                    messageDisplay.resetReceipt();
                    if (newPrio == MessageWindow.this.getActivePriority()) {
                        MessageWindow.this.updateTabbedPane();
                    }
                } else if (msgParam.isReceiptDone()) {
                    MessageWindow.this.messageReceipt(messageDisplay);
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void setEditorActivated(boolean editorActivated) {
        super.setVisible(editorActivated && this.currentVisibility);
    }

    public void setVisible(boolean visibility) {
        if (visibility != this.currentVisibility) {
            if (!visibility) {
                Iterator i = this.fParamToDisplay.values().iterator();
                while (i.hasNext()) {
                    ((MessageDisplay)i.next()).deactivateUpdate();
                }
            } else {
                for (MessageDisplay messageDisplay : this.fParamToDisplay.values()) {
                    messageDisplay.activateUpdate();
                    messageDisplay.activateDeactivateEditButton();
                }
                this.pack();
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                this.setLocation(screenSize.width - this.getWidth() - 20, screenSize.height - this.getHeight() - 60);
            }
            this.currentVisibility = visibility;
        }
        super.setVisible(visibility && this.fEditor.isActivated());
    }

    public void dispose() {
        this.currentVisibility = false;
        super.dispose();
    }

    public void startSimulation() {
        this.initTabbedPane();
        this.fillTabbedPane();
    }

    private void updateTabbedPane() {
        MessageDisplay nextMessageDisplay = this.getActiveMessageDisplay();
        if (nextMessageDisplay != null) {
            JTabbedPane tabPane = this.getJTabbedPane();
            boolean tabPaneHided = !this.getJTabbedPane().isVisible();
            this.getJTabbedPane().setSelectedComponent(nextMessageDisplay);
            if (!nextMessageDisplay.isEnabled()) {
                nextMessageDisplay.setEnabled(true);
            }
            if (tabPaneHided) {
                this.getJTabbedPane().setVisible(true);
            }
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        } else {
            this.setVisible(false);
        }
    }

    public Editor getEditor() {
        return this.fEditor;
    }

    public void setEditor(Editor editor) {
        this.fEditor = editor;
    }

    public void setMessageManager(MessageManager messageManager) {
        this.fMessageManager = messageManager;
    }

    public void checkSpecialMarkers() {
        int tabCount = this.getJTabbedPane().getComponentCount();
        MessageDisplay messageDisplay = null;
        for (int i = 0; i < tabCount; ++i) {
            boolean repaint = false;
            messageDisplay = (MessageDisplay)this.getJTabbedPane().getComponentAt(i);
            repaint |= messageDisplay.getLogoDisplay().setSimulationColor(this.getMessageManager().getLEDBackLightColor());
            if (!(repaint |= messageDisplay.updateDisplayModelRTF()) || this.getJTabbedPane().getSelectedIndex() != i) continue;
            messageDisplay.getLogoDisplay().repaint();
        }
    }

    private class GotoMessageBlockButtonHandler
    implements ActionListener {
        private GotoMessageBlockButtonHandler() {
        }

        public void actionPerformed(ActionEvent ae) {
            MessageDisplay currentMessageDisplay = MessageWindow.this.getCurrentMessageDisplay();
            if (currentMessageDisplay != null) {
                Block block = MessageWindow.this.getCurrentMessageDisplay().getMessageParameter().getBlock();
                MessageWindow.this.fGotoBlockAction.setBlock(block);
                MessageWindow.this.fGotoBlockAction.prepareAction();
                MessageWindow.this.fGotoBlockAction.doIt();
            }
        }
    }

    private class RightClickHandler
    extends MouseAdapter {
        private RightClickHandler() {
        }

        public void mousePressed(MouseEvent e) {
            LogoDisplay logoDisplay;
            DisplayElement displayElement;
            super.mousePressed(e);
            if (SwingUtilities.isRightMouseButton(e) && (displayElement = (logoDisplay = (LogoDisplay)e.getSource()).getModel().getElementAt(logoDisplay.getFocusPosition())) instanceof ParameterItem) {
                ParameterItem parameterItem = (ParameterItem)displayElement;
                Block block = parameterItem.getParameter().getBlock();
                MessageWindow.this.fBlockNumberLabel.setText(block.getLocalizedName(true));
                MessageWindow.this.fGotoBlockAction.setBlock(block);
                MessageWindow.this.fEditBlockPropertiesAction.setBlock(block);
                MessageWindow.this.fPopupMenu.show(logoDisplay, e.getX(), e.getY());
            }
        }
    }

    private class MessageWindowGotoBlockAction
    extends GotoBlockAction {
        private MessageWindowGotoBlockAction() {
        }

        public boolean prepareAction() {
            return true;
        }

        public void setBlock(Block block) {
            this.fBlock = block;
        }
    }

    private class MessageWindowEditBlockPropertiesAction
    extends EditBlockPropertiesAction {
        private MessageWindowEditBlockPropertiesAction() {
        }

        public boolean prepareAction() {
            return true;
        }

        public void setBlock(Block block) {
            this.fBlock = block;
        }
    }
}

