/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.model.OptionsIfc;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoProperties;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GeneralOptionsPanel
extends DataInputPanel {
    public OptionsIfc fOptions;
    protected JLabel fLanguageLabel;
    protected JComboBox fLanguagesCbx;

    public GeneralOptionsPanel(OptionsIfc options) {
        this.fOptions = options;
        this.initComponents();
    }

    public boolean checkChanged() {
        Object selectedItem = this.fLanguagesCbx.getSelectedItem();
        if (selectedItem == null) {
            return false;
        }
        return !Language.getString(this.fOptions.getLanguage(), "").equals(selectedItem);
    }

    protected String getForeignLanguage(String key) {
        String languageName = key;
        Properties languageProperty = LogoProperties.getProperties("Language_" + key.substring("language.".length()) + ".properties");
        Properties defaultProperty = null;
        if (languageProperty != null) {
            languageName = languageProperty.getProperty(key);
            if (languageName != null) {
                String defaultPropertyFileName = "Language.properties";
                defaultProperty = LogoProperties.getProperties("Language.properties");
                defaultProperty.setProperty(key, languageName);
                try {
                    LogoProperties.saveProperties(defaultProperty, "Language.properties");
                }
                catch (IOException ioe) {
                    System.out.println("To store language-translation in your settings the file 'Language.properties' must be writetable");
                }
            } else {
                languageName = key;
            }
        }
        return languageName;
    }

    public String getTitle() {
        String title = Language.getString("dialog.options.generalTab.pagePanel.language", "Language");
        return title;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.fLanguageLabel = new JLabel("Language");
        this.fLanguagesCbx = new JComboBox();
        GridBagConstraints gbc = null;
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)this.fLanguageLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)this.fLanguagesCbx, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)new JPanel(), gbc);
    }

    public void loadFieldContents() {
        String[] languages = this.fOptions.getLanguages();
        for (int i = 0; i < languages.length; ++i) {
            String item = Language.getString(languages[i], languages[i]);
            if (item.equals(languages[i])) {
                item = this.getForeignLanguage(languages[i]);
            }
            this.fLanguagesCbx.addItem(item);
        }
        this.fLanguagesCbx.setSelectedItem(Language.getString(this.fOptions.getLanguage(), ""));
    }

    public void setLabels() {
        this.fLanguageLabel.setText(Language.getString("dialog.options.generalTab.pagePanel.language", "Language"));
    }

    public void storeFieldContents() {
        this.storeFieldContents(true);
    }

    public void storeFieldContents(boolean showMessage) {
        if (showMessage) {
            JOptionPane.showMessageDialog(this, Language.getString("msg.restartProgram", "In order to change the language, you have to restart the program"), this.getTitle(), 1);
        }
        String[] languages = this.fOptions.getLanguages();
        if (this.fLanguagesCbx.getSelectedIndex() != -1) {
            this.fOptions.setLanguage(languages[this.fLanguagesCbx.getSelectedIndex()]);
        }
    }

    public String getHelpIdString() {
        return "extras.options.language";
    }
}

