/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import CH.ifa.draw.util.ColorMap;
import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.OpenComboBox;
import DE.siemens.ad.logo.util.ColorRenderer;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.standard.FontAttributes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontAttributesPanel
extends DataInputPanel
implements ListSelectionListener,
ActionListener,
ItemListener {
    protected OpenComboBox fFonts;
    protected OpenComboBox fSizes;
    protected BorderJPanel fFontBorderPanel;
    protected FontAttributes fFontAttributes;
    protected JLabel fColorLabel;
    protected JComboBox fColorComboBox;
    protected JCheckBox fBold;
    protected JCheckBox fItalic;
    protected BorderJPanel fEffects;
    protected BorderJPanel fPreviewBorderPanel;
    protected JLabel fPreviewLabel;
    protected JCheckBox fUseAsDefaultCheckBox;
    protected JButton fRestoreDefaultsButton;
    protected DefaultComboBoxModel fColorComboBoxModel;
    protected Object fLastSelectedColor;
    protected JColorChooser fColorChooser;
    protected Hashtable fFontRegistry;
    private Hashtable fPreviewStringsRegistry;

    private Dictionary getPreviewStringsRepository() {
        if (this.fPreviewStringsRegistry == null) {
            this.fPreviewStringsRegistry = new Hashtable();
        }
        return this.fPreviewStringsRegistry;
    }

    private String getPreviewString(Font f) {
        Dictionary previewStrings = this.getPreviewStringsRepository();
        if (previewStrings.get(f) == null) {
            String previewText = Language.getString("dialog.format.previewText", "Preview text");
            if (f.canDisplayUpTo(previewText) != -1) {
                previewText = "";
                for (int i = 0; i < 65536 && previewText.length() < 32; ++i) {
                    if (!f.canDisplay((char)i)) continue;
                    previewText = previewText + (char)i;
                }
            }
            previewStrings.put(f, previewText);
        }
        return (String)previewStrings.get(f);
    }

    public FontAttributesPanel(FontAttributes fontAttributes) {
        this.fFontAttributes = fontAttributes;
        this.initComponents();
        this.fFontRegistry = new Hashtable();
    }

    public void actionPerformed(ActionEvent e) {
        this.updatePreview();
    }

    public boolean checkChanged() {
        if (!this.fFonts.getList().getSelectedValue().equals(this.fFontAttributes.getFontName())) {
            return true;
        }
        if (((Integer)this.fSizes.getList().getSelectedValue()).intValue() != this.fFontAttributes.getFontSize()) {
            return true;
        }
        if (this.getStyle() != this.fFontAttributes.getFontStyle()) {
            return true;
        }
        if (!this.fColorComboBox.getSelectedItem().equals(this.fFontAttributes.getFontColor())) {
            return true;
        }
        return this.fUseAsDefaultCheckBox.isSelected();
    }

    public JColorChooser getColorChooser() {
        if (this.fColorChooser == null) {
            this.fColorChooser = new JColorChooser();
        }
        return this.fColorChooser;
    }

    public Dimension getPreferredSize() {
        return new Dimension(380, 430);
    }

    protected int getStyle() {
        int style = 0;
        style = this.fBold.isSelected() ? style | 1 : style;
        style = this.fItalic.isSelected() ? style | 2 : style;
        return style;
    }

    public String getTitle() {
        return Language.getString("dialog.format.title", "Font");
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.fFontBorderPanel = new BorderJPanel();
        this.fFontBorderPanel.setLayout(new GridLayout(1, 2, 5, 5));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.fFontBorderPanel, gbc);
        this.fFonts = new OpenComboBox();
        this.fFontBorderPanel.add(this.fFonts);
        this.fFonts.getList().setCellRenderer(new FontListCellRenderer());
        this.fSizes = new OpenComboBox();
        this.fFontBorderPanel.add(this.fSizes);
        this.fEffects = new BorderJPanel();
        this.fEffects.setTitle("Effects");
        this.fEffects.setLayout(new GridLayout(1, 2, 5, 5));
        this.fBold = new JCheckBox("Bold");
        this.fEffects.add(this.fBold);
        this.fItalic = new JCheckBox("Italic");
        this.fEffects.add(this.fItalic);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.fEffects, gbc);
        JPanel colorPanel = new JPanel(new BorderLayout());
        this.fColorLabel = new JLabel("Color: ");
        colorPanel.add((Component)this.fColorLabel, "West");
        this.fColorComboBox = new JComboBox();
        colorPanel.add((Component)this.fColorComboBox, "Center");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 1;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)colorPanel, gbc);
        this.fPreviewBorderPanel = new BorderJPanel();
        this.fPreviewBorderPanel.setTitle("Preview");
        JPanel previewBackground = new JPanel(new FlowLayout(1)){

            public Dimension getMinimumSize() {
                return new Dimension(50, 70);
            }
        };
        previewBackground.setBackground(Color.white);
        previewBackground.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.fPreviewBorderPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0);
        this.fPreviewBorderPanel.add((Component)previewBackground, gbc);
        this.fPreviewLabel = new JLabel("Text preview");
        previewBackground.add(this.fPreviewLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 1;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.fPreviewBorderPanel, gbc);
        JPanel defaultsPanel = new JPanel(new BorderLayout());
        this.fUseAsDefaultCheckBox = new JCheckBox("Use as default");
        this.fRestoreDefaultsButton = new JButton("Restore default");
        defaultsPanel.add((Component)this.fUseAsDefaultCheckBox, "West");
        defaultsPanel.add((Component)this.fRestoreDefaultsButton, "East");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.fill = 1;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(10, 5, 5, 5);
        this.add((Component)defaultsPanel, gbc);
        this.fFonts.getList().addListSelectionListener(this);
        this.fSizes.getList().addListSelectionListener(this);
        this.fColorComboBox.addItemListener(this);
        this.fBold.addActionListener(this);
        this.fItalic.addActionListener(this);
        this.fRestoreDefaultsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FontAttributesPanel.this.restoreDefaults();
            }
        });
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        if (this.fColorComboBox.getSelectedItem().equals("additionalColors")) {
            this.getColorChooser();
            Color color = JColorChooser.showDialog(this, "Farbauswahl", Color.blue);
            if (color != null) {
                String userDefinedColor = "RGB=" + color.getRGB();
                this.fColorComboBoxModel.insertElementAt(userDefinedColor, 0);
                this.fColorComboBox.setSelectedItem(userDefinedColor);
            } else {
                this.fColorComboBox.setSelectedItem(this.fLastSelectedColor);
            }
        } else {
            this.fLastSelectedColor = e.getItem();
        }
        this.updatePreview();
    }

    public void loadFieldContents() {
        DefaultListModel<String> fontsModel = new DefaultListModel<String>();
        for (int i = 0; i < this.fFontAttributes.getFontNames().length; ++i) {
            fontsModel.addElement(this.fFontAttributes.getFontNames()[i]);
        }
        this.fFonts.getList().setModel(fontsModel);
        DefaultListModel<Integer> sizesModel = new DefaultListModel<Integer>();
        for (int i = 0; i < this.fFontAttributes.getFontSizes().length; ++i) {
            sizesModel.addElement(new Integer("" + this.fFontAttributes.getFontSizes()[i]));
        }
        this.fSizes.getList().setModel(sizesModel);
        this.fColorComboBoxModel = new DefaultComboBoxModel<String>(this.fFontAttributes.getFontColors());
        if (ColorMap.isUserdefinedColor(this.fFontAttributes.getDefaultFontColor()) && !this.fFontAttributes.getDefaultFontColor().equals(this.fFontAttributes.getFontColor())) {
            this.fColorComboBoxModel.insertElementAt(this.fFontAttributes.getDefaultFontColor(), 0);
        }
        if (ColorMap.isUserdefinedColor(this.fFontAttributes.getFontColor())) {
            this.fColorComboBoxModel.insertElementAt(this.fFontAttributes.getFontColor(), 0);
        }
        this.fColorComboBoxModel.addElement("additionalColors");
        this.fColorComboBox.setModel(this.fColorComboBoxModel);
        this.fColorComboBox.setRenderer(new ColorRenderer());
        this.fBold.setSelected((this.fFontAttributes.getFontStyle() & 1) != 0);
        this.fItalic.setSelected((this.fFontAttributes.getFontStyle() & 2) != 0);
        this.fFonts.getList().setSelectedValue(this.fFontAttributes.getFontName(), true);
        this.fSizes.getList().setSelectedValue(new Integer(this.fFontAttributes.getFontSize()), true);
        this.fColorComboBox.setSelectedItem(this.fFontAttributes.getFontColor());
        this.fUseAsDefaultCheckBox.setSelected(this.fFontAttributes.isUseAsDefault());
    }

    private void restoreDefaults() {
        this.fFonts.getList().setSelectedValue(this.fFontAttributes.getDefaultFontName(), true);
        this.fSizes.getList().setSelectedValue(new Integer(this.fFontAttributes.getDefaultFontSize()), true);
        this.fBold.setSelected((this.fFontAttributes.getDefaultFontStyle() & 1) != 0);
        this.fItalic.setSelected((this.fFontAttributes.getDefaultFontStyle() & 2) != 0);
        this.fColorComboBox.setSelectedItem(this.fFontAttributes.getDefaultFontColor());
    }

    public void setLabels() {
        this.fFontBorderPanel.setTitle(Language.getString("dialog.format.font", "Font"));
        this.fFonts.setTitle(Language.getString("dialog.format.fontName", "Name"));
        this.fSizes.setTitle(Language.getString("dialog.format.fontSize", "Size"));
        this.fEffects.setTitle(Language.getString("dialog.format.fontStylePanel.title", "Effects"));
        this.fBold.setText(Language.getString("dialog.format.fontStylePanel.bold", "Bold"));
        this.fItalic.setText(Language.getString("dialog.format.fontStylePanel.italic", "Italic"));
        this.fColorLabel.setText(Language.getString("dialog.format.fontColor", "Color") + "  ");
        this.fUseAsDefaultCheckBox.setText(Language.getString("dialog.useAsDefault", "Use as default"));
        this.fRestoreDefaultsButton.setText(Language.getString("dialog.format.restoreDefault", "Restore default"));
        this.fPreviewBorderPanel.setTitle(Language.getString("dialog.format.preview", "Preview"));
        this.fPreviewLabel.setText(Language.getString("dialog.format.previewText", "Preview text"));
    }

    public void storeFieldContents() {
        this.fFontAttributes.setFontName((String)this.fFonts.getList().getSelectedValue());
        this.fFontAttributes.setFontSize((Integer)this.fSizes.getList().getSelectedValue());
        this.fFontAttributes.setFontStyle(this.getStyle());
        this.fFontAttributes.setFontColor((String)this.fColorComboBox.getSelectedItem());
        this.fFontAttributes.setUseAsDefault(this.fUseAsDefaultCheckBox.isSelected());
    }

    private void updatePreview() {
        Object selectedSize;
        int style = 0;
        style = this.fBold.isSelected() ? style | 1 : style;
        style = this.fItalic.isSelected() ? style | 2 : style;
        String selectedFont = (String)this.fFonts.getList().getSelectedValue();
        if (selectedFont == null) {
            selectedFont = this.fFontAttributes.getDefaultFontName();
        }
        if ((selectedSize = this.fSizes.getList().getSelectedValue()) == null) {
            selectedSize = new Integer(12);
        }
        Font f = new Font(selectedFont, style, (Integer)selectedSize);
        Color c = ColorMap.color((String)this.fColorComboBox.getSelectedItem());
        this.fPreviewLabel.setText(this.getPreviewString(f));
        this.fPreviewLabel.setFont(f);
        this.fPreviewLabel.setForeground(c);
    }

    public void valueChanged(ListSelectionEvent e) {
        this.updatePreview();
    }

    private class FontLoader
    implements Runnable {
        String fontname;

        public FontLoader(String name) {
            this.fontname = name;
        }

        public void run() {
            Font font = new Font(this.fontname, 0, 12);
            FontAttributesPanel.this.fFontRegistry.put(this.fontname, font);
            FontAttributesPanel.this.fFonts.repaint();
        }
    }

    private class FontListCellRenderer
    extends OpenComboBox.DefaultNameListCellRenderer {
        private JLabel fNameLabel = new JLabel();
        private JLabel fSymbolLabel = new JLabel();

        public Component getListCellRendererComponent(JList list, Object value, int row, boolean selected, boolean focus) {
            super.getListCellRendererComponent((JList<?>)list, value, row, selected, focus);
            Font f = (Font)FontAttributesPanel.this.fFontRegistry.get(value);
            if (f == null) {
                new Thread(new FontLoader((String)value)).start();
            } else {
                String name = f.getName();
                this.setText(name);
                this.setFont(f);
                if (f.canDisplayUpTo(name) == -1) {
                    this.removeAll();
                } else {
                    this.fNameLabel.setText(name);
                    this.fSymbolLabel.setText(FontAttributesPanel.this.getPreviewString(f));
                    this.fSymbolLabel.setFont(f);
                    this.setLayout(new BorderLayout());
                    this.add((Component)this.fNameLabel, "West");
                    this.add((Component)this.fSymbolLabel, "Center");
                    this.setSize(list.getCellBounds(row, row).getSize());
                    this.doLayout();
                    this.setText("");
                }
            }
            return this;
        }
    }
}

