/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.app.comp.NumericSpinnerListener;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.dialog.comp.SpinnerChangedEvent;
import DE.siemens.ad.logo.util.CalendarListener;
import DE.siemens.ad.logo.util.Language;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class DateChooserPanel
extends DataInputPanel
implements NumericSpinnerListener {
    protected boolean fShowDayOfWeekTooltip;
    protected EditableNumericSpinner fYearSpinner;
    protected BorderJPanel fDayBorderPanel;
    protected BorderJPanel fMonthBorderPanel;
    protected BorderJPanel fYearBorderPanel;
    protected Vector fMonthButtons;
    protected Vector fDayButtons;
    protected Hashtable fDayLabels;
    protected int fDay;
    protected int fMonth;
    protected int fYear;
    protected Vector fDateListener;
    protected Vector fCalendarListeners;
    protected Calendar fCalendar;
    private final int fMinYear;
    private final int fMaxYear;

    public DateChooserPanel() {
        this(1999, 2098);
    }

    public DateChooserPanel(int minYear, int maxYear) {
        this.fMinYear = minYear;
        this.fMaxYear = maxYear;
        this.fCalendar = Calendar.getInstance();
        this.initComponents();
    }

    public void addCalendarListener(CalendarListener cl) {
        if (!this.getCalendarListeners().contains(cl)) {
            this.getCalendarListeners().add(cl);
        }
    }

    public void enableDisableButtons() {
        for (int i = 0; i < this.fDayButtons.size(); ++i) {
            ((JToggleButton)this.fDayButtons.elementAt(i)).setEnabled(this.isDateValid(this.getYear(), this.getMonth(), i + 1, false));
        }
    }

    public void fireInvalidDateEvent() {
        Vector clone = this.getCalendarListeners();
        Enumeration e = clone.elements();
        while (e.hasMoreElements()) {
            ((CalendarListener)e.nextElement()).invalidDate(this);
        }
    }

    public void fireValidDateEvent() {
        Vector clone = this.getCalendarListeners();
        Enumeration e = clone.elements();
        while (e.hasMoreElements()) {
            ((CalendarListener)e.nextElement()).validDate(this);
        }
    }

    public Vector getCalendarListeners() {
        if (this.fCalendarListeners == null) {
            this.fCalendarListeners = new Vector();
        }
        return this.fCalendarListeners;
    }

    public int getDay() {
        return this.fDay;
    }

    public int getMonth() {
        return this.fMonth;
    }

    public String getTitle() {
        return Language.getString("dialog.calendar.title", "Select date");
    }

    public int getYear() {
        return this.fYear;
    }

    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.fYearBorderPanel = new BorderJPanel();
        this.fYearBorderPanel.setLayout(new FlowLayout(0));
        this.fYearSpinner = new EditableNumericSpinner();
        this.fYearSpinner.setMin(this.fMinYear);
        this.fYearSpinner.setMax(this.fMaxYear);
        this.fYearSpinner.addNumericSpinnerListener(this);
        this.fYearBorderPanel.add(this.fYearSpinner);
        this.add(this.fYearBorderPanel);
        this.fMonthBorderPanel = new BorderJPanel();
        MonthButtonListener monthButtonListener = new MonthButtonListener();
        this.fMonthBorderPanel.setLayout(new GridLayout(2, 6));
        this.fMonthButtons = new Vector();
        ButtonGroup monthButtonGroup = new ButtonGroup();
        JToggleButton monthButton = null;
        for (int i = 1; i <= 12; ++i) {
            monthButton = new JToggleButton(String.valueOf(i));
            this.fMonthButtons.add(monthButton);
            this.fMonthBorderPanel.add(monthButton);
            monthButtonGroup.add(monthButton);
            monthButton.addActionListener(monthButtonListener);
        }
        this.add(this.fMonthBorderPanel);
        this.fDayBorderPanel = new BorderJPanel();
        DayButtonListener dayButtonListener = new DayButtonListener();
        this.fDayBorderPanel.setLayout(new GridLayout(5, 7));
        this.fDayButtons = new Vector();
        ButtonGroup dayButtonGroup = new ButtonGroup();
        DayToggleButton dayButton = null;
        for (int i = 1; i <= 31; ++i) {
            dayButton = new DayToggleButton();
            dayButton.setToolTipText("day");
            dayButton.setText(String.valueOf(i));
            this.fDayButtons.add(dayButton);
            this.fDayBorderPanel.add(dayButton);
            dayButtonGroup.add(dayButton);
            dayButton.addActionListener(dayButtonListener);
        }
        this.add(this.fDayBorderPanel);
        this.setYear(2000);
        this.setMonth(1);
        this.setDay(1);
    }

    public boolean isDateValid(int year, int month, int day, boolean fireEvent) {
        boolean valid;
        this.fCalendar = Calendar.getInstance();
        this.fCalendar.clear();
        this.fCalendar.set(year, month - 1, 1);
        boolean bl = valid = day <= this.fCalendar.getActualMaximum(5);
        if (fireEvent) {
            if (valid) {
                this.fireValidDateEvent();
            } else {
                this.fireInvalidDateEvent();
            }
        }
        return valid;
    }

    public boolean isYearVisible() {
        return this.fYearBorderPanel.isVisible();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        try {
            UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
        }
        catch (Exception e) {
            // empty catch block
        }
        DateChooserPanel dcp = new DateChooserPanel();
        dcp.setLabels();
        dcp.setDate(2001, 6, 29);
        f.setDefaultCloseOperation(2);
        SplittedDlg sd = SplittedDlg.create(f, dcp, 11);
        sd.show();
    }

    public void removeCalendarListener(CalendarListener cl) {
        this.getCalendarListeners().remove(cl);
    }

    public void setDate(int year, int month, int day) {
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
    }

    public void setDay(int newDay) {
        JToggleButton button;
        if (!this.isDateValid(this.getYear(), this.getMonth(), newDay, true)) {
            // empty if block
        }
        if (!(button = (JToggleButton)this.fDayButtons.elementAt(newDay - 1)).isSelected()) {
            button.setSelected(true);
        }
        this.fDay = newDay;
        this.enableDisableButtons();
    }

    public void setLabels() {
        this.fDayBorderPanel.setTitle(Language.getString("dialog.setClock.day", "Day"));
        this.fMonthBorderPanel.setTitle(Language.getString("dialog.setClock.month", "Month"));
        this.fYearBorderPanel.setTitle(Language.getString("dialog.setClock.year", "Year"));
        this.fDayLabels = new Hashtable();
        this.fDayLabels.put(new Integer(1), Language.getString("dialog.parameter.cam.sunday", "Sunday"));
        this.fDayLabels.put(new Integer(2), Language.getString("dialog.parameter.cam.monday", "Monday"));
        this.fDayLabels.put(new Integer(3), Language.getString("dialog.parameter.cam.tuesday", "Tuesday"));
        this.fDayLabels.put(new Integer(4), Language.getString("dialog.parameter.cam.wednesday", "Wednesday"));
        this.fDayLabels.put(new Integer(5), Language.getString("dialog.parameter.cam.thursday", "Thursday"));
        this.fDayLabels.put(new Integer(6), Language.getString("dialog.parameter.cam.friday", "Friday"));
        this.fDayLabels.put(new Integer(7), Language.getString("dialog.parameter.cam.saturday", "Saturday"));
    }

    public void setMonth(int newMonth) {
        JToggleButton button;
        if (!this.isDateValid(this.getYear(), newMonth, this.getDay(), true)) {
            // empty if block
        }
        if (!(button = (JToggleButton)this.fMonthButtons.elementAt(newMonth - 1)).isSelected()) {
            button.setSelected(true);
        }
        this.fMonth = newMonth;
        this.enableDisableButtons();
    }

    public void setYear(int newYear) {
        if (!this.isDateValid(newYear, this.getMonth(), this.getDay(), true)) {
            // empty if block
        }
        if (this.fYearSpinner.getValue() != newYear) {
            this.fYearSpinner.setValue(newYear);
        }
        this.fYear = newYear;
        this.enableDisableButtons();
    }

    public void setYearVisible(boolean newYearVisible) {
        this.fYearBorderPanel.setVisible(newYearVisible);
        this.setShowDayOfWeekTooltip(newYearVisible);
        this.revalidate();
    }

    public void spinnerChanged(SpinnerChangedEvent se) {
        this.setYear(this.fYearSpinner.getValue());
    }

    public boolean getShowDayOfWeekTooltip() {
        return this.fShowDayOfWeekTooltip;
    }

    public void setShowDayOfWeekTooltip(boolean showDayOfWeekTooltip) {
        this.fShowDayOfWeekTooltip = showDayOfWeekTooltip;
    }

    public class DayToggleButton
    extends JToggleButton {
        public String getToolTipText() {
            if (DateChooserPanel.this.fShowDayOfWeekTooltip) {
                DateChooserPanel.this.fCalendar.clear();
                int day = DateChooserPanel.this.fDayButtons.indexOf(this) + 1;
                DateChooserPanel.this.fCalendar.set(DateChooserPanel.this.getYear(), DateChooserPanel.this.getMonth() - 1, day);
                return (String)DateChooserPanel.this.fDayLabels.get(new Integer(DateChooserPanel.this.fCalendar.get(7)));
            }
            return null;
        }
    }

    public class MonthButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            int month = DateChooserPanel.this.fMonthButtons.indexOf(ae.getSource());
            DateChooserPanel.this.setMonth(month + 1);
        }
    }

    public class DayButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            int day = DateChooserPanel.this.fDayButtons.indexOf(ae.getSource()) + 1;
            DateChooserPanel.this.setDay(day);
        }
    }
}

