/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.dialog.BlockSelectionPanel;
import DE.siemens.ad.logo.dialog.comp.BlockListCellRenderer;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockConnector;
import DE.siemens.ad.logo.model.BlockGroup;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.pdraw.standard.IconTextTooltip;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CompactBlockSelectionPanel
extends JPanel
implements DocumentListener,
ListSelectionListener {
    protected boolean fBlockNumbersVisible;
    protected JTextField fShortcutTextfield;
    protected JList fBlockList;
    protected JList fConnectorList;
    protected JPanel fConnectorListContainer;
    protected BlockVerifier fBlockVerifier;
    protected ConnectorVerifier fConnectorVerifier;
    protected List fBlocks;
    private LogoDrawing fLogoDrawing;
    protected List fBlockSelectionListeners;

    public CompactBlockSelectionPanel(BlockGroup blockGroup) {
        this.fBlockNumbersVisible = false;
        this.initComponents();
        this.setConnectorsVisible(false);
        this.createBlockList(blockGroup);
        this.fillBlockList(this.fShortcutTextfield.getText());
    }

    public CompactBlockSelectionPanel(List blocks) {
        this.fBlockNumbersVisible = true;
        this.initComponents();
        this.fBlocks = blocks;
        this.fBlockList.setModel(new DefaultComboBoxModel<Object>(blocks.toArray()));
    }

    public CompactBlockSelectionPanel(LogoDrawing drawing) {
        this.fBlockNumbersVisible = true;
        this.fBlocks = drawing.getWiringDiagram().getBlocks();
        this.fLogoDrawing = drawing;
        this.initComponents();
        this.fBlockList.setModel(new DefaultComboBoxModel<Object>(this.fBlocks.toArray()));
    }

    public CompactBlockSelectionPanel(Vector blocks, LogoDrawing drawing) {
        this.fBlockNumbersVisible = true;
        this.fBlocks = blocks;
        this.fLogoDrawing = drawing;
        this.initComponents();
        this.fBlockList.setModel(new DefaultComboBoxModel<Object>(this.fBlocks.toArray()));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.fShortcutTextfield = new JTextField();
        this.fBlockList = new JList();
        this.fBlockList.setSelectionMode(0);
        this.fBlockList.addListSelectionListener(new BlockListSelectionListener());
        this.fBlockList.setBackground(IconTextTooltip.WARNING);
        this.fBlockList.addListSelectionListener(this);
        BlockListCellRenderer blockListCellRenderer = this.fLogoDrawing != null ? new BlockListCellRenderer(this.fBlockNumbersVisible, this.fLogoDrawing) : new BlockListCellRenderer(this.fBlockNumbersVisible);
        this.fBlockList.setCellRenderer(blockListCellRenderer);
        this.fShortcutTextfield.getDocument().addDocumentListener(this);
        this.add((Component)this.fShortcutTextfield, "North");
        this.add((Component)new JScrollPane(this.fBlockList), "Center");
        this.fShortcutTextfield.registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                int delimiterPosition = CompactBlockSelectionPanel.this.fShortcutTextfield.getText().indexOf(32);
                int caretPosition = CompactBlockSelectionPanel.this.fShortcutTextfield.getCaretPosition();
                if (delimiterPosition != -1 && caretPosition > delimiterPosition) {
                    CompactBlockSelectionPanel.this.fConnectorList.requestFocus();
                } else {
                    CompactBlockSelectionPanel.this.fBlockList.requestFocus();
                }
            }
        }, KeyStroke.getKeyStroke(40, 0), 2);
        this.fConnectorListContainer = new JPanel(new BorderLayout());
        this.add((Component)this.fConnectorListContainer, "East");
        this.fConnectorList = new JList();
        this.fConnectorList.setSelectionMode(0);
        this.fConnectorList.setMinimumSize(new Dimension(100, 0));
        this.fConnectorList.setBackground(new Color(226, 255, 229));
        this.fConnectorList.setBorder(BorderFactory.createBevelBorder(1));
        this.fConnectorList.setCellRenderer(new ParameterListCellRenderer());
        this.fConnectorListContainer.add(Box.createHorizontalStrut(30), "North");
        this.fConnectorListContainer.add((Component)this.fConnectorList, "Center");
    }

    private void createBlockList(BlockGroup blockGroup) {
        this.fBlocks = new ArrayList(30);
        this.addBlockGroup(this.fBlocks, blockGroup);
    }

    private void addBlockGroup(List blockList, BlockGroup blockGroup) {
        for (Object block : blockGroup.getBlocks()) {
            if (block instanceof BlockGroup) {
                if (((BlockGroup)block).getElementCount() <= 0) continue;
                this.addBlockGroup(blockList, (BlockGroup)block);
                continue;
            }
            blockList.add(block);
        }
    }

    private void fillBlockList(String prefix) {
        String blockPrefix = prefix.toLowerCase();
        int dividerIndex = prefix.indexOf(32);
        if (dividerIndex != -1) {
            blockPrefix = prefix.toLowerCase().substring(0, dividerIndex).toLowerCase();
        }
        DefaultComboBoxModel<Block> listModel = new DefaultComboBoxModel<Block>();
        for (Block block : this.fBlocks) {
            if (this.fBlockVerifier != null && !this.fBlockVerifier.isBlockValid(block)) continue;
            if (prefix.startsWith("*")) {
                if (block.getLocalizedName(this.fBlockNumbersVisible).toLowerCase().indexOf(blockPrefix.substring(1)) == -1) continue;
                listModel.addElement(block);
                continue;
            }
            if (!block.getLocalizedName(this.fBlockNumbersVisible).toLowerCase().startsWith(blockPrefix)) continue;
            listModel.addElement(block);
        }
        this.fBlockList.setModel(listModel);
        if (listModel.getSize() > 0) {
            this.fBlockList.setSelectedIndex(0);
            this.fillConnectorList((Block)this.fBlockList.getSelectedValue());
        }
    }

    public void requestFocus() {
        this.fShortcutTextfield.requestFocus();
        this.fShortcutTextfield.selectAll();
        this.fillBlockList(this.fShortcutTextfield.getText());
    }

    public Dimension getPreferredSize() {
        return new Dimension(150, 200);
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        this.fillBlockList(this.fShortcutTextfield.getText());
    }

    public void removeUpdate(DocumentEvent e) {
        this.fillBlockList(this.fShortcutTextfield.getText());
    }

    public void addBlockSelectionListener(BlockSelectionPanel.BlockSelectionListener l) {
        if (!this.getBlockSelectionListeners().contains(l)) {
            this.fBlockSelectionListeners.add(l);
        }
    }

    public List getBlockSelectionListeners() {
        if (this.fBlockSelectionListeners == null) {
            this.fBlockSelectionListeners = new ArrayList(3);
        }
        return this.fBlockSelectionListeners;
    }

    public Block getSelectedBlock() {
        return (Block)this.fBlockList.getSelectedValue();
    }

    public BlockConnector getSelectedConnector() {
        return (BlockConnector)this.fConnectorList.getSelectedValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSelectionGainedEvent(Block selectedBlock) {
        if (!this.getBlockSelectionListeners().isEmpty()) {
            ArrayList l;
            CompactBlockSelectionPanel compactBlockSelectionPanel = this;
            synchronized (compactBlockSelectionPanel) {
                l = new ArrayList(this.getBlockSelectionListeners());
            }
            for (int i = 0; i < l.size(); ++i) {
                BlockSelectionPanel.BlockSelectionListener bsl = (BlockSelectionPanel.BlockSelectionListener)l.get(i);
                bsl.selectionGained(selectedBlock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSelectionLostEvent(Block selectedBlock) throws PropertyVetoException {
        if (!this.getBlockSelectionListeners().isEmpty()) {
            ArrayList l;
            CompactBlockSelectionPanel compactBlockSelectionPanel = this;
            synchronized (compactBlockSelectionPanel) {
                l = new ArrayList(this.getBlockSelectionListeners());
            }
            for (int i = 0; i < l.size(); ++i) {
                BlockSelectionPanel.BlockSelectionListener bsl = (BlockSelectionPanel.BlockSelectionListener)l.get(i);
                bsl.selectionLost(selectedBlock);
            }
        }
    }

    public void removeBlockSelectionListener(BlockSelectionPanel.BlockSelectionListener l) {
        this.getBlockSelectionListeners().remove(l);
    }

    public void valueChanged(ListSelectionEvent e) {
    }

    private void fillConnectorList(Block block) {
        String parameterPrefix = "";
        int delimiterIndex = this.fShortcutTextfield.getText().indexOf(32);
        if (delimiterIndex != -1) {
            parameterPrefix = this.fShortcutTextfield.getText().substring(delimiterIndex + 1);
        }
        DefaultComboBoxModel<InBlockConnector> parameterListModel = new DefaultComboBoxModel<InBlockConnector>();
        if (block != null) {
            for (int i = 0; i < block.getInConnectorCount(); ++i) {
                if (this.fConnectorVerifier != null && !this.fConnectorVerifier.isConnectorValid(block.getInConnector(i)) || !block.getInConnector(i).getName().toLowerCase().startsWith(parameterPrefix.toLowerCase())) continue;
                parameterListModel.addElement(block.getInConnector(i));
            }
        }
        this.fConnectorList.setModel(parameterListModel);
        if (parameterListModel.getSize() > 0) {
            this.fConnectorList.setSelectedIndex(0);
        }
    }

    public boolean isConnectorsVisible() {
        return this.fConnectorListContainer.isVisible();
    }

    public void setConnectorsVisible(boolean connectorsVisible) {
        this.fConnectorListContainer.setVisible(connectorsVisible);
    }

    public JList getBlockList() {
        return this.fBlockList;
    }

    public JList getConnectorList() {
        return this.fConnectorList;
    }

    public BlockVerifier getBlockVerifier() {
        return this.fBlockVerifier;
    }

    public void setBlockVerifier(BlockVerifier blockVerifier) {
        this.fBlockVerifier = blockVerifier;
    }

    public ConnectorVerifier getConnectorVerifier() {
        return this.fConnectorVerifier;
    }

    public void setConnectorVerifier(ConnectorVerifier connectorVerifier) {
        this.fConnectorVerifier = connectorVerifier;
    }

    private class ParameterListCellRenderer
    extends DefaultListCellRenderer {
        private ParameterListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof BlockConnector) {
                BlockConnector blockConnector = (BlockConnector)value;
                this.setText(blockConnector.getName());
            }
            return this;
        }
    }

    private class BlockListSelectionListener
    implements ListSelectionListener {
        private BlockListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            Object selectedValue = CompactBlockSelectionPanel.this.fBlockList.getSelectedValue();
            CompactBlockSelectionPanel.this.fillConnectorList((Block)selectedValue);
        }
    }

    public static interface ConnectorVerifier {
        public boolean isConnectorValid(BlockConnector var1);
    }

    public static interface BlockVerifier {
        public boolean isBlockValid(Block var1);
    }
}

