/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.model.OptionsIfc;
import DE.siemens.ad.logo.util.ColorDialog;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoPreviewPanel;
import DE.siemens.ad.logo.util.LogoProperties;
import java.awt.BorderLayout;
import java.util.Vector;
import javax.swing.Icon;

public class ColorOptionsPanel
extends DataInputPanel {
    protected ColorDialog fColorDialog;

    public ColorOptionsPanel() {
        this.initComponents();
    }

    public ColorOptionsPanel(OptionsIfc options) {
        this.initComponents();
    }

    public String getTitle() {
        return Language.getString("dialog.options.color", "Colors");
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.fColorDialog = new ColorDialog(true);
        this.add(this.fColorDialog.getColorDialogPanel());
    }

    public void loadFieldContents() {
    }

    public void setColor(Vector vector) {
        LogoProperties properties = LogoProperties.instance();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                LogoPreviewPanel prev = (LogoPreviewPanel)vector.get(i);
                String simColor = ColorDialog.getRGBofColor(prev.getColor());
                String property = null;
                property = prev.getKey().equals("Background") ? "backColor" : (prev.getKey().equals("Connection_Low") ? "simulation.color.low" : (prev.getKey().equals("Connection_High") ? "simulation.color.high" : prev.getKey()));
                if (property == null) continue;
                properties.setProperty(property, simColor);
            }
            Global.refreshColors();
        }
        properties.saveProperties();
    }

    public void setLabels() {
    }

    public void storeFieldContents() {
        this.setColor(this.fColorDialog.getLogoPreviewPanels());
        Application.getInstance().getActiveApplicationSurface().repaint();
    }

    public Icon getIcon() {
        return Global.getIcon("Colors.gif");
    }
}

