/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.app.comp.NumericSpinnerListener;
import DE.siemens.ad.logo.dialog.comp.SpinnerChangedEvent;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class AutoCutLinesPanel
extends DataInputPanel {
    protected JCheckBox fCutLinesIntersectingBlocks;
    protected JCheckBox fCutLongLines;
    protected EditableNumericSpinner fCutLimit;
    protected JLabel fCutLimitLabel;
    protected JLabel fCutLimitUnit;
    protected JLabel fCutLinesIntersectingBlocksLabel;
    protected LogoDrawingView fView;
    protected BorderJPanel fPreviewPanel;
    protected JPanel fPagePanel;
    private JCheckBox fSplitConnectionsOnImport;

    public AutoCutLinesPanel() {
        this.initComponents();
    }

    public AutoCutLinesPanel(LogoDrawingView view) {
        this.fView = view;
        this.initComponents();
    }

    private void enableDisableComponents() {
        this.fCutLimit.setEnabled(this.fCutLongLines.isSelected());
    }

    public String getTitle() {
        return Language.getString("dialog.autoCutLines.title", "Auto cut lines");
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = null;
        Insets insets = new Insets(3, 3, 3, 3);
        this.fSplitConnectionsOnImport = new JCheckBox("Split on Upload/Import");
        gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)this.fSplitConnectionsOnImport, gbc);
        JPanel cutLinesIntersectingBlocksPanel = new JPanel();
        cutLinesIntersectingBlocksPanel.setLayout(new BoxLayout(cutLinesIntersectingBlocksPanel, 0));
        this.fCutLinesIntersectingBlocks = new JCheckBox();
        cutLinesIntersectingBlocksPanel.add(this.fCutLinesIntersectingBlocks);
        this.fCutLinesIntersectingBlocksLabel = new JLabel("Cut lines intersecting blocks");
        cutLinesIntersectingBlocksPanel.add(this.fCutLinesIntersectingBlocksLabel);
        gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)cutLinesIntersectingBlocksPanel, gbc);
        JPanel cutLongLinesPanel = new JPanel();
        cutLongLinesPanel.setLayout(new BoxLayout(cutLongLinesPanel, 0));
        this.fCutLongLines = new JCheckBox();
        cutLongLinesPanel.add(this.fCutLongLines);
        this.fCutLimitLabel = new JLabel("Cut lines longer than");
        cutLongLinesPanel.add(this.fCutLimitLabel);
        cutLongLinesPanel.add(Box.createRigidArea(new Dimension(5, 5)));
        this.fCutLimit = new EditableNumericSpinner();
        cutLongLinesPanel.add(this.fCutLimit);
        cutLongLinesPanel.add(Box.createRigidArea(new Dimension(5, 5)));
        this.fCutLimitUnit = new JLabel("points");
        cutLongLinesPanel.add(this.fCutLimitUnit);
        gbc = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add((Component)cutLongLinesPanel, gbc);
        this.fPreviewPanel = new BorderJPanel();
        this.fPreviewPanel.setLayout(new BorderLayout());
        JPanel backgroundPanel = new JPanel(new FlowLayout(1));
        backgroundPanel.setBackground(Global.BACKGROUND_COLOR_APP);
        backgroundPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.fPagePanel = new PagePanel(null);
        this.fPagePanel.setBorder(new LineBorder(Color.black));
        this.fPagePanel.setBackground(Global.BACKGROUND_COLOR);
        this.fPagePanel.setSize(100, 130);
        this.fPagePanel.setMinimumSize(new Dimension(100, 130));
        this.fPagePanel.setPreferredSize(new Dimension(100, 130));
        backgroundPanel.add(this.fPagePanel);
        this.fPreviewPanel.add(backgroundPanel);
        gbc = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 13, 1, insets, 0, 0);
        this.add((Component)this.fPreviewPanel, gbc);
        this.fCutLongLines.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AutoCutLinesPanel.this.enableDisableComponents();
            }
        });
        this.fCutLimit.addNumericSpinnerListener(new NumericSpinnerListener(){

            public void spinnerChanged(SpinnerChangedEvent sce) {
                AutoCutLinesPanel.this.fPagePanel.repaint();
            }
        });
    }

    public boolean isResizable() {
        return true;
    }

    public Dimension getPreferredSize() {
        return new Dimension(440, 300);
    }

    public void loadFieldContents() {
        LogoProperties logoProperties = LogoProperties.instance();
        this.fSplitConnectionsOnImport.setSelected(this.getSplitConnectionsOnImport(logoProperties));
        this.fCutLinesIntersectingBlocks.setSelected(logoProperties.getBooleanProperty("autoCutLines.cutLinesIntersectingBlocks", true));
        this.fCutLongLines.setSelected(logoProperties.getBooleanProperty("autoCutLines.cutLongLines", true));
        this.fCutLimit.setMin(50);
        this.fCutLimit.setMax(1000);
        this.fCutLimit.setIncrement(5);
        this.fCutLimit.setValue(logoProperties.getIntProperty("autoCutLines.cutLimit", 300));
        this.enableDisableComponents();
        int imagableWidth = logoProperties.getIntProperty("pageFormat.imagesize.width", 750);
        int imagableHeight = logoProperties.getIntProperty("pageFormat.imagesize.height", 500);
        this.fPagePanel.setPreferredSize(new Dimension(imagableWidth, imagableHeight));
        this.fPagePanel.setSize(this.fPagePanel.getPreferredSize());
    }

    public void setLabels() {
        this.fSplitConnectionsOnImport.setText(Language.getString("dialog.options.generalTab.splitConnectionsOnImport", "Split connections"));
        this.fCutLinesIntersectingBlocksLabel.setText(Language.getString("dialog.autoCutLines.cutLinesIntersectingBlocks", "Cut lines intersecting blocks"));
        this.fCutLimitLabel.setText(Language.getString("dialog.autoCutLines.cutLongLines", "Cut lines longer than"));
        this.fCutLimitUnit.setText(Language.getString("dialog.autoCutLines.limitUnit", "points"));
        this.fPreviewPanel.setTitle(Language.getString("global.preview", "Preview"));
        this.revalidate();
    }

    public void storeFieldContents() {
        LogoProperties logoProperties = LogoProperties.instance();
        logoProperties.setBooleanProperty("splitConnectionsOnImport", this.fSplitConnectionsOnImport.isSelected());
        logoProperties.setBooleanProperty("autoCutLines.cutLinesIntersectingBlocks", this.fCutLinesIntersectingBlocks.isSelected());
        logoProperties.setBooleanProperty("autoCutLines.cutLongLines", this.fCutLongLines.isSelected());
        logoProperties.setProperty("autoCutLines.cutLimit", "" + this.fCutLimit.getValue());
    }

    private boolean getSplitConnectionsOnImport(LogoProperties logoProperties) {
        boolean splitConnectionsOnImport = true;
        String splitConnectinString = logoProperties.getProperty("splitConnectionsOnImport");
        if (splitConnectinString != null) {
            splitConnectionsOnImport = Boolean.valueOf(splitConnectinString);
        }
        return splitConnectionsOnImport;
    }

    public Icon getIcon() {
        return Global.getIcon("CutConnectToolSmall.gif");
    }

    private class PagePanel
    extends JPanel {
        private static final double SCALE = 0.25;

        public PagePanel() {
            this.setLayout(null);
        }

        public PagePanel(LayoutManager lm) {
            super(lm);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int x = this.getPreferredSize().width / 2;
            int y = this.getPreferredSize().height / 2;
            int blockWidth = 6;
            int blockHeight = 8;
            int cutLimit = (int)((double)AutoCutLinesPanel.this.fCutLimit.getValue() * 0.25);
            g.setColor(new Color(204, 204, 255));
            g.fillOval(x - cutLimit / 2, y - cutLimit / 2, cutLimit, cutLimit);
            g.setColor(Color.darkGray);
            g.drawOval(x - cutLimit / 2, y - cutLimit / 2, cutLimit, cutLimit);
            g.setColor(new Color(255, 222, 140));
            g.fillRect(x - blockWidth / 2, y - blockHeight / 2, blockWidth, blockHeight);
            g.setColor(Color.black);
            g.drawRect(x - blockWidth / 2, y - blockHeight / 2, blockWidth, blockHeight);
            ((Graphics2D)g).scale(0.25, 0.25);
            g.drawString("&", (int)((double)x / 0.25), (int)((double)y / 0.25));
            ((Graphics2D)g).scale(4.0, 4.0);
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            Dimension ret = new Dimension((int)((double)d.width * 0.25), (int)((double)d.height * 0.25));
            return ret;
        }
    }
}

