/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.RolloverButton;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.dialog.SplashPanel;
import DE.siemens.ad.logo.dialog.comp.TableSorter;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.MemoryMonitor;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.logo.util.Version;
import bsh.Console;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class AboutPanel
extends DataInputPanel {
    protected SplashPanel fSplashPanel;
    protected JPanel fJavaPanel;
    protected HiddenFeaturesPanel fHiddenFeatuersPanel;
    protected JTabbedPane fTabbedPane;
    protected JPanel fVMPropertiesPanel;
    private JPanel fIniPropertiesPanel;

    public AboutPanel() {
        this.initialize();
    }

    private void initialize() {
        this.fTabbedPane = new JTabbedPane();
        this.fTabbedPane.addTab("General", this.getSplashPanel());
        this.fTabbedPane.addTab("System", this.getJavaPanel());
        this.setLayout(new BorderLayout());
        this.add(this.fTabbedPane);
        this.fTabbedPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SwingUtilities.getAncestorOfClass(JDialog.class, AboutPanel.this).setVisible(false);
                Console.main((String[])new String[0]);
            }
        }, KeyStroke.getKeyStroke(66, 2), 2);
        this.fTabbedPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MemoryMonitor.main(new String[0]);
            }
        }, KeyStroke.getKeyStroke(77, 2), 2);
        this.fTabbedPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (AboutPanel.this.fVMPropertiesPanel == null) {
                    TableSorter sortedVmTableModel = new TableSorter(new PropertiesTableModel(System.getProperties(), false));
                    JTable vmPropertiesTable = new JTable(sortedVmTableModel);
                    vmPropertiesTable.setDragEnabled(true);
                    sortedVmTableModel.addMouseListenerToHeaderInTable(vmPropertiesTable);
                    AboutPanel.this.fVMPropertiesPanel = new JPanel(new BorderLayout());
                    AboutPanel.this.fVMPropertiesPanel.add(new JScrollPane(vmPropertiesTable));
                    AboutPanel.this.fTabbedPane.add("VMProperties", AboutPanel.this.fVMPropertiesPanel);
                    AboutPanel.this.fIniPropertiesPanel = new IniPropertiesPanel();
                    AboutPanel.this.fTabbedPane.add(".ini-Properties", AboutPanel.this.fIniPropertiesPanel);
                    AboutPanel.this.fHiddenFeatuersPanel = new HiddenFeaturesPanel();
                    AboutPanel.this.fTabbedPane.add("Hidden Features", AboutPanel.this.fHiddenFeatuersPanel);
                } else {
                    AboutPanel.this.fTabbedPane.remove(AboutPanel.this.fVMPropertiesPanel);
                    AboutPanel.this.fTabbedPane.remove(AboutPanel.this.fIniPropertiesPanel);
                    AboutPanel.this.fVMPropertiesPanel = null;
                }
            }
        }, KeyStroke.getKeyStroke(80, 2), 2);
    }

    protected String getJavaInfoString() {
        StringBuffer javaInfo = new StringBuffer();
        javaInfo.append("Runtime Name: ");
        javaInfo.append(System.getProperty("java.runtime.name"));
        javaInfo.append("\n");
        javaInfo.append("VM Name: \t");
        javaInfo.append(System.getProperty("java.vm.name"));
        javaInfo.append("\n");
        javaInfo.append("VM Version: \t");
        javaInfo.append(System.getProperty("java.vm.version"));
        javaInfo.append("\n");
        javaInfo.append("No DirectDraw: \t");
        javaInfo.append(System.getProperty("sun.java2d.noddraw"));
        javaInfo.append("\n");
        javaInfo.append("System locale: \t");
        javaInfo.append(System.getProperty("user.language"));
        javaInfo.append("\n\n");
        javaInfo.append("Java Home: \t");
        javaInfo.append(System.getProperty("java.home"));
        javaInfo.append("\n");
        javaInfo.append("Working Dir: \t");
        javaInfo.append(System.getProperty("user.dir"));
        javaInfo.append("\n");
        javaInfo.append("Classpath: \t");
        javaInfo.append(System.getProperty("java.class.path"));
        javaInfo.append("\n");
        javaInfo.append("Library Path: \t");
        javaInfo.append(System.getProperty("java.library.path"));
        javaInfo.append("\n");
        javaInfo.append("INI-file: \t");
        javaInfo.append(LogoProperties.getUserPropertyFileName());
        javaInfo.append("\n\n");
        javaInfo.append("Program version: \t");
        javaInfo.append(Version.getCurrentVersion().toString());
        javaInfo.append("\n");
        javaInfo.append("Program timestamp: \t");
        javaInfo.append(Version.getCurrentVersion().getBuildTime());
        javaInfo.append("\n");
        javaInfo.append("Language used: \t");
        javaInfo.append(Language.getLocale());
        javaInfo.append("\n");
        javaInfo.append("Language version: \t");
        javaInfo.append(Language.getString("language.version", ""));
        javaInfo.append("\n");
        javaInfo.append("Updates:\n");
        String updateInfo = LogoProperties.instance().getProperty("update.log", "");
        StringTokenizer st = new StringTokenizer(updateInfo, ";");
        while (st.hasMoreElements()) {
            javaInfo.append("\t");
            javaInfo.append(st.nextToken().trim());
            javaInfo.append("\n");
        }
        javaInfo.append("\n");
        javaInfo.append("OS Name: \t");
        javaInfo.append(System.getProperty("os.name"));
        javaInfo.append("\n");
        javaInfo.append("OS Version: \t");
        javaInfo.append(System.getProperty("os.version"));
        javaInfo.append("\n");
        javaInfo.append("Processor: \t");
        javaInfo.append(System.getProperty("os.arch"));
        javaInfo.append("\n\n");
        NumberFormat nf = NumberFormat.getInstance();
        Runtime runtime = Runtime.getRuntime();
        javaInfo.append("Total Java Memory: \t");
        String s = nf.format(runtime.totalMemory() / 1000L);
        javaInfo.append(s);
        javaInfo.append(" kB\n");
        javaInfo.append("Free Java Memory: \t");
        int lengthTotal = s.length();
        s = nf.format(runtime.freeMemory() / 1000L);
        for (int i = 0; i < lengthTotal - s.length(); ++i) {
            javaInfo.append(" ");
        }
        javaInfo.append(s);
        javaInfo.append(" kB\n");
        return javaInfo.toString();
    }

    protected JPanel getJavaPanel() {
        if (this.fJavaPanel == null) {
            this.fJavaPanel = new JPanel(new BorderLayout());
            JTextArea javaInfoArea = new JTextArea();
            javaInfoArea.setEditable(false);
            this.fJavaPanel.add(new JScrollPane(javaInfoArea));
            javaInfoArea.setText(this.getJavaInfoString());
        }
        return this.fJavaPanel;
    }

    public Dimension getPreferredSize() {
        return new Dimension(430, super.getPreferredSize().height);
    }

    protected SplashPanel getSplashPanel() {
        if (this.fSplashPanel == null) {
            this.fSplashPanel = new SplashPanel();
        }
        return this.fSplashPanel;
    }

    public String getTitle() {
        return Language.getString("dialog.about.title", "About %", Application.getName());
    }

    public void setLabels() {
        this.fTabbedPane.setTitleAt(0, Language.getString("dialog.options.generalTab.label", "General"));
        this.fTabbedPane.setTitleAt(1, Language.getString("dialog.about.system", "System"));
        this.fSplashPanel.setLabels();
    }

    private class PropertiesTableModel
    extends DefaultTableModel {
        private boolean fModelEditable;

        public PropertiesTableModel(Properties properties, boolean modelEditable) {
            this.fModelEditable = modelEditable;
            Properties Properties2 = System.getProperties();
            Vector fPropertyList = new Vector(properties.size());
            Iterator<Object> i = properties.keySet().iterator();
            boolean row = false;
            Object key = null;
            while (i.hasNext()) {
                key = i.next();
                Vector<Object> property = new Vector<Object>(2);
                property.add(key);
                property.add(properties.get(key));
                fPropertyList.add(property);
            }
            Vector<String> headerList = new Vector<String>(2);
            headerList.add("key");
            headerList.add("value");
            this.setDataVector(fPropertyList, headerList);
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        public Properties getProperties() {
            Properties p = new Properties();
            for (List property : this.dataVector) {
                p.put(property.get(0), property.get(1));
            }
            return p;
        }

        public int getColumnCount() {
            return 2;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.fModelEditable;
        }
    }

    private class HiddenFeaturesPanel
    extends DataInputPanel {
        public HiddenFeaturesPanel() {
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BoxLayout(this, 1));
            JButton showResources = new JButton("Show block resources");
            this.add(showResources);
            showResources.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String resourceString = null;
                    try {
                        StringWriter stringWriter = new StringWriter();
                        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
                        Util.exportBlockResources(bufferedWriter);
                        resourceString = stringWriter.toString();
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(AboutPanel.this, ex.getStackTrace(), "Hidden Features Error", 0);
                        return;
                    }
                    DataInputPanel resourceTextPanel = new DataInputPanel(){

                        public String getTitle() {
                            return "Block resources";
                        }
                    };
                    resourceTextPanel.setLayout(new BorderLayout());
                    resourceTextPanel.add((Component)new JLabel("Simply selecta all and drag or copy the text to an excel-sheet!"), "North");
                    JTextArea resourceTextArea = new JTextArea(resourceString);
                    resourceTextArea.setDragEnabled(true);
                    resourceTextArea.setEditable(false);
                    resourceTextPanel.add(new JScrollPane(resourceTextArea));
                    JDialog dialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, AboutPanel.this);
                    SplittedDlg splittedDlg = SplittedDlg.create(dialog, resourceTextPanel, 1);
                    splittedDlg.setSize(700, 500);
                    splittedDlg.show();
                }
            });
            final JCheckBox quicktestHelpNavigation = new JCheckBox("Help-Navigation in Quicktest", LogoProperties.instance().getBooleanProperty("quicktest.embeddedHelp.navigation", false));
            this.add(quicktestHelpNavigation);
            quicktestHelpNavigation.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    LogoProperties.instance().setBooleanProperty("quicktest.embeddedHelp.navigation", quicktestHelpNavigation.isSelected());
                }
            });
        }
    }

    private class IniPropertiesPanel
    extends DataInputPanel {
        private JButton fSaveButton;
        private JButton fRemoveRowsButton;
        private JButton fInsertRowButton;
        private JTable fIniPropertiesTable;
        private PropertiesTableModel fIniPropertiesTableModel;
        private TableSorter fSortedTableModel;

        public IniPropertiesPanel() {
            this.initComponents();
            this.registerListeners();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.fIniPropertiesTableModel = new PropertiesTableModel(LogoProperties.instance().getProperties(), true);
            this.fSortedTableModel = new TableSorter(this.fIniPropertiesTableModel);
            this.fIniPropertiesTable = new JTable(this.fSortedTableModel);
            this.fIniPropertiesTable.setDragEnabled(true);
            this.fSortedTableModel.addMouseListenerToHeaderInTable(this.fIniPropertiesTable);
            this.add(new JScrollPane(this.fIniPropertiesTable));
            JPanel toolbar = new JPanel(new FlowLayout(3));
            this.fInsertRowButton = new RolloverButton("Insert row", Global.getIcon("Add.gif"));
            toolbar.add(this.fInsertRowButton);
            this.fRemoveRowsButton = new RolloverButton("Remove rows", Global.getIcon("Delete.gif"));
            toolbar.add(this.fRemoveRowsButton);
            this.add((Component)toolbar, "North");
            JPanel savePanel = new JPanel(new FlowLayout(2, 5, 5));
            this.fSaveButton = new JButton("Save", Global.getIcon("Save.gif"));
            this.fSaveButton.setEnabled(false);
            savePanel.add(this.fSaveButton);
            this.add((Component)savePanel, "South");
        }

        private void registerListeners() {
            this.fSaveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LogoProperties logoProperties = LogoProperties.instance();
                    logoProperties.setProperties(IniPropertiesPanel.this.fIniPropertiesTableModel.getProperties());
                    logoProperties.saveProperties();
                    IniPropertiesPanel.this.fSaveButton.setEnabled(false);
                    JOptionPane.showMessageDialog(IniPropertiesPanel.this, "Properties (.ini-File) saved to disk. ", "Properties saved", 1);
                }
            });
            this.fRemoveRowsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int[] rows = IniPropertiesPanel.this.fIniPropertiesTable.getSelectedRows();
                    for (int i = rows.length - 1; i >= 0; --i) {
                        IniPropertiesPanel.this.fIniPropertiesTableModel.removeRow(IniPropertiesPanel.this.fSortedTableModel.getRowInOriginalTable(rows[i]));
                    }
                    IniPropertiesPanel.this.fSortedTableModel.sort(this);
                }
            });
            this.fInsertRowButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Vector<String> property = new Vector<String>(2);
                    property.add("");
                    property.add("");
                    IniPropertiesPanel.this.fIniPropertiesTableModel.insertRow(IniPropertiesPanel.this.fIniPropertiesTableModel.getRowCount(), property);
                    Dimension tableSize = IniPropertiesPanel.this.fIniPropertiesTable.getPreferredSize();
                    IniPropertiesPanel.this.fIniPropertiesTable.scrollRectToVisible(new Rectangle(tableSize.width, tableSize.height, 1, 1));
                }
            });
            this.fIniPropertiesTableModel.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent e) {
                    IniPropertiesPanel.this.fSaveButton.setEnabled(true);
                }
            });
        }
    }
}

