/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.comm;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.pdraw.app.ModemManager;
import DE.siemens.ad.pdraw.util.LogoComfortStatusLine;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Modem {
    private static Modem instance;
    private DataTransfer fDataTransfer;
    public static final int STATUS_DISCONNECTED = 0;
    public static final int STATUS_CONNECTING = 1;
    public static final int STATUS_CONNECTED = 2;
    public static final int STATUS_DISCONNECTING = 3;
    protected int fModemStatus = 0;
    private String remotePassword;
    private static final int LOCAL_TIMEOUT = 5000;
    private static final int MIN_TIMEOUT = 15000;
    private static final int MAX_TIMEOUT = 120000;
    private static final int REMOTE_INTERVAL = 200;
    public static final String REMOTE_CONFIG_COMMAND = "AT&F &D0 E0 &K0 \\N0 *P1 S0=2 X4 &W";
    private static final String REMOTE_PORT_SETTING_COMMAND = "AT *U8 &W";
    private static final String LOCAL_INIT_COMMAND = "AT&F E0 M0 \\N0 X4 &W";
    private static final boolean NEED_REMOTE_CONFIG = false;
    private CancelDialog fCancelDlg;

    public static Modem getInstance() {
        if (instance == null) {
            instance = new Modem();
        }
        return instance;
    }

    private Modem() {
    }

    public static boolean isModemConnected() {
        if (instance == null) {
            return false;
        }
        if (Modem.instance.fDataTransfer == null) {
            Modem.instance.fModemStatus = 0;
        }
        return Modem.instance.fModemStatus == 2;
    }

    public static int getModemStatus() {
        if (Modem.isModemConnected()) {
            return 2;
        }
        return 0;
    }

    public void setDataTransfer(DataTransfer dt) {
        if (this.fDataTransfer == dt) {
            return;
        }
        if (this.fDataTransfer != null && dt != null) {
            System.err.println("Existed DataTranfer Object detected");
        }
        if (this.fDataTransfer != null) {
            this.fDataTransfer.closePort();
        }
        this.fDataTransfer = dt;
    }

    public DataTransfer getDataTransfer() {
        return this.fDataTransfer;
    }

    private int readInternalByte() throws TransmissionFailedException {
        try {
            return this.fDataTransfer.readInternalByte();
        }
        catch (TransmissionFailedException e) {
            if (e.getError() != 244) {
                throw e;
            }
            return -1;
        }
    }

    public static boolean configRemoteModem(String portName, String remoteCommand) {
        DataTransfer dt = null;
        try {
            boolean ret = false;
            dt = DataTransfer.getPortByName(portName, true, false);
            Modem.getInstance().setDataTransfer(dt);
            ret = Modem.getInstance().sendModemCommand(remoteCommand);
            Modem.getInstance().setDataTransfer(null);
            return ret;
        }
        catch (ExceptionAlreadyHandledException e) {
            if (dt != null) {
                dt.closePort();
            }
            return false;
        }
    }

    public boolean connectModem(String portName, String localCommand, boolean showError) {
        boolean ret = false;
        if (DataTransfer.fTestModem) {
            this.showConnectStatus(2);
            return true;
        }
        try {
            this.showConnectStatus(1);
            boolean retry = true;
            while (retry) {
                if (this.sendModemCommand(localCommand)) {
                    retry = false;
                    ret = true;
                    continue;
                }
                retry = LogoError.checkRepeatTransmission(new TransmissionFailedException(177));
            }
            if (!ret) {
                this.showConnectStatus(0);
                return ret;
            }
            if (this.getPhoneNumber() == null) {
                new LogoError(null, "modem.noAddress", "No address has been selected.", 1, 0).display();
                ret = false;
                this.showConnectStatus(0);
                return ret;
            }
            ret = this.dial(this.getPhoneNumber());
            this.showConnectStatus(ret ? 2 : 0);
            return ret;
        }
        catch (Exception e) {
            this.showConnectStatus(0);
            return false;
        }
    }

    public void disconnectModem() {
        try {
            if (Modem.isModemConnected()) {
                Thread.sleep(1200L);
                this.fDataTransfer.writeToOutputStream(43);
                this.fDataTransfer.writeToOutputStream(43);
                this.fDataTransfer.writeToOutputStream(43);
                Thread.sleep(1200L);
                this.fDataTransfer.writeToOutputStream(65);
                this.fDataTransfer.writeToOutputStream(84);
                this.fDataTransfer.writeToOutputStream(72);
                this.fDataTransfer.writeToOutputStream(13);
                this.showConnectStatus(0);
                this.setDataTransfer(null);
                Log.println(Language.getString("modem.log.disconnected", "Modem Disconnected"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getValidPhoneNumber(String preNumber) {
        try {
            String valid = "0123456789#,";
            StringBuffer ret = new StringBuffer();
            for (int i = 0; i < preNumber.length(); ++i) {
                if ("0123456789#,".indexOf(preNumber.charAt(i)) == -1) continue;
                ret.append(preNumber.charAt(i));
            }
            if (ret.length() == 0) {
                return null;
            }
            return ret.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean dial(String phoneNumber) {
        boolean ret = false;
        String validPhoneNumber = this.getValidPhoneNumber(phoneNumber);
        if (validPhoneNumber == null) {
            return ret;
        }
        String commandString = "ATDT " + validPhoneNumber;
        try {
            this.fCancelDlg = new CancelDialog(Application.getName());
            this.fCancelDlg.setLabel(Language.getString("modem.waitCancel.Dialing", "dialing..."));
            WaitDialingThread waitThread = new WaitDialingThread(this.fCancelDlg, commandString);
            waitThread.start();
            this.fCancelDlg.show();
            int threadRet = this.fCancelDlg.getValue();
            this.fCancelDlg = null;
            if (threadRet == 0) {
                System.out.println("Connection exit (" + System.currentTimeMillis() + "): " + commandString);
                ret = true;
            } else if (threadRet == 1) {
                this.fDataTransfer.writeToOutputStream(13);
                waitThread.sendExitFlag();
            } else if (threadRet == 3) {
                this.remotePassword = this.getRemotePinCode();
                if (this.remotePassword != null) {
                    Thread.sleep(1000L);
                    ret = this.testPassword(this.remotePassword);
                }
            } else {
                throw new Exception();
            }
            return ret;
        }
        catch (Exception e) {
            Log.println(Language.getString("modem.err.dialing", "Can not connect to remote modem."));
            this.fCancelDlg = null;
            return false;
        }
    }

    private boolean testPassword(String password) {
        this.fCancelDlg = new CancelDialog(Application.getName());
        this.fCancelDlg.setLabel(Language.getString("modem.waitCancel.CheckPassword", "Checking password..."));
        WaitingCheckPassword waitThread = new WaitingCheckPassword(this.fCancelDlg, password);
        waitThread.start();
        this.fCancelDlg.show();
        int threadRet = this.fCancelDlg.getValue();
        this.fCancelDlg = null;
        if (threadRet == 0) {
            return true;
        }
        Log.println(Language.getString("modem.err.wrongPassword", "Incorrect password remote configuration"));
        return false;
    }

    private boolean writeModem(String toWrite, boolean appendCR, String[] success, String[] failed, boolean localModem, int timeout, boolean checkEcho) {
        int i;
        int sizeSuccess = success == null ? 0 : success.length;
        int sizefailed = failed == null ? 0 : failed.length;
        String[] newStrings = new String[sizeSuccess + sizefailed];
        for (i = 0; i < sizeSuccess; ++i) {
            newStrings[i] = success[i];
        }
        for (i = 0; i < sizefailed; ++i) {
            newStrings[sizeSuccess + i] = failed[i];
        }
        int ret = this.writeModem(toWrite, appendCR, newStrings, localModem, timeout, checkEcho);
        return ret != -1 && ret < sizeSuccess;
    }

    private int writeModem(String toWrite, boolean appendCR, String[] knownStrings, boolean localModem, int timeout, boolean checkEcho) {
        int ret = -1;
        try {
            this.fDataTransfer.reset();
            for (int i = 0; i < toWrite.length(); ++i) {
                this.fDataTransfer.writeToOutputStream(toWrite.charAt(i));
                System.out.print("\nWrite to modem: " + toWrite.charAt(i) + " " + System.currentTimeMillis());
                if (checkEcho) {
                    try {
                        System.out.print("; Byte: " + this.readInternalByte());
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (localModem) continue;
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (appendCR) {
                this.fDataTransfer.writeToOutputStream(13);
            }
            Thread.sleep(1000L);
            long start = System.currentTimeMillis();
            StringBuffer feedBack = new StringBuffer();
            while (System.currentTimeMillis() - start < (long)timeout) {
                int readValue = this.readInternalByte();
                if (readValue != -1 && readValue != 0) {
                    feedBack.append((char)readValue);
                    ret = this.myContains(feedBack.toString().toUpperCase(), knownStrings);
                    if (ret == -1) continue;
                    break;
                }
                Thread.yield();
            }
            System.out.println(toWrite + "(" + start + " - " + System.currentTimeMillis() + "): <<" + feedBack.toString() + ">>");
            feedBack = null;
            return ret;
        }
        catch (Exception e) {
            System.out.println("Write modem error.");
            return -1;
        }
    }

    public boolean sendModemCommand(String commandString) {
        if (!commandString.startsWith("AT") && !commandString.startsWith("at")) {
            return false;
        }
        this.fCancelDlg = new CancelDialog(Application.getName());
        this.fCancelDlg.setLabel(Language.getString("modem.waitCancel.ConfigModem", "Config Modem ..."));
        WaitingConfigLocal waitThread = new WaitingConfigLocal(this.fCancelDlg, commandString);
        waitThread.start();
        this.fCancelDlg.show();
        int threadRet = this.fCancelDlg.getValue();
        this.fCancelDlg = null;
        if (threadRet == 0) {
            return true;
        }
        Log.println(Language.getString("modem.err.localConfigFailed", "Failed to config modem."));
        return false;
    }

    protected boolean remoteConfigRemoteModem() {
        this.fCancelDlg = new CancelDialog(Application.getName());
        this.fCancelDlg.setLabel(Language.getString("modem.waitCancel.ConfigRemote", "Config remote Modem ..."));
        WaitingConfigRemote waitThread = new WaitingConfigRemote(this.fCancelDlg);
        waitThread.start();
        this.fCancelDlg.show();
        int threadRet = this.fCancelDlg.getValue();
        this.fCancelDlg = null;
        if (threadRet == 0) {
            return true;
        }
        Log.println(Language.getString("modem.err.remoteConfigFailed", "Failed to config remote modem."));
        return false;
    }

    private String getRemoteModemName() {
        return this.getAddressInfo(ModemManager.getColumnKeys()[0]);
    }

    private String getPhoneNumber() {
        return this.getAddressInfo(ModemManager.getColumnKeys()[1]);
    }

    private String getRemotePinCode() {
        try {
            String ret = this.getAddressInfo(Language.getString("dialog.options.connectionTab.addressBook.pinCode", "Pin Code"));
            if (ret == null || ret.length() == 0) {
                ret = PasswordPanel.getPassword();
            } else {
                Log.println(Language.getString("modem.log.getPasswordFromAddressBook", "Get password from address book."));
            }
            if (ret != null && ret.length() == 0) {
                ret = null;
            }
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getAddressInfo(String columnName) {
        int row = ModemManager.getAddressBook().getSelectedIndex();
        int column = ModemManager.getColumnIndex(columnName);
        if (row != -1 && column != -1) {
            return ModemManager.getAddressBook().getData()[row][column];
        }
        return null;
    }

    protected void showConnectStatus(int status) {
        try {
            this.fModemStatus = status;
            LogoComfortStatusLine statusLine = (LogoComfortStatusLine)Application.getInstance().getActiveApplicationSurface().getStatusLine();
            if (statusLine != null) {
                statusLine.setModemStatus(this.fModemStatus);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int myContains(String feedBack, String[] objectStrings) {
        int ret = -1;
        if (feedBack == null || objectStrings == null) {
            return ret;
        }
        try {
            for (int i = 0; i < objectStrings.length; ++i) {
                if (!feedBack.contains(objectStrings[i])) continue;
                ret = i;
            }
            return ret;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static class DelayUnit {
        protected int fDelayTime;
        protected int fValue;
        protected long fStartTime;

        public DelayUnit(int value, int delayTime) {
            this.fValue = value;
            this.fDelayTime = delayTime;
            this.fStartTime = System.currentTimeMillis();
        }

        public boolean isDelayOK() {
            return System.currentTimeMillis() - this.fStartTime > (long)this.fDelayTime;
        }

        public int getIntValue() {
            return this.fValue;
        }
    }

    public static class DelayOutputStream
    extends OutputStream {
        OutputStream fOutputStream = null;
        ArrayBlockingQueue fQueue = null;
        private static final int delayTime = 500;
        static int flag = 0;

        public DelayOutputStream(OutputStream os) {
            this.fOutputStream = os;
            this.fQueue = new ArrayBlockingQueue(4096);
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                public void run() {
                    if (flag != 0) {
                        return;
                    }
                    flag = 1;
                    try {
                        while (DelayOutputStream.this.fQueue.peek() != null && ((DelayUnit)DelayOutputStream.this.fQueue.peek()).isDelayOK()) {
                            DelayUnit e = (DelayUnit)DelayOutputStream.this.fQueue.poll();
                            DelayOutputStream.this.fOutputStream.write(e.getIntValue());
                            DelayOutputStream.this.fOutputStream.flush();
                        }
                    }
                    catch (Exception e) {
                        flag = 0;
                    }
                    flag = 0;
                }
            }, 0L, 50L);
        }

        public void write(int b) throws IOException {
            this.fQueue.add(new DelayUnit(b, 500));
        }

        public void write(byte[] b) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public static class DelayInputStream
    extends InputStream {
        InputStream fInputStream = null;
        private static final int delayTime = 500;
        public ArrayBlockingQueue fQueue = null;
        static int flag = 0;
        static final int bufferSize = 8192;

        public DelayInputStream(InputStream is) {
            this.fInputStream = is;
            this.fQueue = new ArrayBlockingQueue(8192);
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                public void run() {
                    if (flag != 0) {
                        return;
                    }
                    flag = 1;
                    byte[] arr = new byte[128];
                    try {
                        int count = DelayInputStream.this.fInputStream.read(arr);
                        for (int i = 0; i < count; ++i) {
                            DelayInputStream.this.fQueue.add(new DelayUnit(arr[i], 500));
                        }
                    }
                    catch (Exception e) {
                        flag = 0;
                    }
                    flag = 0;
                }
            }, 0L, 50L);
        }

        public int read() throws IOException {
            if (this.fQueue.peek() != null) {
                DelayUnit e = (DelayUnit)this.fQueue.poll();
                return e.getIntValue() + 256 & 0xFF;
            }
            return this.fInputStream.read();
        }

        public int read(byte[] b) throws IOException {
            int ret = 0;
            try {
                for (int i = 0; i < b.length && this.fQueue.peek() != null && ((DelayUnit)this.fQueue.peek()).isDelayOK(); ++i) {
                    DelayUnit e = (DelayUnit)this.fQueue.poll();
                    b[i] = (byte)(e.getIntValue() + 256 & 0xFF);
                    ++ret;
                }
            }
            catch (Exception e) {
                System.out.println("DelayInputStream read input error");
            }
            if (ret == 0 && this.fQueue.size() == 8192) {
                System.out.println("Read but no input from Stream: " + System.currentTimeMillis());
            }
            return ret;
        }
    }

    protected class WaitDialingThread
    extends WaitThread {
        protected String fCommandString;
        protected int lifeCycle;

        public WaitDialingThread(CancelDialog dlg, String command) {
            super(dlg);
            this.lifeCycle = 0;
            this.fCommandString = command;
        }

        protected void runLongTimeJob() throws Exception {
            Modem.this.fDataTransfer.writeToOutputStream(13);
            Thread.sleep(1000L);
            Modem.this.fDataTransfer.reset();
            for (int i = 0; i < this.fCommandString.length(); ++i) {
                Modem.this.fDataTransfer.writeToOutputStream(this.fCommandString.charAt(i));
            }
            Modem.this.fDataTransfer.writeToOutputStream(13);
            long startTime = System.currentTimeMillis();
            long waitPasswordNotifyTime = 0L;
            StringBuffer feedBack = new StringBuffer();
            boolean connected = false;
            while (!this.fExitFlag) {
                block10: {
                    block8: {
                        String feedBackString;
                        block9: {
                            if (System.currentTimeMillis() - startTime > 122000L) {
                                this.returnValue = 4;
                                break;
                            }
                            if (System.currentTimeMillis() - startTime > 121000L) {
                                Modem.this.fDataTransfer.writeToOutputStream(13);
                                Thread.sleep(200L);
                                continue;
                            }
                            int readValue = Modem.this.readInternalByte();
                            if (readValue == -1) break block8;
                            feedBack.append((char)readValue);
                            feedBackString = feedBack.toString().toUpperCase();
                            if (feedBackString.contains("NO DIALTONE") || feedBackString.contains("BUSY") || feedBackString.contains("NO CARRIER") || feedBackString.contains("BLACKLISTED") || feedBackString.contains("NO ANSWER")) {
                                this.returnValue = 2;
                                break;
                            }
                            if (!connected) break block9;
                            if (feedBackString.contains("PASSWORD:")) {
                                this.returnValue = 3;
                                break;
                            }
                            break block10;
                        }
                        if (!feedBackString.contains("CONNECT")) break block10;
                        connected = true;
                        waitPasswordNotifyTime = System.currentTimeMillis();
                        break block10;
                    }
                    if (connected && System.currentTimeMillis() - waitPasswordNotifyTime > 5000L) {
                        this.returnValue = 0;
                        break;
                    }
                }
                if ((System.currentTimeMillis() - startTime) / 1000L > (long)this.lifeCycle) {
                    ++this.lifeCycle;
                }
                Thread.sleep(1L);
            }
            System.out.println("Thread exit (" + System.currentTimeMillis() + "): " + this.returnValue + " , <<" + feedBack.toString() + ">>");
            feedBack = null;
        }
    }

    protected class WaitingConfigLocal
    extends WaitThread {
        String fConfigString;

        public WaitingConfigLocal(CancelDialog dlg, String configString) {
            super(dlg);
            this.fConfigString = configString;
        }

        protected void runLongTimeJob() throws Exception {
            Modem.this.fDataTransfer.writeToOutputStream(13);
            Thread.sleep(1000L);
            this.returnValue = Modem.this.writeModem(this.fConfigString, true, new String[]{"OK"}, new String[]{"ERROR"}, true, 5000, false) ? 0 : 2;
        }
    }

    protected class WaitingCheckPassword
    extends WaitThread {
        String fPassword;

        public WaitingCheckPassword(CancelDialog dlg, String password) {
            super(dlg);
            this.fPassword = password;
        }

        protected void runLongTimeJob() throws Exception {
            this.returnValue = Modem.this.writeModem(Modem.this.remotePassword, true, new String[]{"CONNECT"}, new String[]{"NO CARRIRE"}, false, 15000, true) ? 0 : 2;
        }
    }

    protected class WaitingConfigRemote
    extends WaitThread {
        public WaitingConfigRemote(CancelDialog dlg) {
            super(dlg);
        }

        protected void runLongTimeJob() throws Exception {
            this.returnValue = 0;
            Modem.this.fDataTransfer.reset();
            Thread.sleep(1200L);
            int ret = Modem.this.writeModem("****", false, new String[]{"REMOTE PASSWORD", "OK"}, false, 15000, false);
            if (ret == 0) {
                Thread.sleep(1000L);
                if (!Modem.this.writeModem(Modem.this.remotePassword, true, new String[]{"CONNECT", "OK"}, new String[]{"NO CARRIRE"}, false, 15000, true)) {
                    this.returnValue = 2;
                }
                if (!Modem.this.writeModem(Modem.REMOTE_PORT_SETTING_COMMAND, true, new String[]{"OK"}, new String[]{"ERROR"}, false, 15000, true)) {
                    this.returnValue = 2;
                }
                if (!Modem.this.writeModem("AT *E", true, new String[]{"OK"}, new String[]{"ERROR"}, false, 15000, true)) {
                    this.returnValue = 2;
                }
            } else if (ret != 1) {
                this.returnValue = 2;
            }
        }
    }

    protected static abstract class WaitThread
    extends Thread {
        volatile boolean fExitFlag = false;
        protected int returnValue = -1;
        protected CancelDialog fCancelDialog;

        public WaitThread(CancelDialog dlg) {
            this.fCancelDialog = dlg;
        }

        public void sendExitFlag() {
            this.fExitFlag = true;
            this.returnValue = 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.runLongTimeJob();
            }
            catch (Exception e) {
                System.out.println("WaitThread error.");
                this.returnValue = 2;
            }
            finally {
                if (this.fCancelDialog != null) {
                    try {
                        if (this.fCancelDialog.getValue() == -1) {
                            this.fCancelDialog.exit(this.returnValue);
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }

        protected abstract void runLongTimeJob() throws Exception;
    }

    protected static class PasswordPanel {
        protected static String ret;
        protected static TextField password;
        protected static JDialog dialog;

        protected PasswordPanel() {
        }

        public static String getPassword() {
            ret = null;
            dialog = new JDialog((JFrame)Application.getInstance().getActiveApplicationSurface().getWindow(), Language.getString("modem.dlg.queryPasswordTitle", "Password"), true);
            JPanel pane = new JPanel();
            dialog.add((Component)pane, "North");
            JLabel label = new JLabel(Language.getString("modem.dlg.queryPassword", "Please input remote modem password"));
            pane.add(label);
            password = new TextField(12);
            password.setEchoChar('*');
            password.setPreferredSize(new Dimension(100, 20));
            password.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ret = password.getText();
                    dialog.setVisible(false);
                    System.out.print("<event>");
                }
            });
            pane.add(password);
            JButton okButton = new JButton("OK");
            dialog.add((Component)okButton, "South");
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ret = password.getText();
                    dialog.setVisible(false);
                }
            });
            dialog.pack();
            dialog.setLocationRelativeTo(dialog.getParent());
            dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    ret = null;
                }
            });
            dialog.setVisible(true);
            return ret;
        }
    }

    protected static class CancelDialog {
        JDialog dialog = null;
        JButton button = null;
        static final int WAITING = -1;
        static final int NO_ERROR = 0;
        static final int CANCEL = 1;
        static final int ERROR = 2;
        static final int NEED_PIN = 3;
        static final int TIMEOUT = 4;
        int returnValue = -1;
        JLabel fLabel = null;

        public CancelDialog(String title) {
            this.dialog = new JDialog((JFrame)Application.getInstance().getActiveApplicationSurface().getWindow(), title, true);
            JPanel pane = new JPanel(new GridBagLayout());
            this.fLabel = new JLabel();
            GridBagConstraints g = new GridBagConstraints();
            g.gridx = 0;
            g.gridy = 0;
            g.weightx = 1.0;
            g.fill = 0;
            g.anchor = 10;
            pane.add((Component)this.fLabel, g);
            pane.setPreferredSize(new Dimension(300, 100));
            this.dialog.add((Component)pane, "Center");
            this.button = new JButton(Language.getString("dialog.error.cancel", "Cancel"));
            this.dialog.add((Component)this.button, "South");
            this.dialog.pack();
            this.dialog.setPreferredSize(new Dimension(200, 100));
            this.button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.out.println("cancel clicked");
                    CancelDialog.this.exit(1);
                }
            });
        }

        public void show() {
            this.dialog.setLocationRelativeTo(this.dialog.getParent());
            this.dialog.setVisible(true);
        }

        public void exit(int retValue) {
            this.returnValue = retValue;
            this.dialog.dispose();
        }

        public int getValue() {
            return this.returnValue;
        }

        public void setLabel(String str) {
            this.fLabel.setText(str);
        }
    }
}

