/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.dialog;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.FileTreeCellRenderer;
import DE.siemens.ad.logo.app.dialog.FileNameComparator;
import DE.siemens.ad.logo.util.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DirectoryChooserPanel
extends DataInputPanel {
    protected JTree directoryTree;
    protected DefaultTreeModel fTreeModel;
    protected FileSystemView fFileSystemView;

    public DirectoryChooserPanel() {
        this.setLayout(new BorderLayout());
        this.initTree();
        this.add(new JScrollPane(this.directoryTree));
        this.directoryTree.setCursor(Cursor.getDefaultCursor());
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 500);
    }

    public File getSelectedFile() {
        TreePath tp = this.directoryTree.getSelectionPath();
        if (tp == null) {
            return null;
        }
        FileNode fn = (FileNode)tp.getLastPathComponent();
        if (fn == null) {
            return null;
        }
        return (File)fn.getUserObject();
    }

    public String getTitle() {
        return Language.getString("wizard.update.selectUpdateDirectoryPanel.title", "Select directory");
    }

    protected void initTree() {
        this.directoryTree = new JTree();
        FileNode root = new FileNode("", true);
        this.fFileSystemView = FileSystemView.getFileSystemView();
        File[] roots = this.fFileSystemView.getRoots();
        for (int i = 0; i < roots.length; ++i) {
            root.add(new FileNode(roots[i], true));
        }
        this.fTreeModel = new DefaultTreeModel(root);
        this.directoryTree.setModel(this.fTreeModel);
        this.directoryTree.setCellRenderer(new FileTreeCellRenderer());
        DefaultTreeSelectionModel dtsm = new DefaultTreeSelectionModel();
        dtsm.setSelectionMode(1);
        this.directoryTree.setSelectionModel(dtsm);
        this.directoryTree.setCellRenderer(new FileNodeTreeCellRenderer());
        this.directoryTree.setRootVisible(false);
        this.directoryTree.expandRow(0);
    }

    public void setLabels() {
    }

    public void setSelectedFile(File path) {
        StringTokenizer st = new StringTokenizer(path.getPath(), "\\/");
        FileNode currentNode = (FileNode)this.fTreeModel.getRoot();
        String pathComponent = "";
        Vector<FileNode> nodes = new Vector<FileNode>();
        nodes.add(currentNode);
        block0: while (st.hasMoreTokens()) {
            pathComponent = pathComponent + st.nextToken() + "/";
            for (int i = 0; i < currentNode.getChildCount(); ++i) {
                File f = (File)((FileNode)currentNode.getChildAt(i)).getUserObject();
                if (!new File(pathComponent).equals(f)) continue;
                currentNode = (FileNode)currentNode.getChildAt(i);
                nodes.add(currentNode);
                continue block0;
            }
        }
        Object[] treeNodes = new TreeNode[nodes.size()];
        nodes.copyInto(treeNodes);
        TreePath expandedPath = new TreePath(treeNodes);
        this.directoryTree.expandPath(expandedPath);
        this.directoryTree.setSelectionPath(expandedPath);
        this.directoryTree.scrollPathToVisible(expandedPath);
    }

    public class FileNode
    extends DefaultMutableTreeNode {
        public boolean valid;
        protected boolean onlyDirectories;

        public FileNode() {
            this.valid = false;
            this.onlyDirectories = false;
        }

        public FileNode(Object userObject) {
            super(userObject);
            this.valid = false;
            this.onlyDirectories = false;
        }

        public FileNode(Object userObject, boolean onlyDirectories) {
            super(userObject);
            this.valid = false;
            this.onlyDirectories = false;
            this.onlyDirectories = onlyDirectories;
        }

        public Enumeration children() {
            if (!this.valid) {
                this.getChildren();
            }
            if (this.children == null) {
                return EMPTY_ENUMERATION;
            }
            return this.children.elements();
        }

        public TreeNode getChildAfter(TreeNode aChild) {
            if (!this.valid) {
                this.getChildren();
            }
            if (aChild == null) {
                throw new IllegalArgumentException("argument is null");
            }
            int index = this.getIndex(aChild);
            if (index == -1) {
                throw new IllegalArgumentException("node is not a child");
            }
            if (index < this.getChildCount() - 1) {
                return this.getChildAt(index + 1);
            }
            return null;
        }

        public TreeNode getChildAt(int index) {
            if (!this.valid) {
                this.getChildren();
            }
            if (this.children == null) {
                throw new ArrayIndexOutOfBoundsException("node has no children");
            }
            return (TreeNode)this.children.elementAt(index);
        }

        public TreeNode getChildBefore(TreeNode aChild) {
            if (!this.valid) {
                this.getChildren();
            }
            if (aChild == null) {
                throw new IllegalArgumentException("argument is null");
            }
            int index = this.getIndex(aChild);
            if (index == -1) {
                throw new IllegalArgumentException("argument is not a child");
            }
            if (index > 0) {
                return this.getChildAt(index - 1);
            }
            return null;
        }

        public int getChildCount() {
            if (!this.valid) {
                this.getChildren();
            }
            if (this.children == null) {
                return 0;
            }
            return this.children.size();
        }

        protected void getChildren() {
            if (this.valid) {
                return;
            }
            FileNode thisNode = this;
            DirectoryChooserPanel.this.directoryTree.setCursor(Cursor.getPredefinedCursor(3));
            this.valid = true;
            if (this.getUserObject() instanceof String) {
                return;
            }
            File[] files = ((File)this.getUserObject()).listFiles();
            if (files != null) {
                Arrays.sort(files, new FileNameComparator());
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].isDirectory() && this.onlyDirectories) continue;
                    this.add(new FileNode(files[i], this.onlyDirectories));
                }
            }
            DirectoryChooserPanel.this.directoryTree.setCursor(Cursor.getDefaultCursor());
        }

        public TreeNode getFirstChild() {
            if (!this.valid) {
                this.getChildren();
            }
            if (this.getChildCount() == 0) {
                throw new NoSuchElementException("node has no children");
            }
            return this.getChildAt(0);
        }

        public int getIndex(TreeNode aChild) {
            if (!this.valid) {
                this.getChildren();
            }
            if (aChild == null) {
                throw new IllegalArgumentException("argument is null");
            }
            if (!this.isNodeChild(aChild)) {
                return -1;
            }
            return this.children.indexOf(aChild);
        }

        public TreeNode getLastChild() {
            if (!this.valid) {
                this.getChildren();
            }
            if (this.getChildCount() == 0) {
                throw new NoSuchElementException("node has no children");
            }
            return this.getChildAt(this.getChildCount() - 1);
        }

        public boolean isLeaf() {
            if (!this.valid) {
                return false;
            }
            return this.getChildCount() == 0;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean newValid) {
            this.removeAllChildren();
            this.valid = newValid;
            this.getChildren();
        }

        public String toString() {
            if (this.userObject == null) {
                return null;
            }
            if (this.userObject instanceof File) {
                File f = (File)this.userObject;
                if (f.isDirectory()) {
                    if (f.getName().equals("")) {
                        return f.toString();
                    }
                    return f.getName();
                }
                return f.toString();
            }
            return this.userObject.toString();
        }
    }

    private class FileNodeTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private FileNodeTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof FileNode && ((FileNode)value).getUserObject() instanceof File) {
                File file = (File)((FileNode)value).getUserObject();
                this.setText(DirectoryChooserPanel.this.fFileSystemView.getSystemDisplayName(file));
                this.setIcon(DirectoryChooserPanel.this.fFileSystemView.getSystemIcon(file));
            }
            return this;
        }
    }
}

