/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class PopupWindow
extends JWindow {
    private AWTEventHandler fAwtEventHandler;
    private ComponentHandler fComponentHandler;
    private Container fParent;
    private List fPopupWindowListeners;

    public PopupWindow(Window parent) {
        super(parent);
        this.fParent = parent;
        JPanel newContentPane = new JPanel(new BorderLayout());
        newContentPane.setBorder(BorderFactory.createBevelBorder(0));
        this.setContentPane(newContentPane);
        this.fComponentHandler = new ComponentHandler();
        this.fAwtEventHandler = new AWTEventHandler();
        this.getRootPane().registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                PopupWindow.this.cancelPopupWindow();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.getRootPane().registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                PopupWindow.this.approvePopupWindow();
            }
        }, KeyStroke.getKeyStroke(10, 0), 1);
    }

    public void cancelPopupWindow() {
        this.setVisible(false);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.fAwtEventHandler);
        this.fParent.removeComponentListener(this.fComponentHandler);
        this.firePopupCanceledEvent();
    }

    public void approvePopupWindow() {
        this.setVisible(false);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.fAwtEventHandler);
        this.fParent.removeComponentListener(this.fComponentHandler);
        this.firePopupApprovedEvent();
    }

    public void addPopupWindowListener(PopupWindowListener listener) {
        if (!this.getPopupWindowListeners().contains(listener)) {
            this.getPopupWindowListeners().add(listener);
        }
    }

    public void removePopupWindowListener(PopupWindowListener listener) {
        this.getPopupWindowListeners().remove(listener);
    }

    public List getPopupWindowListeners() {
        if (this.fPopupWindowListeners == null) {
            this.fPopupWindowListeners = new ArrayList(3);
        }
        return this.fPopupWindowListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePopupCanceledEvent() {
        if (!this.getPopupWindowListeners().isEmpty()) {
            ArrayList l;
            PopupWindow popupWindow = this;
            synchronized (popupWindow) {
                l = new ArrayList(this.getPopupWindowListeners());
            }
            PopupWindowEvent popupWindowEvent = new PopupWindowEvent(this);
            for (int i = 0; i < l.size(); ++i) {
                PopupWindowListener popupWindowListener = (PopupWindowListener)l.get(i);
                popupWindowListener.popupWindowCanceled(popupWindowEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePopupApprovedEvent() {
        if (!this.getPopupWindowListeners().isEmpty()) {
            ArrayList l;
            PopupWindow popupWindow = this;
            synchronized (popupWindow) {
                l = new ArrayList(this.getPopupWindowListeners());
            }
            PopupWindowEvent popupWindowEvent = new PopupWindowEvent(this);
            for (int i = 0; i < l.size(); ++i) {
                PopupWindowListener popupWindowListener = (PopupWindowListener)l.get(i);
                popupWindowListener.popupWindowApproved(popupWindowEvent);
            }
        }
    }

    public void show(Rectangle bounds) {
        Dimension popupSize = bounds.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Point popupLocation = bounds.getLocation();
        int openDirection = 4;
        int dx = 0;
        int dy = 0;
        if (openDirection == 4) {
            if (popupLocation.x + popupSize.width > screenSize.width) {
                dx -= popupSize.width;
            }
        } else {
            dx = -popupSize.width;
            if (popupLocation.x - popupSize.width < 0) {
                dx += popupSize.width;
            }
        }
        if (popupLocation.y + popupSize.height > screenSize.height) {
            dy = screenSize.height - (popupLocation.y + popupSize.height) - 50;
        }
        if (popupLocation.x + dx < 0) {
            dx -= popupLocation.x + dx;
        }
        if (popupLocation.y + dy < 0) {
            dy -= popupLocation.y + dy;
        }
        this.fParent.addComponentListener(this.fComponentHandler);
        Toolkit.getDefaultToolkit().addAWTEventListener(this.fAwtEventHandler, 16L);
        this.setLocation(popupLocation.x + dx, popupLocation.y + dy);
        this.setSize(popupSize);
        this.setVisible(true);
    }

    public void show(Component invoker, Rectangle popupBounds) {
        Point locationOnScreen = popupBounds.getLocation();
        SwingUtilities.convertPointToScreen(locationOnScreen, invoker);
        popupBounds.setLocation(locationOnScreen);
        this.show(popupBounds);
    }

    public void setBorder(Border border) {
        if (this.getContentPane() instanceof JComponent) {
            ((JComponent)this.getContentPane()).setBorder(border);
        }
    }

    public static class PopupWindowEvent
    extends EventObject {
        public PopupWindowEvent(Object source) {
            super(source);
        }
    }

    public static interface PopupWindowListener
    extends EventListener {
        public void popupWindowCanceled(PopupWindowEvent var1);

        public void popupWindowApproved(PopupWindowEvent var1);
    }

    protected class AWTEventHandler
    implements AWTEventListener {
        protected AWTEventHandler() {
        }

        public void eventDispatched(AWTEvent event) {
            if (event.getID() != 501) {
                return;
            }
            if (!(event.getSource() instanceof Component)) {
                return;
            }
            Component c = (Component)event.getSource();
            Container popupWindow = SwingUtilities.getAncestorOfClass(PopupWindow.class, c);
            if (popupWindow != PopupWindow.this) {
                PopupWindow.this.cancelPopupWindow();
            }
        }
    }

    protected class ComponentHandler
    implements ComponentListener {
        protected ComponentHandler() {
        }

        public void componentHidden(ComponentEvent e) {
            PopupWindow.this.cancelPopupWindow();
        }

        public void componentMoved(ComponentEvent e) {
            PopupWindow.this.cancelPopupWindow();
        }

        public void componentResized(ComponentEvent e) {
            PopupWindow.this.cancelPopupWindow();
        }

        public void componentShown(ComponentEvent e) {
        }
    }

    protected class ResizeHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private boolean fResizeX = false;
        private boolean fResizeY = false;
        private Point fMousePressedPoint;
        private Cursor fRescuedCursor;

        protected ResizeHandler() {
        }

        public void mousePressed(MouseEvent e) {
            this.fRescuedCursor = PopupWindow.this.getCursor();
            this.fMousePressedPoint = e.getPoint();
        }

        public void mouseDragged(MouseEvent e) {
            if (!this.fResizeX && !this.fResizeY) {
                return;
            }
            Dimension size = PopupWindow.this.getSize();
            size.width += e.getX() - this.fMousePressedPoint.x;
            size.height += e.getY() - this.fMousePressedPoint.y;
            size.width = Math.max(PopupWindow.this.getPreferredSize().width, size.width);
            size.height = Math.max(PopupWindow.this.getPreferredSize().height, size.height);
            PopupWindow.this.setSize(size);
            PopupWindow.this.validate();
            PopupWindow.this.repaint();
            this.fMousePressedPoint = e.getPoint();
        }

        public void mouseMoved(MouseEvent e) {
            this.fResizeX = e.getX() > PopupWindow.this.getRootPane().getWidth() - 5;
            this.fResizeY = e.getY() > PopupWindow.this.getRootPane().getHeight() - 5;
            System.out.println("resizeX: " + this.fResizeX);
            System.out.println("resizeY: " + this.fResizeY);
            if (this.fRescuedCursor == null) {
                this.fRescuedCursor = PopupWindow.this.getContentPane().getCursor();
                if (this.fResizeX || this.fResizeY) {
                    if (this.fResizeX && !this.fResizeY) {
                        PopupWindow.this.setCursor(Cursor.getPredefinedCursor(11));
                    }
                    if (this.fResizeY && !this.fResizeX) {
                        PopupWindow.this.setCursor(Cursor.getPredefinedCursor(9));
                    }
                    if (this.fResizeX && this.fResizeY) {
                        PopupWindow.this.setCursor(Cursor.getPredefinedCursor(5));
                    }
                }
            }
        }

        public void mouseExited(MouseEvent e) {
            if (this.fRescuedCursor != null) {
                PopupWindow.this.setCursor(this.fRescuedCursor);
                this.fRescuedCursor = null;
            }
        }
    }

    protected class MoveHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private boolean fMove;
        private Point fMousePressedPoint;
        private Cursor fRescuedCursor;
        private boolean fResize;

        protected MoveHandler() {
        }

        public void mousePressed(MouseEvent e) {
            this.fMove = e.getX() < 5 || e.getY() < 5;
            boolean bl = this.fResize = e.getX() > PopupWindow.this.getRootPane().getWidth() - 5 || e.getY() > PopupWindow.this.getRootPane().getHeight() - 5;
            if (this.fMove && !this.fResize) {
                this.fRescuedCursor = PopupWindow.this.getCursor();
                PopupWindow.this.setCursor(Cursor.getPredefinedCursor(13));
                this.fMousePressedPoint = e.getPoint();
            }
        }

        public void mouseReleased(MouseEvent e) {
            PopupWindow.this.setCursor(this.fRescuedCursor);
        }

        public void mouseExited(MouseEvent e) {
            PopupWindow.this.setCursor(this.fRescuedCursor);
        }

        public void mouseDragged(MouseEvent e) {
            if (this.fResize) {
                return;
            }
            Rectangle bounds = PopupWindow.this.getBounds();
            bounds.translate(e.getX() - this.fMousePressedPoint.x, e.getY() - this.fMousePressedPoint.y);
            PopupWindow.this.setBounds(bounds);
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

