/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalToolTipUI;

public class LogoTooltipUI
extends MetalToolTipUI {
    static LogoTooltipUI sharedInstance = new LogoTooltipUI();
    private Font smallFont;
    private JToolTip tip;
    public static final int padSpaceBetweenStrings = 12;
    private String acceleratorDelimiter;

    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.tip = (JToolTip)c;
        Font f = c.getFont();
        this.smallFont = new Font(f.getName(), f.getStyle(), f.getSize() - 2);
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "-";
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.tip = null;
    }

    public void paint(Graphics g, JComponent c) {
        JToolTip tip = (JToolTip)c;
        super.paint(g, c);
        Font font = c.getFont();
        FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        String keyText = this.getAcceleratorString(tip);
        String tipText = tip.getTipText();
        if (tipText == null) {
            tipText = "";
        }
        if (!keyText.equals("")) {
            g.setFont(this.smallFont);
            g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            g.drawString(keyText, metrics.stringWidth(tipText) + 12, 2 + metrics.getAscent());
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        String key = this.getAcceleratorString((JToolTip)c);
        if (!key.equals("")) {
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(this.smallFont);
            d.width += fm.stringWidth(key) + 12;
        }
        return d;
    }

    protected boolean isAcceleratorHidden() {
        Boolean b = (Boolean)UIManager.get("ToolTip.hideAccelerator");
        return b != null && b != false;
    }

    private String getAcceleratorString(JToolTip tip) {
        this.tip = tip;
        String retValue = this.getAcceleratorString();
        this.tip = null;
        return retValue;
    }

    public String getAcceleratorString() {
        int mnemonic;
        if (this.tip == null || this.isAcceleratorHidden()) {
            return "";
        }
        JComponent comp = this.tip.getComponent();
        if (comp == null) {
            return "";
        }
        KeyStroke[] keys = comp.getRegisteredKeyStrokes();
        String controlKeyStr = "";
        for (int i = 0; i < keys.length; ++i) {
            int mod = keys[i].getModifiers();
            if (comp.getInputMap(2).get(keys[i]) == null) continue;
            String keyModifierText = KeyEvent.getKeyModifiersText(mod);
            if (keyModifierText != null && keyModifierText.length() > 0) {
                controlKeyStr = keyModifierText + this.acceleratorDelimiter;
            }
            controlKeyStr = controlKeyStr + KeyEvent.getKeyText(keys[i].getKeyCode());
            break;
        }
        if (controlKeyStr.equals("") && comp instanceof JMenuItem && (mnemonic = ((JMenuItem)comp).getMnemonic()) != 0) {
            controlKeyStr = KeyEvent.getKeyModifiersText(8) + this.acceleratorDelimiter + (char)mnemonic;
        }
        return controlKeyStr;
    }
}

