/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import DE.siemens.ad.logo.app.comp.LengthRestrictedJTextField;
import DE.siemens.ad.logo.util.LogoError;
import java.awt.Component;

public class IntegerJTextField
extends LengthRestrictedJTextField {
    protected LogoError errorMessage = null;
    protected int fMaximum;
    protected int fMinimum;

    public IntegerJTextField() {
        this.setValue(0);
        this.setMin(0);
        this.setMax(100);
        this.errorMessage = null;
        this.setHorizontalAlignment(4);
    }

    public boolean checkChanged() {
        return Integer.parseInt(this.getInitialValue()) != this.getValue();
    }

    public boolean checkValue() {
        boolean rw = true;
        int value = this.getValue();
        if (value > this.fMaximum || value < this.fMinimum) {
            rw = false;
        }
        if (!rw && this.errorMessage != null) {
            this.errorMessage.display();
        }
        return rw;
    }

    public boolean checkValue(boolean notify) {
        boolean result = true;
        int value = this.getValue();
        if (value > this.fMaximum || value < this.fMinimum) {
            result = false;
        }
        if (notify && !result) {
            this.getError().display();
            this.requestFocus();
        }
        return result;
    }

    public LogoError createDefaultError() {
        return this.createError("error.dialog.invalidValue", "Please enter an Integer between " + this.getMin() + " and " + this.getMax() + " .");
    }

    public LogoError createError(String ErrorKey, String DefaultErrorText) {
        Object[] parameters = new Object[]{new Integer(this.getMin()), new Integer(this.getMax())};
        return new LogoError((Component)this, ErrorKey, DefaultErrorText, parameters, 2, 0);
    }

    protected int getCorrectValue(int value) {
        if (value < this.getMin()) {
            value = this.getMin();
        }
        if (value > this.getMax()) {
            value = this.getMax();
        }
        return value;
    }

    public String getDefaultInitialValue() {
        return "0";
    }

    public LogoError getError() {
        if (this.errorMessage == null) {
            this.errorMessage = this.createDefaultError();
        }
        return this.errorMessage;
    }

    public int getMax() {
        return this.fMaximum;
    }

    public int getMin() {
        return this.fMinimum;
    }

    public int getValue() {
        Integer i;
        String text = this.getText();
        try {
            i = Integer.valueOf(text);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
        return i;
    }

    public boolean isValidString(String str) {
        char[] cstr = str.toCharArray();
        int signCount = 0;
        for (int i = 0; i < cstr.length; ++i) {
            if (!Character.isDigit(cstr[i]) && cstr[i] != '-') {
                return false;
            }
            if (cstr[i] != '-') continue;
            ++signCount;
        }
        if (signCount >= 1 && this.getMin() < 0) {
            return true;
        }
        if (signCount > 0 && this.getMin() >= 0) {
            return false;
        }
        return super.isValidString(str);
    }

    public void setError(LogoError errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setInitialValue(int newValue) {
        super.setInitialValue(Integer.toString(this.getCorrectValue(newValue)));
    }

    public void setMax(int value) {
        this.fMaximum = value;
        if (this.getValue() > this.fMaximum) {
            this.setValue(this.fMaximum);
        }
        if (Integer.toString(value).length() > Integer.toString(this.getMin()).length()) {
            this.setMaxLength(Integer.toString(value).length());
        }
    }

    public void setMin(int value) {
        this.fMinimum = value;
        if (this.getValue() < this.fMinimum) {
            this.setValue(this.fMinimum);
        }
        if (Integer.toString(value).length() > Integer.toString(this.getMax()).length()) {
            this.setMaxLength(Integer.toString(value).length());
        }
    }

    public void setMinMax(int minValue, int maxValue) {
        this.fMinimum = minValue;
        this.fMaximum = maxValue;
        int value = this.getValue();
        if (value < minValue) {
            this.setValue(minValue);
        }
        if (value > maxValue) {
            this.setValue(maxValue);
        }
        int maxLength = Math.max(Integer.toString(maxValue).length(), Integer.toString(minValue).length());
        this.setMaxLength(maxLength);
    }

    public void setValue(int value) {
        value = this.getCorrectValue(value);
        super.setText(Integer.toString(value));
    }
}

