/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import DE.siemens.ad.logo.dialog.comp.ButtonReleasedListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.Timer;

class FocuslessDirectionButton
extends JButton {
    protected Timer fTimer;
    protected int fFirstDelay;
    protected int fPeriodicDelay;
    protected Vector fButtonReleasedListeners = new Vector();

    public FocuslessDirectionButton() {
        this.setFocusPainted(false);
        SymMouse aSymMouse = new SymMouse();
        this.addMouseListener(aSymMouse);
        SymMouseMotion aSymMouseMotion = new SymMouseMotion();
        this.addMouseMotionListener(aSymMouseMotion);
        this.fFirstDelay = 400;
        this.fPeriodicDelay = 50;
        TimerListenerClass timerListener = new TimerListenerClass();
        this.fTimer = new Timer(this.fPeriodicDelay, timerListener);
        this.fTimer.setDelay(this.fPeriodicDelay);
        this.fTimer.setRepeats(true);
    }

    public void addButtonReleasedListener(ButtonReleasedListener l) {
        this.fButtonReleasedListeners.addElement(l);
    }

    protected ActionListener createActionListener() {
        return new ForwardActionEvents();
    }

    public void fireActionEvent() {
        if (this.isEnabled()) {
            this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireButtonReleasedEvent() {
        if (!this.fButtonReleasedListeners.isEmpty() && this.isEnabled()) {
            Vector l;
            FocuslessDirectionButton focuslessDirectionButton = this;
            synchronized (focuslessDirectionButton) {
                l = (Vector)this.fButtonReleasedListeners.clone();
            }
            for (int i = 0; i < l.size(); ++i) {
                ButtonReleasedListener pul = (ButtonReleasedListener)l.elementAt(i);
                pul.buttonReleased();
            }
        }
    }

    void FocuslessDirectionButton_mouseDragged(MouseEvent event) {
        if (this.contains(event.getPoint())) {
            this.fTimer.start();
        } else {
            this.fTimer.stop();
            this.fireButtonReleasedEvent();
        }
    }

    void FocuslessDirectionButton_mousePressed(MouseEvent event) {
        if (this.isEnabled()) {
            this.fireActionEvent();
            this.fTimer.setInitialDelay(this.fFirstDelay);
            this.fTimer.setDelay(this.fPeriodicDelay);
            this.fTimer.start();
        }
    }

    void FocuslessDirectionButton_mouseReleased(MouseEvent event) {
        this.fTimer.stop();
        this.fireButtonReleasedEvent();
    }

    public int getFirstDelay() {
        return this.fFirstDelay;
    }

    public int getPeriodicDelay() {
        return this.fPeriodicDelay;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void removeButtonReleasedListener(ButtonReleasedListener l) {
        this.fButtonReleasedListeners.removeElement(l);
    }

    public void setFirstDelay(int delay) {
        this.fFirstDelay = delay;
    }

    public void setPeriodicDelay(int delay) {
        this.fPeriodicDelay = delay;
    }

    class TimerListenerClass
    implements ActionListener {
        TimerListenerClass() {
        }

        public void actionPerformed(ActionEvent event) {
            FocuslessDirectionButton.this.fireActionEvent();
        }
    }

    class SymMouseMotion
    extends MouseMotionAdapter {
        SymMouseMotion() {
        }

        public void mouseDragged(MouseEvent event) {
            Object object = event.getSource();
            if (object == FocuslessDirectionButton.this) {
                FocuslessDirectionButton.this.FocuslessDirectionButton_mouseDragged(event);
            }
        }
    }

    private class ForwardActionEvents
    implements ActionListener,
    Serializable {
        private ForwardActionEvents() {
        }

        public void actionPerformed(ActionEvent event) {
        }
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        public void mouseReleased(MouseEvent event) {
            FocuslessDirectionButton.this.FocuslessDirectionButton_mouseReleased(event);
        }

        public void mousePressed(MouseEvent event) {
            FocuslessDirectionButton.this.FocuslessDirectionButton_mousePressed(event);
        }
    }
}

