/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import DE.siemens.ad.logo.app.comp.FindFilter;
import DE.siemens.ad.logo.app.comp.FindFilterFactory;
import DE.siemens.ad.logo.app.comp.FindProgressCallback;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class FindByName
extends JPanel
implements FindFilterFactory {
    protected String NAME_CONTAINS = "contains";
    protected String NAME_IS = "is";
    protected String NAME_STARTS_WITH = "starts with";
    protected String NAME_ENDS_WITH = "ends with";
    protected int NAME_CONTAINS_INDEX = 0;
    protected int NAME_IS_INDEX = 1;
    protected int NAME_STARTS_WITH_INDEX = 2;
    protected int NAME_ENDS_WITH_INDEX = 3;
    protected String[] criteria = new String[]{this.NAME_CONTAINS, this.NAME_IS, this.NAME_STARTS_WITH, this.NAME_ENDS_WITH};
    protected JTextField nameField = null;
    protected JComboBox combo = null;
    protected JCheckBox ignoreCaseCheck = null;

    FindByName() {
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(0, 2, 2, 2));
        this.combo = new JComboBox<String>(this.criteria);
        this.combo.setFont(new Font("Helvetica", 0, 10));
        this.combo.setPreferredSize(this.combo.getPreferredSize());
        p.add(this.combo);
        this.nameField = new JTextField(12);
        this.nameField.setFont(new Font("Helvetica", 0, 10));
        p.add(this.nameField);
        p.add(new JLabel("", 4));
        this.ignoreCaseCheck = new JCheckBox("ignore case", true);
        this.ignoreCaseCheck.setForeground(Color.black);
        this.ignoreCaseCheck.setFont(new Font("Helvetica", 0, 10));
        p.add(this.ignoreCaseCheck);
        this.add((Component)p, "North");
    }

    public FindFilter createFindFilter() {
        return new NameFilter(this.nameField.getText(), this.combo.getSelectedIndex(), this.ignoreCaseCheck.isSelected());
    }

    class NameFilter
    implements FindFilter {
        protected String match = null;
        protected int howToMatch = -1;
        protected boolean ignoreCase = true;

        NameFilter(String name, int how, boolean ignore) {
            this.match = name;
            this.howToMatch = how;
            this.ignoreCase = ignore;
        }

        public boolean accept(File f, FindProgressCallback callback) {
            if (f == null) {
                return false;
            }
            if (this.match == null || this.match.length() == 0) {
                return true;
            }
            if (this.howToMatch < 0) {
                return true;
            }
            String filename = f.getName();
            if (this.howToMatch == FindByName.this.NAME_CONTAINS_INDEX) {
                if (this.ignoreCase) {
                    return filename.toLowerCase().indexOf(this.match.toLowerCase()) >= 0;
                }
                return filename.indexOf(this.match) >= 0;
            }
            if (this.howToMatch == FindByName.this.NAME_IS_INDEX) {
                if (this.ignoreCase) {
                    return filename.equalsIgnoreCase(this.match);
                }
                return filename.equals(this.match);
            }
            if (this.howToMatch == FindByName.this.NAME_STARTS_WITH_INDEX) {
                if (this.ignoreCase) {
                    return filename.toLowerCase().startsWith(this.match.toLowerCase());
                }
                return filename.startsWith(this.match);
            }
            if (this.howToMatch == FindByName.this.NAME_ENDS_WITH_INDEX) {
                if (this.ignoreCase) {
                    return filename.toLowerCase().endsWith(this.match.toLowerCase());
                }
                return filename.endsWith(this.match);
            }
            return true;
        }
    }
}

