/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import DE.siemens.ad.logo.app.action.ActionGroup;
import DE.siemens.ad.logo.app.action.ActionGroupEvent;
import DE.siemens.ad.logo.app.action.ActionGroupListener;
import DE.siemens.ad.logo.app.comp.LogoJPopupMenu;
import DE.siemens.ad.logo.app.comp.RolloverButton;
import DE.siemens.ad.logo.util.Global;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class DropdownButton
extends RolloverButton
implements PopupMenuListener,
ActionGroupListener {
    protected ActionGroup fActionGroup;
    protected JButton fActionButton;
    protected JToggleButton fMenuButton;
    protected LogoJPopupMenu fPopupMenu;
    protected boolean fBorderFrozen;
    protected boolean fBorderPainted;

    public void actionAdded(ActionGroupEvent age) {
        this.getMenuButton().setEnabled(((ActionGroup)age.getSource()).getActionCount() > 0);
    }

    public void actionRemoved(ActionGroupEvent age) {
        this.getMenuButton().setEnabled(((ActionGroup)age.getSource()).getActionCount() > 0);
    }

    public DropdownButton() {
        super.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setLayout(new BorderLayout());
        this.add(toolBar);
        toolBar.add((Component)this.getActionButton(), "Center");
        toolBar.add((Component)this.getActionGroupButton(), "East");
        this.setBorder(null);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.getActionGroupButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DropdownButton.this.menuButtonPressed();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent me) {
                if (!DropdownButton.this.fPopupMenu.isVisible()) {
                    DropdownButton.this.getActionGroupButton().setSelected(false);
                }
            }
        });
    }

    public DropdownButton(ActionGroup actionGroup) {
        this();
        this.fActionGroup = actionGroup;
        this.setPopupMenu(new LogoJPopupMenu(actionGroup));
        this.getMenuButton().setEnabled(this.fActionGroup.getActionCount() > 0);
        this.fActionGroup.addActionGroupListener(this);
    }

    public void addMouseListener(MouseListener ml) {
        this.getActionButton().addMouseListener(ml);
        this.getActionGroupButton().addMouseListener(ml);
    }

    public JButton getActionButton() {
        if (this.fActionButton == null) {
            this.fActionButton = new JButton();
            this.fActionButton.setFocusPainted(false);
            this.fActionButton.setMargin(new Insets(0, 0, 0, 0));
        }
        return this.fActionButton;
    }

    public JToggleButton getActionGroupButton() {
        if (this.fMenuButton == null) {
            this.fMenuButton = new JToggleButton(Global.getIcon("DownArrowSmall.gif"));
            this.fMenuButton.setFocusPainted(false);
            this.fMenuButton.setMargin(new Insets(0, 0, 0, 0));
        }
        return this.fMenuButton;
    }

    public Dimension getMaximumSize() {
        return this.getMinimumSize();
    }

    public JToggleButton getMenuButton() {
        if (this.fMenuButton == null) {
            this.fMenuButton = new JToggleButton(Global.getIcon("DownArrowSmall.gif"));
            this.fMenuButton.setFocusPainted(false);
            this.fMenuButton.setMargin(new Insets(0, 0, 0, 0));
        }
        return this.fMenuButton;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public boolean isBorderFrozen() {
        return this.fBorderFrozen;
    }

    public boolean isEnabled() {
        return this.getActionButton().isEnabled();
    }

    protected void menuButtonPressed() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.getActionGroupButton().isSelected()) {
            Rectangle bounds = this.getBounds();
            this.fPopupMenu.show(this, 0, bounds.height);
            this.setBorderFrozen(true);
        } else {
            this.fPopupMenu.setVisible(false);
        }
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
        this.setBorderFrozen(false);
        this.setBorderPainted(this.fBorderPainted);
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.setBorderFrozen(false);
        this.setBorderPainted(this.fBorderPainted);
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    public void removeMouseListener(MouseListener ml) {
        this.getActionButton().removeMouseListener(ml);
        this.getMenuButton().removeMouseListener(ml);
    }

    public void setBorderFrozen(boolean newBorderFrozen) {
        this.fBorderFrozen = newBorderFrozen;
    }

    public void setBorderPainted(boolean borderPainted) {
        this.fBorderPainted = borderPainted;
        if (this.isBorderFrozen()) {
            return;
        }
        this.getActionButton().setBorderPainted(borderPainted);
        this.getActionGroupButton().setBorderPainted(borderPainted);
    }

    public void setEnabled(boolean b) {
        this.fActionButton.setEnabled(b);
        this.fMenuButton.setEnabled(b && this.fPopupMenu.getComponentCount() > 0);
    }

    public void setPopupMenu(LogoJPopupMenu popupMenu) {
        this.fPopupMenu = popupMenu;
        popupMenu.addPopupMenuListener(this);
    }

    public LogoJPopupMenu getPopupMenu() {
        return this.fPopupMenu;
    }
}

