/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import DE.siemens.ad.logo.app.comp.FocuslessDirectionButton;
import DE.siemens.ad.logo.app.comp.IncrementableDoubleJTextField;
import DE.siemens.ad.logo.app.comp.NumericSpinnerListener;
import DE.siemens.ad.logo.dialog.comp.SpinnerChangedEvent;
import DE.siemens.ad.logo.util.DoubleValueProperties;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DoubleNumericSpinner
extends JPanel {
    protected IncrementableDoubleJTextField numberField;
    protected FocuslessDirectionButton upButton;
    protected FocuslessDirectionButton downButton;
    protected Vector numericSpinnerListeners = new Vector();
    protected DoubleValueProperties fDoubleValueProperties;
    protected JSlider slider;
    protected JButton sliderButton;
    protected boolean sliderActivated = false;

    public DoubleNumericSpinner() {
        this.setLayout(new GridBagLayout());
        this.numberField = new IncrementableDoubleJTextField();
        this.numberField.setMax(9.9);
        this.numberField.setMin(-9.9);
        this.numberField.setIncrement(0.01);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 2;
        gbc.fill = 1;
        this.add((Component)this.numberField, gbc);
        this.upButton = new FocuslessDirectionButton();
        this.upButton.setIcon(Global.getIcon("UpArrow.gif"));
        this.upButton.setFocusPainted(false);
        this.upButton.setMargin(new Insets(0, 0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.upButton, gbc);
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DoubleNumericSpinner.this.upButtonPressed();
            }
        });
        this.downButton = new FocuslessDirectionButton();
        this.downButton.setIcon(Global.getIcon("DownArrow.gif"));
        this.downButton.setFocusPainted(false);
        this.downButton.setMargin(new Insets(0, 0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.downButton, gbc);
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DoubleNumericSpinner.this.downButtonPressed();
            }
        });
        this.numberField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent event) {
                DoubleNumericSpinner.this.fireSpinnerChangedEvent();
            }

            public void insertUpdate(DocumentEvent event) {
                DoubleNumericSpinner.this.fireSpinnerChangedEvent();
            }

            public void removeUpdate(DocumentEvent event) {
                DoubleNumericSpinner.this.fireSpinnerChangedEvent();
            }
        });
        this.sliderButton = new JButton();
        this.sliderButton.setMargin(new Insets(0, 0, 0, 0));
        this.sliderButton.setFocusPainted(false);
        this.sliderButton.setText("I");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 2;
        this.add((Component)this.sliderButton, gbc);
        this.sliderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DoubleNumericSpinner.this.sliderButtonPressed();
            }
        });
        this.slider = new JSlider();
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DoubleNumericSpinner.this.sliderChanged(e);
            }
        });
        this.setSliderActive(true);
    }

    public void setSliderActive(boolean newSliderActivated) {
        this.sliderActivated = newSliderActivated;
        this.sliderButton.setVisible(this.sliderActivated);
    }

    protected void sliderButtonPressed() {
        JPopupMenu popup = new JPopupMenu();
        double value = this.getValue();
        this.slider.setMinimum((int)this.numberField.getMin());
        this.slider.setMaximum((int)this.numberField.getMax());
        this.slider.setValue((int)value);
        this.slider.setPaintTrack(true);
        popup.setLayout(new BorderLayout());
        popup.add((Component)this.slider, "Center");
        popup.add((Component)new JLabel(String.valueOf(this.numberField.getMin())), "West");
        popup.add((Component)new JLabel(String.valueOf(this.numberField.getMax())), "East");
        Rectangle bounds = this.getBounds();
        popup.show(this, 0, bounds.height);
    }

    protected void sliderChanged() {
        this.numberField.setValue(this.slider.getValue());
    }

    protected void sliderChanged(ChangeEvent e) {
        this.numberField.setValue(this.slider.getValue());
    }

    protected void upButton_actionPerformed(ActionEvent event) {
        this.numberField.Inc();
    }

    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.numberField.setToolTipText(text);
    }

    public DoubleNumericSpinner(String pattern) {
        this();
        this.numberField.setPattern(pattern);
    }

    public synchronized void addNumericSpinnerListener(NumericSpinnerListener l) {
        this.numericSpinnerListeners.addElement(l);
    }

    public boolean checkChanged() {
        return this.numberField.checkChanged();
    }

    public boolean checkValue(boolean notify) {
        return this.numberField.checkValue(notify);
    }

    public void downButtonPressed() {
        this.numberField.Dec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireSpinnerChangedEvent() {
        Vector l;
        SpinnerChangedEvent sce = new SpinnerChangedEvent(this);
        DoubleNumericSpinner doubleNumericSpinner = this;
        synchronized (doubleNumericSpinner) {
            l = (Vector)this.numericSpinnerListeners.clone();
        }
        for (int i = 0; i < l.size(); ++i) {
            ((NumericSpinnerListener)l.elementAt(i)).spinnerChanged(sce);
        }
    }

    public LogoError getError() {
        return this.numberField.getError();
    }

    public int getFirstDelay() {
        return this.upButton.getFirstDelay();
    }

    public String getPattern() {
        return this.numberField.getPattern();
    }

    public int getPeriodicDelay() {
        return this.upButton.getPeriodicDelay();
    }

    public DoubleValueProperties getProperties() {
        this.fDoubleValueProperties.setCurrentValue(this.getValue());
        return this.fDoubleValueProperties;
    }

    public double getValue() {
        return this.numberField.getValue();
    }

    public void removeNumericSpinnerListener(NumericSpinnerListener l) {
        this.numericSpinnerListeners.removeElement(l);
    }

    public void requestFocus() {
        this.numberField.requestFocus();
    }

    public void setEnabled(boolean state) {
        super.setEnabled(state);
        this.numberField.setEnabled(state);
        this.upButton.setEnabled(state);
        this.downButton.setEnabled(state);
    }

    public void setError(LogoError newValue) {
        this.numberField.setError(newValue);
    }

    public void setFirstDelay(int value) {
        this.upButton.setFirstDelay(value);
        this.downButton.setFirstDelay(value);
    }

    public void setIncrement(double newIncrement) {
        this.numberField.setIncrement(newIncrement);
    }

    public void setInitialValue(double value) {
        this.numberField.setInitialValue(value);
    }

    public void setMax(double newMax) {
        this.numberField.setMax(newMax);
    }

    public void setMin(double newMin) {
        this.numberField.setMin(newMin);
    }

    public void setPattern(String newPattern) {
        this.numberField.setPattern(newPattern);
    }

    public void setPeriodicDelay(int value) {
        this.upButton.setPeriodicDelay(value);
        this.downButton.setPeriodicDelay(value);
    }

    public void setProperties(DoubleValueProperties ivp) {
        double max;
        double min = ivp.getMin();
        if (min > (max = ivp.getMax())) {
            double temp = min;
            min = max;
            max = temp;
        }
        this.setMin(min);
        this.setMax(max);
        this.setIncrement(ivp.getInc());
        this.setPattern(ivp.getPattern());
        this.setInitialValue(ivp.getCurrentValue());
        this.setError(this.numberField.createError(ivp.getErrorKey(), ivp.getDefaultErrorText()));
        this.fDoubleValueProperties = ivp;
        this.setToolTipText(Language.getString("comp.spinner.tooltip", "Please enter a value between " + min + " and " + max + ".", new Object[]{new Double(min), new Double(max)}));
    }

    public void setPropertiesWithoutCurrent(DoubleValueProperties ivp) {
        this.setMin(ivp.getMin());
        this.setMax(ivp.getMax());
        this.setIncrement(ivp.getInc());
        this.setPattern(ivp.getPattern());
        this.setError(this.numberField.createError(ivp.getErrorKey(), ivp.getDefaultErrorText()));
    }

    public void setValue(double newValue) {
        this.numberField.setValue(newValue);
    }

    public void upButtonPressed() {
        this.numberField.Inc();
    }
}

