/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.action;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.EditorInfo;
import DE.siemens.ad.logo.app.FileType;
import DE.siemens.ad.logo.app.FileTypeGroup;
import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.app.comp.LogoFileChooser;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoFileView;
import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JFileChooser;

public class OpenAction
extends LogoAction {
    protected File[] fFiles;

    public OpenAction() {
        this.putValue("Name", "\u00d6ffnen");
        this.putValue("textKey", "file.open");
        this.putValue("SmallIcon", Global.getIcon("Open.gif"));
    }

    public boolean doIt() {
        for (int i = 0; i < this.fFiles.length; ++i) {
            ((Application)this.getOwner()).loadDocument(this.fFiles[i]);
        }
        return true;
    }

    public boolean needsWaitCursor() {
        return true;
    }

    public boolean prepareAction() {
        Application application = (Application)this.getOwner();
        LogoFileChooser fileChooser = application.getFileChooser();
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.resetChoosableFileFilters();
        FileTypeGroup lscTypeGroup = FileTypeGroup.getFileTypeGroup("comfortFileType", Language.getString("dialog.fileChooser.logoSoftFiles", "LOGO!Soft files"));
        boolean fileTypeGroupEmpty = lscTypeGroup.isEmpty();
        EditorInfo defaultEditorInfo = (EditorInfo)application.getEditorInfos().elementAt(0);
        LogoFileView logoFileView = new LogoFileView();
        Enumeration e = application.getEditorInfos().elements();
        EditorInfo editorInfo = null;
        while (e.hasMoreElements()) {
            editorInfo = (EditorInfo)e.nextElement();
            logoFileView.addFileTypes(editorInfo.getLoadableFileTypes());
            Iterator loadableFileTypes = editorInfo.getLoadableFileTypes().iterator();
            FileType fileType = null;
            while (loadableFileTypes.hasNext()) {
                fileType = (FileType)loadableFileTypes.next();
                ((JFileChooser)fileChooser).addChoosableFileFilter(fileType);
                if (!fileTypeGroupEmpty || !fileType.isVisibleInFileChooser()) continue;
                lscTypeGroup.addFileType(fileType);
            }
        }
        if (fileTypeGroupEmpty) {
            ((JFileChooser)fileChooser).addChoosableFileFilter(lscTypeGroup);
        }
        fileChooser.setFileView(logoFileView);
        fileChooser.setFileFilter(lscTypeGroup);
        int rw = fileChooser.showOpenDialog(((Application)this.getOwner()).getActiveApplicationSurface());
        if (rw == 1) {
            return false;
        }
        this.fFiles = fileChooser.getSelectedFiles();
        return this.fFiles != null && this.fFiles.length != 0;
    }
}

