/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.action;

import DE.siemens.ad.logo.app.action.ActionGroup;
import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.app.action.OpenNamedDocumentAction;
import DE.siemens.ad.logo.util.LogoProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public class FileHistoryActionGroup
extends ActionGroup {
    public static final int HISTORY_SIZE = 8;

    public FileHistoryActionGroup() {
        this("");
    }

    public FileHistoryActionGroup(String name) {
        super(name);
        this.setNumbered(true);
    }

    public void addAction(LogoAction action) {
        if (!(action instanceof OpenNamedDocumentAction)) {
            return;
        }
        OpenNamedDocumentAction openNamedDocument = (OpenNamedDocumentAction)action;
        ArrayList actionsClone = (ArrayList)this.getActions().clone();
        for (OpenNamedDocumentAction currentAction : actionsClone) {
            if (!currentAction.getDocument().equals(openNamedDocument.getDocument())) continue;
            this.removeAction(currentAction);
        }
        if (this.getActionCount() == 8) {
            this.getActions().remove(this.getActionCount() - 1);
        }
        this.addActionAt(openNamedDocument, 0);
    }

    public void loadHistory() {
        String file;
        LogoProperties properties = LogoProperties.instance();
        for (int i = 1; i < 9 && (file = properties.getProperty("file" + i)) != null && !file.equals(""); ++i) {
            OpenNamedDocumentAction openNamedDocumentAction = new OpenNamedDocumentAction();
            openNamedDocumentAction.setOwner(this.getOwner());
            openNamedDocumentAction.setDocument(new File(file));
            this.addActionAt(openNamedDocumentAction, i - 1);
        }
    }

    public void storeHistory() {
        LogoProperties properties = LogoProperties.instance();
        int nr = 1;
        Iterator i = this.getActions().iterator();
        while (i.hasNext()) {
            properties.setProperty("file" + nr, ((OpenNamedDocumentAction)i.next()).getDocument().getPath());
            ++nr;
        }
    }
}

