/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.action;

import DE.siemens.ad.logo.app.ActionOwner;
import DE.siemens.ad.logo.app.action.ActionFactory;
import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.app.action.UndoableAction;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.WaitCursorThread;
import DE.siemens.ad.pdraw.action.RedoAction;
import DE.siemens.ad.pdraw.action.UndoAction;
import java.util.Vector;
import javax.swing.JOptionPane;

public class ActionManager {
    protected Vector undoList = new Vector();
    protected Vector redoList = new Vector();
    private static final int UNDO_BUFFER_SIZE = 30;
    protected ActionOwner fOwner;
    protected boolean logging = false;

    public ActionManager(ActionOwner owner) {
        this.fOwner = owner;
    }

    public void enableDisableUndoRedo() {
        UndoAction undoAction = (UndoAction)this.fOwner.getActionFactory().getAction("UndoAction");
        if (undoAction == null) {
            return;
        }
        undoAction.setActivated(!this.undoList.isEmpty());
        if (!this.undoList.isEmpty()) {
            UndoableAction lastUndoableAction = (UndoableAction)this.undoList.lastElement();
            String undoActionName = Language.getStringNoTilde((String)undoAction.getValue("textKey"), "default");
            undoAction.putValue("ShortDescription", undoActionName + ": " + lastUndoableAction.getValue("ShortDescription"));
        } else {
            undoAction.putValue("ShortDescription", Language.getStringNoTilde("edit.undo", "Undo"));
        }
        RedoAction redoAction = (RedoAction)this.fOwner.getActionFactory().getAction("RedoAction");
        redoAction.setActivated(!this.redoList.isEmpty());
        if (!this.redoList.isEmpty()) {
            UndoableAction lastRedoableAction = (UndoableAction)this.redoList.lastElement();
            String redoActionName = Language.getStringNoTilde((String)redoAction.getValue("textKey"), "default");
            redoAction.putValue("ShortDescription", redoActionName + ": " + lastRedoableAction.getValue("ShortDescription"));
        } else {
            redoAction.putValue("ShortDescription", Language.getStringNoTilde("edit.redo", "Redo"));
        }
    }

    public ActionFactory getActionFactory() {
        return this.fOwner.getActionFactory();
    }

    public boolean invokeAction(final LogoAction logoAction) {
        if (!logoAction.isEnabled()) {
            return false;
        }
        boolean rw = logoAction.prepareAction();
        if (!rw) {
            return false;
        }
        this.log("invoke: " + logoAction);
        boolean somethingDone = true;
        try {
            if (logoAction.needsWaitCursor()) {
                Runnable r = new Runnable(){

                    public void run() {
                        logoAction.doIt();
                    }
                };
                new WaitCursorThread(r, this.fOwner.getWindow()).run();
            } else {
                somethingDone = logoAction.doIt();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            JOptionPane.showMessageDialog(this.fOwner.getWindow(), "An unexpected error occured.\nYour data may be inconsistent and subsequent errors may occur.\n" + t.toString(), "Unexpected Error", 0);
        }
        logoAction.postAction(somethingDone);
        if (somethingDone && logoAction.destroysUndo()) {
            this.undoList.removeAllElements();
            this.redoList.removeAllElements();
            this.enableDisableUndoRedo();
        }
        if (logoAction instanceof UndoableAction && somethingDone) {
            this.undoList.addElement(((UndoableAction)logoAction).clone());
            if (this.undoList.size() > 30) {
                this.undoList.remove(this.undoList.firstElement());
            }
            this.redoList.removeAllElements();
            this.enableDisableUndoRedo();
        }
        return true;
    }

    private void log(String s) {
        if (this.logging) {
            System.out.println(s);
        }
    }

    public void redo() {
        UndoableAction ua = (UndoableAction)this.redoList.lastElement();
        this.log("redo: " + ua);
        ua.doIt();
        this.redoList.remove(ua);
        this.undoList.add(ua);
        this.enableDisableUndoRedo();
    }

    public void undo() {
        UndoableAction ua = (UndoableAction)this.undoList.lastElement();
        this.log("undo: " + ua);
        ua.undoIt();
        this.undoList.remove(ua);
        this.redoList.addElement(ua);
        this.enableDisableUndoRedo();
    }

    public void deleteRedoBuffer() {
        this.redoList.removeAllElements();
        this.enableDisableUndoRedo();
    }

    public void deleteUndoBuffer() {
        this.undoList.removeAllElements();
        this.enableDisableUndoRedo();
    }
}

