/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.action;

import DE.siemens.ad.logo.app.action.ActionGroupEvent;
import DE.siemens.ad.logo.app.action.ActionGroupListener;
import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.util.WeakListenerRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ActionGroup
extends LogoAction {
    protected boolean fFlatMenu;
    protected boolean fFlatToolbar;
    protected ArrayList fActions;
    public WeakListenerRegistry fActionGroupListeners;
    protected LogoAction fDefaultAction;
    protected boolean fNumbered;

    public ActionGroup() {
    }

    public ActionGroup(String name) {
        this();
        this.putValue("Name", name);
    }

    public void addAction(LogoAction action) {
        if (action == null) {
            throw new NullPointerException("Tried to add null to an action group.");
        }
        this.addActionAt(action, this.getActionCount());
    }

    public void addActionAfter(LogoAction toAdd, LogoAction position) {
        ArrayList actions = this.getActions();
        int index = actions.indexOf(position);
        this.addActionAt(toAdd, index + 1);
    }

    public void addActionAt(LogoAction toAdd, int index) {
        if (toAdd == null) {
            throw new NullPointerException("Tried to add null to an action group.");
        }
        ArrayList actions = this.getActions();
        if (index == -1 || index > actions.size() - 1) {
            actions.add(toAdd);
        } else {
            actions.add(index, toAdd);
        }
        this.fireActionAddedEvent(toAdd);
    }

    public void addActionBefore(LogoAction toAdd, LogoAction position) {
        ArrayList actions = this.getActions();
        int index = actions.indexOf(position);
        this.addActionAt(toAdd, index);
    }

    public void addActionGroupListener(ActionGroupListener agl) {
        if (!this.getActionGroupListeners().containsListener(agl)) {
            this.getActionGroupListeners().addListener(agl);
        }
    }

    public boolean doIt() {
        if (this.fDefaultAction != null) {
            return this.fDefaultAction.doIt();
        }
        throw new UnsupportedOperationException("ActionGroups cannot be executed!");
    }

    public LogoAction findAction(String name) {
        Iterator i = this.getActions().iterator();
        LogoAction action = null;
        String actionName = null;
        while (i.hasNext()) {
            LogoAction action2;
            action = (LogoAction)i.next();
            actionName = (String)action.getValue("Name");
            if (actionName != null && actionName.equals(name)) {
                return action;
            }
            if (!(action instanceof ActionGroup) || (action2 = ((ActionGroup)action).findAction(name)) == null) continue;
            return action2;
        }
        return null;
    }

    public LogoAction getAction(Class actionToFind) {
        Iterator i = this.getActions().iterator();
        LogoAction action = null;
        while (i.hasNext()) {
            action = (LogoAction)i.next();
            if (action.getClass() == actionToFind) {
                return action;
            }
            if (!(action instanceof ActionGroup) || (action = ((ActionGroup)action).getAction(actionToFind)) == null) continue;
            return action;
        }
        return null;
    }

    private void fireActionAddedEvent(LogoAction action) {
        Collection clone = this.getActionGroupListeners().getListeners();
        ActionGroupEvent age = new ActionGroupEvent(this);
        age.setAction(action);
        Iterator i = clone.iterator();
        while (i.hasNext()) {
            ((ActionGroupListener)i.next()).actionAdded(age);
        }
    }

    private void fireActionRemovedEvent(LogoAction action) {
        Collection clone = this.getActionGroupListeners().getListeners();
        ActionGroupEvent age = new ActionGroupEvent(this);
        age.setAction(action);
        Iterator i = clone.iterator();
        while (i.hasNext()) {
            ((ActionGroupListener)i.next()).actionRemoved(age);
        }
    }

    public int getActionCount() {
        return this.getActions().size();
    }

    public WeakListenerRegistry getActionGroupListeners() {
        if (this.fActionGroupListeners == null) {
            this.fActionGroupListeners = new WeakListenerRegistry();
        }
        return this.fActionGroupListeners;
    }

    public ArrayList getActions() {
        if (this.fActions == null) {
            this.fActions = new ArrayList();
        }
        return this.fActions;
    }

    public LogoAction getDefaultAction() {
        return this.fDefaultAction;
    }

    public int getIndexOfAction(LogoAction action) {
        return this.getActions().indexOf(action);
    }

    public boolean isFlatMenu() {
        return this.fFlatMenu;
    }

    public boolean isFlatToolbar() {
        return this.fFlatToolbar;
    }

    public boolean isNumbered() {
        return this.fNumbered;
    }

    public void removeAction(LogoAction action) {
        if (this.getActions().remove(action)) {
            this.fireActionRemovedEvent(action);
        } else {
            for (LogoAction logoAction : this.getActions()) {
                if (!(logoAction instanceof ActionGroup)) continue;
                ((ActionGroup)logoAction).removeAction(action);
            }
        }
    }

    public void removeActionGroupListener(ActionGroupListener agl) {
        this.getActionGroupListeners().removeListener(agl);
    }

    public void removeAllActions() {
        this.getActions().clear();
        this.fireActionRemovedEvent(null);
    }

    public void setDefaultAction(LogoAction defaultAction) {
        this.fDefaultAction = defaultAction;
    }

    public void setFlatMenu(boolean newFlat) {
        this.fFlatMenu = newFlat;
    }

    public void setFlatToolbar(boolean newFlat) {
        this.fFlatToolbar = newFlat;
    }

    public void setNumbered(boolean newNumbered) {
        this.fNumbered = newNumbered;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ActionGroup: ");
        sb.append(this.getValue("Name"));
        sb.append("(");
        Iterator i = this.getActions().iterator();
        while (i.hasNext()) {
            sb.append(((LogoAction)i.next()).toString());
            sb.append("; ");
        }
        sb.append(")");
        return sb.toString();
    }
}

