/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app;

import DE.siemens.ad.logo.app.ApplicationSurface;
import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.StatusLine;
import DE.siemens.ad.logo.app.WindowManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JComponent;

public class InternApplicationSurface
extends ApplicationSurface {
    private Window fWindow;

    public InternApplicationSurface(Editor editor) {
        Window window = editor.getApplicationSurface().getWindow();
        this.setWindow(window);
        this.init();
    }

    public InternApplicationSurface(Window window) {
        this.fWindow = window;
        this.init();
    }

    private void init() {
        this.fWindowManager = new WindowManager();
        this.setBackground(Color.YELLOW);
        this.setLayout(new BorderLayout());
    }

    public Window getWindow() {
        return this.fWindow;
    }

    public void setEditor(Editor editor) {
        if (editor == this.fEditor && editor != null) {
            return;
        }
        if (this.fEditor != null) {
            this.fEditor.deactivate();
        }
        this.setVisible(false);
        this.fEditor = editor;
        this.removeAll();
        if (editor != null) {
            StatusLine statusLine = editor.getStatusLine();
            if (statusLine != null) {
                this.add((Component)statusLine, "South");
            }
            this.fWindowManager.getViewPanel().removeAll();
            this.fWindowManager.getViewPanel().add(editor.getView().getViewComponent());
            this.fWindowManager.closeAllWindows();
            editor.activate(this);
            this.setVisible(true);
        } else {
            Editor defaultEditor = this.fApplication.getDefaultEditor();
            if (defaultEditor != null) {
                defaultEditor.setApplication(this.fApplication);
                defaultEditor.setApplicationSurface(this);
                this.fWindowManager.closeAllWindows();
                JComponent standardToolBarPanel = this.getWindowManager().getToolbarPanel("Standard", "North");
                standardToolBarPanel.add(defaultEditor.getMenuManager().getDefaultToolBar(this.fApplication.getToolbarActionGroup()));
            } else {
                this.fApplication.getMenuManager().getMenuActionGroup(null);
                this.fWindowManager.closeAllWindows();
                JComponent standardToolBarPanel = this.getWindowManager().getToolbarPanel("Standard", "North");
                standardToolBarPanel.add(this.fApplication.getMenuManager().getToolBar(null));
            }
            this.fWindowManager.getViewPanel().removeAll();
        }
        this.add(this.fWindowManager.getDesktopPanel());
        this.setVisible(true);
        this.validate();
        this.repaint();
    }

    public void setWindow(Window window) {
        this.fWindow = window;
    }
}

