/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.util.Log;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;

public class AutoOpenFileThread {
    private static volatile File fCurrentFile = null;
    private static Timer fTimer = null;
    public static final int MAX_WAIT_MILLIS = 25000;

    static void startTimer() {
        if (fTimer != null) {
            try {
                fTimer.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        fTimer = new Timer();
        fTimer.schedule(new TimerTask(){

            public void run() {
                if (fCurrentFile == null) {
                    return;
                }
                try {
                    Application app = Application.getInstance();
                    app.loadDocument(fCurrentFile);
                    fCurrentFile = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 2000L, 500L);
    }

    public static synchronized boolean openFile(File file) {
        if (AutoOpenFileThread.waitUntilAvailable(true)) {
            fCurrentFile = file;
            return true;
        }
        System.err.println("AutoOpenFileThread not available");
        return false;
    }

    public static synchronized void finish() {
        if (fTimer != null) {
            AutoOpenFileThread.waitUntilAvailable(false);
            try {
                fTimer.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean waitUntilAvailable(boolean autoRecover) {
        if (fTimer == null) {
            return false;
        }
        int waitSeconds = 0;
        while (fCurrentFile != null) {
            if (waitSeconds >= 25000) {
                if (autoRecover) {
                    Log.println("Open file failed: " + fCurrentFile.getAbsolutePath());
                    fCurrentFile = null;
                    AutoOpenFileThread.startTimer();
                    return true;
                }
                return false;
            }
            try {
                Thread.sleep(500L);
                waitSeconds += 500;
            }
            catch (Exception exception) {}
        }
        return true;
    }

    static {
        AutoOpenFileThread.startTimer();
    }
}

