/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.model.kopfupcompiler;

import DE.siemens.ad.kop.model.WiringDiagramKop;
import DE.siemens.ad.kop.model.block.CoilBlock;
import DE.siemens.ad.kop.model.block.ContactBlock;
import DE.siemens.ad.kop.model.block.InternMarkerBlock;
import DE.siemens.ad.kop.model.block.NegativCoilBlock;
import DE.siemens.ad.kop.model.kopfupcompiler.BooleanExpressionNode;
import DE.siemens.ad.kop.model.kopfupcompiler.CompilerFupToKop;
import DE.siemens.ad.kop.model.kopfupcompiler.CompilerKopToFup;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.model.block.NotBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import java.util.ArrayList;
import java.util.List;

public class OutputNode
extends BooleanExpressionNode {
    private InputBlock inputBlockTemplate = new InputBlock();
    private String descriptor;
    protected List fKopBlocks;

    public OutputNode() {
    }

    public OutputNode(CoilBlock coilBlock) {
        this.fKopBlock = coilBlock.getReferencedOutputBlock();
        this.fInverted = coilBlock.isNegativ();
        this.setDescriptor(coilBlock.getNumberString());
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public Block compileToFup(WiringDiagram wd, CompilerKopToFup compiler) {
        if (this.fFupBlock == null) {
            if (this.fKopBlock instanceof InternMarkerBlock) {
                if (this.getChildCount() == 0) {
                    return null;
                }
                this.fFupBlock = this.getChildAt(0).compileToFup(wd, compiler);
                if (this.isInverted()) {
                    NotBlock notBlock = new NotBlock(wd);
                    wd.insert(notBlock);
                    notBlock.getInConnector(0).connect(this.fFupBlock.getOutConnector(0));
                    this.fFupBlock = notBlock;
                }
            } else {
                this.fFupBlock = this.fKopBlock.deepCopy();
                this.fFupBlock.setNumber(this.fKopBlock.getNumber());
                wd.insert(this.fFupBlock);
                if (this.isInverted()) {
                    NotBlock notBlock = new NotBlock(wd);
                    wd.insert(notBlock);
                    this.fFupBlock.getInConnector(0).connect(notBlock.getOutConnector(0));
                    this.connectFupBlockWithChildren(notBlock, wd, compiler);
                } else {
                    this.connectFupBlockWithChildren(this.fFupBlock, wd, compiler);
                }
            }
            compiler.getBlockTranslationDict().put(this.fKopBlock, this.fFupBlock);
        }
        return this.fFupBlock;
    }

    protected List compileToKop(List prevBlocks, BooleanExpressionNode callingNode, WiringDiagramKop wd, CompilerFupToKop compiler) {
        CoilBlock coilBlock = null;
        if (this.fKopBlocks == null) {
            coilBlock = this.isInverted() ? new NegativCoilBlock() : new CoilBlock();
            this.fKopBlocks = new ArrayList();
            this.fKopBlocks.add(coilBlock);
            if (this.getChildCount() > 0) {
                List children = this.getChildAt(0).getCompiledKopBlock(new ArrayList(), this, wd, compiler);
                compiler.connect(coilBlock.getInConnector(0), children);
            }
            coilBlock.setReferencedOutputBlock((OutputBlock)this.getFupBlock().deepCopy());
            wd.insert(coilBlock);
            compiler.getBlockTranslationDict().put(this.fFupBlock, coilBlock);
        }
        coilBlock = (CoilBlock)this.fKopBlocks.get(0);
        ArrayList<ContactBlock> result = new ArrayList<ContactBlock>();
        ContactBlock contactBlock = coilBlock.getContactBlock();
        result.add(contactBlock);
        wd.insert(contactBlock);
        compiler.connect(contactBlock.getInConnector(0), prevBlocks);
        return result;
    }

    public int hashCode() {
        if (this.getDescriptor() != null) {
            return this.getDescriptor().hashCode();
        }
        return super.hashCode();
    }

    public void setFupBlock(Block block) {
        super.setFupBlock(block);
        this.setDescriptor(block.getNumberString());
    }

    public void setDescriptor(String newDescriptor) {
        this.descriptor = newDescriptor;
    }

    public ContactBlock getContactBlock(List prevBlocks, BooleanExpressionNode callingNode, WiringDiagramKop wd, CompilerFupToKop compiler) {
        prevBlocks = this.compileToKop(prevBlocks, this, wd, compiler);
        return (ContactBlock)prevBlocks.get(0);
    }
}

