/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.model.kopfupcompiler;

import DE.siemens.ad.kop.model.WiringDiagramKop;
import DE.siemens.ad.kop.model.kopfupcompiler.BooleanExpressionNode;
import DE.siemens.ad.kop.model.kopfupcompiler.CompilerFupToKop;
import DE.siemens.ad.kop.model.kopfupcompiler.CompilerKopToFup;
import DE.siemens.ad.kop.model.kopfupcompiler.NotConnectedNode;
import DE.siemens.ad.kop.model.kopfupcompiler.OperatorNode;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.OrBlock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class OrNode
extends OperatorNode {
    private OrBlock orBlockTemplate = new OrBlock();
    private Hashtable fKopBlocks = new Hashtable();

    public Block compileToFup(WiringDiagram wd, CompilerKopToFup compiler) {
        if (this.fFupBlock == null) {
            try {
                this.fFupBlock = OrBlock.createInstanceForName("OrBlock", wd);
            }
            catch (IOException ioe) {
                System.out.println(ioe);
            }
            wd.insert(this.fFupBlock);
            this.connectFupBlockWithChildren(this.fFupBlock, wd, compiler);
        }
        return this.fFupBlock;
    }

    public void addChildNode(BooleanExpressionNode child) {
        super.addChildNode(child);
        if (child instanceof OrNode) {
            child.setInternMarkerForced(true);
        }
    }

    protected List compileToKop(List prevBlocks, BooleanExpressionNode callingNode, WiringDiagramKop wd, CompilerFupToKop compiler) {
        String prevBlocksString = this.getPreviousBlocksString(prevBlocks);
        if (!this.fKopBlocks.containsKey(prevBlocksString)) {
            ArrayList kopBlocks = new ArrayList();
            Iterator children = this.children();
            while (children.hasNext()) {
                BooleanExpressionNode child = (BooleanExpressionNode)children.next();
                List blocks = child.getCompiledKopBlock(prevBlocks, this, wd, compiler);
                if (child instanceof NotConnectedNode) continue;
                blocks = this.handleNegation(blocks, wd, compiler);
                kopBlocks.addAll(blocks);
            }
            this.fKopBlocks.put(prevBlocksString, kopBlocks);
        }
        return (List)this.fKopBlocks.get(prevBlocksString);
    }
}

