/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.model.block;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.kop.model.CoilParameter;
import DE.siemens.ad.kop.model.WiringDiagramKop;
import DE.siemens.ad.kop.model.block.ContactBlock;
import DE.siemens.ad.kop.model.block.InternMarkerBlock;
import DE.siemens.ad.logo.model.BinaryInBlockConnector;
import DE.siemens.ad.logo.model.BinaryOutBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockNameChangedListener;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareFactory;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.OutputBlock;
import java.io.IOException;

public class CoilBlock
extends OutputBlock
implements BlockNameChangedListener {
    static final long serialVersionUID = 101L;
    private int serializedDataVersion = 1;
    protected CoilParameter fLadderDiagramCoilParameter = null;
    protected OutputBlock fReferencedOutputBlock;

    public CoilBlock() {
    }

    public CoilBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    public boolean calculateBinaryValue() {
        boolean result = false;
        if (this.getReferencedOutputBlock() instanceof InternMarkerBlock) {
            this.fValue = result = ((BinaryInBlockConnector)this.getInConnector(0)).calculateBinaryValue();
        } else {
            result = this.fProcessImageValue;
        }
        this.getReferencedOutputBlock().setBinaryValue(result);
        return result;
    }

    public int[] getMemoryResources(Hardware hardware) {
        int[] arr = new int[HardwareFactory.getInstance().getResourceNames().length];
        return arr;
    }

    public ContactBlock getContactBlock() {
        ContactBlock result = new ContactBlock();
        result.connectToValueSource(this.getOutConnector(0));
        return result;
    }

    protected int getDefaultOrder() {
        return 10300;
    }

    public int getNumber() {
        if (this.getReferencedOutputBlock() != null) {
            return this.getReferencedOutputBlock().getNumber();
        }
        return 1;
    }

    public String getNumberString() {
        if (this.fReferencedOutputBlock == null) {
            return "?";
        }
        return this.fReferencedOutputBlock.getNumberString();
    }

    public int getNumberType() {
        return -1;
    }

    public BlockParameter getParameter() {
        if (this.fLadderDiagramCoilParameter == null) {
            this.fLadderDiagramCoilParameter = new CoilParameter(this);
        }
        return this.fLadderDiagramCoilParameter;
    }

    public OutputBlock getReferencedOutputBlock() {
        return this.fReferencedOutputBlock;
    }

    public void initBlockNumber() {
    }

    protected void initOutConnectors() {
        this.fOutConnectors = new OutBlockConnector[1];
        this.fOutConnectors[0] = new BinaryOutBlockConnector(this);
        this.fOutConnectors[0].setVisible(false);
        this.fOutConnectors[0].setConnectable(false);
    }

    public boolean isNegativ() {
        return false;
    }

    public String preInsert(WiringDiagram wd) {
        WiringDiagramKop wiringDiagramKOP = (WiringDiagramKop)wd;
        OutputBlock freeOutputBlock = wiringDiagramKOP.getFreeOutputBlock(this.getReferencedOutputBlock());
        this.setReferencedOutputBlock(freeOutputBlock);
        return null;
    }

    public void setReferencedOutputBlock(OutputBlock newReferencedOutputBlock) {
        if (this.fReferencedOutputBlock != null) {
            this.fReferencedOutputBlock.removeBlockNameChangedListener(this);
        }
        this.fReferencedOutputBlock = newReferencedOutputBlock;
        if (newReferencedOutputBlock != null) {
            newReferencedOutputBlock.addBlockNameChangedListener(this);
        }
        this.fireBlockNameChangedEvent();
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fReferencedOutputBlock = (OutputBlock)dr.readStorable();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fReferencedOutputBlock);
    }

    public void blockNameChanged(Block newBlock) {
        this.fireBlockNameChangedEvent();
    }

    public boolean isResourceAvailable(WiringDiagram wd) {
        return true;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        if (this.fReferencedOutputBlock != null) {
            this.fReferencedOutputBlock.init(interpreter, forceReset);
            this.setBinaryValue(this.fReferencedOutputBlock.getBinaryValue());
        }
    }

    public String getNumberPrefix() {
        if (this.fReferencedOutputBlock != null) {
            return this.fReferencedOutputBlock.getNumberPrefix();
        }
        return "?";
    }

    public int getOutConnectorCount() {
        if (this.fReferencedOutputBlock != null) {
            return this.fReferencedOutputBlock.getOutConnectorCount();
        }
        return this.fOutConnectors.length;
    }
}

