/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.model.block;

import DE.siemens.ad.kop.model.AnalogContactParameter;
import DE.siemens.ad.kop.model.WiringDiagramKop;
import DE.siemens.ad.kop.model.block.ContactBlock;
import DE.siemens.ad.logo.model.AnalogBlock;
import DE.siemens.ad.logo.model.AnalogInBlockConnector;
import DE.siemens.ad.logo.model.AnalogOutBlockConnector;
import DE.siemens.ad.logo.model.BinaryInBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.BlockEnumeration;
import java.util.List;

public class AnalogContactBlock
extends ContactBlock
implements AnalogBlock {
    static final long serialVersionUID = -1029631194763545067L;
    private int blockSerializedDataVersion = 1;

    public AnalogContactBlock() {
    }

    public AnalogContactBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    public AnalogContactBlock(WiringDiagram wiringDiagram, Block block) {
        this(wiringDiagram);
        this.connectToValueSource(block.getOutConnector(this.fBlockNumber));
    }

    public double calculateAnalogValue() {
        return ((AnalogOutBlockConnector)this.getReferencedOutConnector()).calculateAnalogValue();
    }

    public boolean calculateBinaryContactValue() {
        return false;
    }

    public boolean getBinaryContactValue() {
        return false;
    }

    public BlockParameter getParameter() {
        if (this.fLadderDiagramContactParameter == null) {
            this.fLadderDiagramContactParameter = new AnalogContactParameter(this);
        }
        return this.fLadderDiagramContactParameter;
    }

    public void initInConnectors() {
        this.fInConnectors = new InBlockConnector[1];
        this.fInConnectors[0] = new BinaryInBlockConnector((Block)this, true);
        this.fValueSourceInConnector = new AnalogInBlockConnector(this, 0.0, "value");
    }

    protected void initOutConnectors() {
        this.fOutConnectors = new OutBlockConnector[1];
        this.fOutConnectors[0] = new AnalogOutBlockConnector(this);
    }

    public String preInsert(WiringDiagram wd) {
        String inputBlockName = "AI1";
        OutBlockConnector referencedOutConnector = this.getReferencedOutConnector();
        if (referencedOutConnector != null) {
            inputBlockName = referencedOutConnector.getOwner().getNumberString();
        }
        this.connectToValueSource(((WiringDiagramKop)wd).getContactSourceBlock(inputBlockName).getOutConnector(0));
        return null;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        ((AnalogOutBlockConnector)this.getReferencedOutConnector()).getOwner().init(interpreter, forceReset);
    }

    public void collectSensors(List sensorContainer) {
        BlockEnumeration nextAnalogBlocks = this.getOutConnector(0).getLinkedBlocks();
        while (nextAnalogBlocks.hasMoreElements()) {
            AnalogBlock analogBlock = (AnalogBlock)((Object)nextAnalogBlocks.nextBlock());
            analogBlock.collectSensors(sensorContainer);
        }
    }

    public void addMeasurementBoundsChangedListener(ParameterSetListener listener) {
        BlockEnumeration analogBlocks = this.getOutConnector(0).getLinkedBlocks();
        while (analogBlocks.hasMoreElements()) {
            AnalogBlock analogBlock = (AnalogBlock)((Object)analogBlocks.nextBlock());
            analogBlock.addMeasurementBoundsChangedListener(listener);
        }
    }

    public void removeMeasurementBoundsChangedListener(ParameterSetListener listener) {
        BlockEnumeration analogBlocks = this.getOutConnector(0).getLinkedBlocks();
        while (analogBlocks.hasMoreElements()) {
            AnalogBlock analogBlock = (AnalogBlock)((Object)analogBlocks.nextBlock());
            analogBlock.removeMeasurementBoundsChangedListener(listener);
        }
    }
}

