/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.model;

import DE.siemens.ad.kop.model.KopProgrammingLanguage;
import DE.siemens.ad.kop.model.LadderDiagramBlock;
import DE.siemens.ad.kop.model.LeftPowerRailBlock;
import DE.siemens.ad.kop.model.block.AnalogCoilBlock;
import DE.siemens.ad.kop.model.block.CoilBlock;
import DE.siemens.ad.kop.model.block.ContactBlock;
import DE.siemens.ad.kop.model.block.InternMarkerBlock;
import DE.siemens.ad.kop.model.block.NegativContactBlock;
import DE.siemens.ad.kop.model.kopfupcompiler.CompilerException;
import DE.siemens.ad.kop.model.kopfupcompiler.CompilerKopToFup;
import DE.siemens.ad.logo.model.AnalogOutBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockConnector;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.HardwareFactory;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.InBlockConnectorEnumeration;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.ProgrammingLanguage;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.AnalogInputBlock;
import DE.siemens.ad.logo.model.block.AnalogMarkerBlock;
import DE.siemens.ad.logo.model.block.AnalogOutputBlock;
import DE.siemens.ad.logo.model.block.AsiInputBlock;
import DE.siemens.ad.logo.model.block.AsiOutputBlock;
import DE.siemens.ad.logo.model.block.HighBlock;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.model.block.KeyInputBlock;
import DE.siemens.ad.logo.model.block.LowBlock;
import DE.siemens.ad.logo.model.block.MarkerBlock;
import DE.siemens.ad.logo.model.block.NotBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.model.block.ShiftRegisterInputBlock;
import DE.siemens.ad.logo.model.block.TDFunctionKeyInputBlock;
import DE.siemens.ad.logo.model.block.VirtualOutputBlock;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import DE.siemens.ad.pdraw.standard.UsedResourcesChangedListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class WiringDiagramKop
extends WiringDiagram
implements Serializable {
    private Block fLeftPowerRailBlock;
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;
    private transient CompilerKopToFup fFupCompiler = null;
    protected transient List fAvailableBinaryInputs;
    protected transient List fAvailableBinaryOutputs;
    protected transient List fAvailableAnalogInputs;
    protected transient List fAvailableAnalogOutputs;
    protected transient List fAvailableConstants;

    public WiringDiagramKop() {
        this(null);
    }

    public WiringDiagramKop(Hardware hardware) {
        if (hardware == null) {
            hardware = HardwareFactory.getInstance().createInstance();
        }
        this.setHardware(hardware);
    }

    public void addUsedResourcesChangedListenerOLD(UsedResourcesChangedListener urcl) {
        this.getFup().addUsedResourcesChangedListener(urcl);
    }

    public boolean canConnectWithoutRecursion(OutBlockConnector outConnector, InBlockConnector inConnector) {
        List rightBlocks = new ArrayList();
        if (inConnector.getLinkedConnectorCount() > 0) {
            for (OutBlockConnector outConn : inConnector.getLinkedConnectorsList()) {
                rightBlocks.addAll(this.getRightBlocksUntilOutput(outConn.getOwner(), true));
            }
        } else {
            rightBlocks = this.getRightBlocksUntilOutput(inConnector.getOwner(), true);
        }
        return !rightBlocks.contains(outConnector.getOwner());
    }

    public void compile(Hardware hw) {
        WiringDiagram wd = this.getFup();
        wd.getHardware().getCompilerToHardware().compile(wd, hw);
    }

    public void compile() {
        this.getFup().compile();
    }

    public Vector getAllOutConnectors() {
        Vector outConnectors = super.getAllOutConnectors();
        Iterator i = this.getAvailableBinaryInputBlocks().iterator();
        Block block = null;
        while (i.hasNext()) {
            block = (Block)i.next();
            OutBlockConnector[] outBlockConnectors = block.getOutConnectors();
            for (int j = 0; j < outBlockConnectors.length; ++j) {
                outConnectors.add(block.getOutConnector(j));
            }
        }
        return outConnectors;
    }

    public List getNotConnectedContacts() {
        ArrayList<Block> notConnectedContacts = new ArrayList<Block>();
        Enumeration blocks = this.getBlocks().elements();
        Block block = null;
        while (blocks.hasMoreElements()) {
            block = (Block)blocks.nextElement();
            if (!(block instanceof ContactBlock) && !(block instanceof NegativContactBlock) || block.getInConnectorCount() <= 0 || block.getInConnector(0).isConnected()) continue;
            notConnectedContacts.add(block);
        }
        return notConnectedContacts;
    }

    public List getAvailableAnalogContactSourceBlocks(Block block) {
        ArrayList analogContactBlocks = new ArrayList();
        analogContactBlocks.addAll(this.getAvailableAnalogInputBlocks());
        ArrayList<Block> analogRightTerminals = new ArrayList<Block>(10);
        for (Block rightTerminal : this.getUsedRightTerminals(null)) {
            if (!(rightTerminal.getOutConnector(0) instanceof AnalogOutBlockConnector)) continue;
            analogRightTerminals.add(rightTerminal);
        }
        analogContactBlocks.addAll(analogRightTerminals);
        return analogContactBlocks;
    }

    protected List getAvailableAnalogInputBlocks() {
        if (this.fAvailableAnalogInputs == null) {
            this.fAvailableAnalogInputs = new ArrayList();
            int[] maxAnalogInputNumbers = this.getNumberResource(11);
            if (maxAnalogInputNumbers != null) {
                for (int i = 0; i < maxAnalogInputNumbers.length; ++i) {
                    AnalogInputBlock inputBlock = new AnalogInputBlock(this);
                    inputBlock.setNumber(i + 1);
                    this.fAvailableAnalogInputs.add(this.getInputBlock(inputBlock));
                }
            }
        }
        return this.fAvailableAnalogInputs;
    }

    public Block getLeftPowerRailBlock() {
        if (this.fLeftPowerRailBlock == null) {
            this.fLeftPowerRailBlock = new LeftPowerRailBlock();
        }
        return this.fLeftPowerRailBlock;
    }

    public List getAvailableBinaryCoilBlocks(Block block) {
        return this.getFreeBinaryOutputBlocks(block);
    }

    public List getAvailableAnalogCoilBlocks(Block block) {
        return this.getFreeAnalogOutputBlocks(block);
    }

    public List getAvailableBinaryContactSourceBlocks(Block block) {
        ArrayList<Block> binaryContactBlocks = new ArrayList<Block>();
        binaryContactBlocks.addAll(this.getAvailableBinaryInputBlocks());
        binaryContactBlocks.addAll(this.getAvailableConstantBlocks());
        List usedRightTerminals = this.getUsedRightTerminals(block.getInConnector(0));
        for (Block rightTerminal : usedRightTerminals) {
            if (rightTerminal.getOutConnectorCount() <= 0) continue;
            binaryContactBlocks.add(rightTerminal);
        }
        if (block != null) {
            binaryContactBlocks.removeAll(this.getNotAllowedContactNames(block));
        }
        return binaryContactBlocks;
    }

    protected List getAvailableBinaryInputBlocks() {
        if (this.fAvailableBinaryInputs == null) {
            InputBlock inputBlock;
            int i;
            int maxInputNumbers = this.getHardware().getMaxResource(6);
            int maxAsiInputNumbers = this.getHardware().getMaxResource(8);
            int maxKeyInputNumbers = this.getHardware().getMaxResource(17);
            int maxShiftInputNumbers = this.getHardware().getMaxResource(19);
            int maxTDFunctionKeyNumbers = this.getHardware().getMaxResource(21);
            this.fAvailableBinaryInputs = new ArrayList();
            for (i = 0; i < maxInputNumbers; ++i) {
                inputBlock = new InputBlock(this);
                inputBlock.setNumber(i + 1);
                this.fAvailableBinaryInputs.add(this.getInputBlock(inputBlock));
            }
            for (i = 0; i < maxAsiInputNumbers; ++i) {
                inputBlock = new AsiInputBlock(this);
                inputBlock.setNumber(i + 1);
                this.fAvailableBinaryInputs.add(this.getInputBlock(inputBlock));
            }
            for (i = 0; i < maxKeyInputNumbers; ++i) {
                KeyInputBlock keyInputBlock = new KeyInputBlock(this);
                keyInputBlock.setNumber(i + 1);
                this.fAvailableBinaryInputs.add(this.getInputBlock(keyInputBlock));
            }
            for (i = 0; i < maxShiftInputNumbers; ++i) {
                ShiftRegisterInputBlock shiftRegisterInputBlock = new ShiftRegisterInputBlock(this);
                shiftRegisterInputBlock.setNumber(i + 1);
                this.fAvailableBinaryInputs.add(this.getInputBlock(shiftRegisterInputBlock));
            }
            for (i = 0; i < maxTDFunctionKeyNumbers; ++i) {
                TDFunctionKeyInputBlock tdFunctionKeyInputBlock = new TDFunctionKeyInputBlock(this);
                tdFunctionKeyInputBlock.setNumber(i + 1);
                this.fAvailableBinaryInputs.add(this.getInputBlock(tdFunctionKeyInputBlock));
            }
        }
        return this.fAvailableBinaryInputs;
    }

    protected List getFreeBinaryOutputBlocks(Block coilBlock) {
        OutputBlock outputBlock;
        int i;
        int[] outputNumbers = this.getFreeNumbers(7);
        int[] asiOutputNumbers = this.getFreeNumbers(9);
        int[] markerNumbers = this.getFreeNumbers(10);
        int[] virtualOutputNumbers = this.getFreeNumbers(20);
        ArrayList<Block> freeBinaryOutputs = new ArrayList<Block>();
        for (i = 0; i < outputNumbers.length; ++i) {
            outputBlock = new OutputBlock(this);
            outputBlock.setNumber(outputNumbers[i]);
            freeBinaryOutputs.add(this.getOutputBlock(outputBlock));
        }
        for (i = 0; i < asiOutputNumbers.length; ++i) {
            outputBlock = new AsiOutputBlock(this);
            outputBlock.setNumber(asiOutputNumbers[i]);
            freeBinaryOutputs.add(this.getOutputBlock(outputBlock));
        }
        for (i = 0; i < markerNumbers.length; ++i) {
            outputBlock = new MarkerBlock(this);
            outputBlock.setNumber(markerNumbers[i]);
            freeBinaryOutputs.add(this.getOutputBlock(outputBlock));
        }
        if (coilBlock == null || coilBlock.getOutConnectorCount() == 0 || coilBlock.getOutConnector(0).getLinkedConnectorsCount() == 0) {
            for (i = 0; i < virtualOutputNumbers.length; ++i) {
                VirtualOutputBlock virtualOutputBlock = new VirtualOutputBlock(this);
                virtualOutputBlock.setNumber(virtualOutputNumbers[i]);
                freeBinaryOutputs.add(this.getOutputBlock(virtualOutputBlock));
            }
        }
        if (coilBlock != null) {
            ArrayList rightBlocks = new ArrayList();
            InBlockConnectorEnumeration inConnectors = coilBlock.getOutConnector(0).getLinkedConnectors();
            while (inConnectors.hasMoreElements()) {
                rightBlocks.addAll(this.getRightBlocksUntilOutput(inConnectors.nextElement().getOwner(), true));
            }
            if (!rightBlocks.contains(coilBlock)) {
                freeBinaryOutputs.add(this.getFreeInternMarkerBlock(new InternMarkerBlock()));
            }
        } else {
            freeBinaryOutputs.add(this.getFreeInternMarkerBlock(new InternMarkerBlock()));
        }
        return freeBinaryOutputs;
    }

    protected List getFreeAnalogOutputBlocks(Block coilBlock) {
        OutputBlock outputBlock;
        int i;
        int[] outputNumbers = this.getFreeNumbers(13);
        int[] markerNumbers = this.getFreeNumbers(16);
        ArrayList<Block> freeAnalogOutputs = new ArrayList<Block>();
        for (i = 0; i < outputNumbers.length; ++i) {
            outputBlock = new AnalogOutputBlock(this);
            outputBlock.setNumber(outputNumbers[i]);
            freeAnalogOutputs.add(this.getOutputBlock(outputBlock));
        }
        for (i = 0; i < markerNumbers.length; ++i) {
            outputBlock = new AnalogMarkerBlock(this);
            outputBlock.setNumber(markerNumbers[i]);
            freeAnalogOutputs.add(this.getOutputBlock(outputBlock));
        }
        return freeAnalogOutputs;
    }

    protected List getAvailableBinaryOutputBlocks() {
        if (this.fAvailableBinaryOutputs == null) {
            OutputBlock outputBlock;
            int i;
            int[] outputNumbers = this.getNumberResource(7);
            int[] asiOutputNumbers = this.getNumberResource(9);
            int[] markerNumbers = this.getNumberResource(10);
            int[] virtualOutputNumbers = this.getNumberResource(20);
            this.fAvailableBinaryOutputs = new ArrayList();
            if (outputNumbers != null) {
                for (i = 0; i < outputNumbers.length; ++i) {
                    outputBlock = new OutputBlock(this);
                    outputBlock.setNumber(i + 1);
                    this.fAvailableBinaryOutputs.add(this.getOutputBlock(outputBlock));
                }
            }
            if (asiOutputNumbers != null) {
                for (i = 0; i < asiOutputNumbers.length; ++i) {
                    outputBlock = new AsiOutputBlock(this);
                    outputBlock.setNumber(i + 1);
                    this.fAvailableBinaryOutputs.add(this.getOutputBlock(outputBlock));
                }
            }
            if (markerNumbers != null) {
                for (i = 0; i < markerNumbers.length; ++i) {
                    outputBlock = new MarkerBlock(this);
                    outputBlock.setNumber(i + 1);
                    this.fAvailableBinaryOutputs.add(this.getOutputBlock(outputBlock));
                }
            }
            if (virtualOutputNumbers != null) {
                for (i = 0; i < virtualOutputNumbers.length; ++i) {
                    outputBlock = new VirtualOutputBlock(this);
                    outputBlock.setNumber(i + 1);
                    this.fAvailableBinaryOutputs.add(this.getOutputBlock(outputBlock));
                }
            }
        }
        return this.fAvailableBinaryOutputs;
    }

    protected List getAvailableAnalogOutputBlocks() {
        if (this.fAvailableAnalogOutputs == null) {
            OutputBlock outputBlock;
            int i;
            int[] outputNumbers = this.getNumberResource(13);
            int[] markerNumbers = this.getNumberResource(16);
            this.fAvailableAnalogOutputs = new ArrayList();
            if (outputNumbers != null) {
                for (i = 0; i < outputNumbers.length; ++i) {
                    outputBlock = new AnalogOutputBlock(this);
                    outputBlock.setNumber(i + 1);
                    this.fAvailableAnalogOutputs.add(this.getOutputBlock(outputBlock));
                }
            }
            if (markerNumbers != null) {
                for (i = 0; i < markerNumbers.length; ++i) {
                    outputBlock = new AnalogMarkerBlock(this);
                    outputBlock.setNumber(i + 1);
                    this.fAvailableAnalogOutputs.add(this.getOutputBlock(outputBlock));
                }
            }
        }
        return this.fAvailableAnalogOutputs;
    }

    public OutputBlock getBinaryOutputBlock(String name) {
        Iterator outputBlocks = this.getAvailableBinaryOutputBlocks().iterator();
        OutputBlock outputBlock = null;
        while (outputBlocks.hasNext()) {
            outputBlock = (OutputBlock)outputBlocks.next();
            if (!outputBlock.getNumberString().equals(name)) continue;
            return outputBlock;
        }
        return null;
    }

    public OutputBlock getAnalogOutputBlock(String name) {
        Iterator outputBlocks = this.getAvailableAnalogOutputBlocks().iterator();
        OutputBlock outputBlock = null;
        while (outputBlocks.hasNext()) {
            outputBlock = (OutputBlock)outputBlocks.next();
            if (!outputBlock.getNumberString().equals(name)) continue;
            return outputBlock;
        }
        return null;
    }

    public Vector[] getAvailableBlocks() {
        return this.getProgrammingLanguage().getAvailableBlocks(this.getHardware());
    }

    public List getAvailableConstantBlocks() {
        if (this.fAvailableConstants == null) {
            this.fAvailableConstants = new ArrayList(2);
            this.fAvailableConstants.add(new HighBlock(this));
            this.fAvailableConstants.add(new LowBlock(this));
        }
        return this.fAvailableConstants;
    }

    public Block[] getCopyOfBlocks() {
        return this.getFup().getCopyOfBlocks();
    }

    public Block getContactSourceBlock(String blockName) {
        ArrayList inputBlocks = new ArrayList(this.getAvailableBinaryContactSourceBlocks(new NotBlock()));
        inputBlocks.addAll(this.getAvailableAnalogContactSourceBlocks(null));
        Block block2 = null;
        for (Block block2 : inputBlocks) {
            if (!block2.getNumberString().equals(blockName)) continue;
            return block2;
        }
        return null;
    }

    public int getFreeInternMarkerNumber(int preferredNumber) {
        Enumeration blocks = this.fBlockVector.elements();
        ArrayList<Integer> usedNumbers = new ArrayList<Integer>();
        Block block = null;
        while (blocks.hasMoreElements()) {
            CoilBlock coilBlock;
            block = (Block)blocks.nextElement();
            if (!(block instanceof CoilBlock) || !((coilBlock = (CoilBlock)block).getReferencedOutputBlock() instanceof InternMarkerBlock)) continue;
            usedNumbers.add(new Integer(coilBlock.getReferencedOutputBlock().getNumber()));
        }
        while (usedNumbers.contains(new Integer(preferredNumber))) {
            ++preferredNumber;
        }
        return preferredNumber;
    }

    public int[] getFreeNumbers(int type) {
        return this.getFup().getFreeNumbers(type);
    }

    public OutputBlock getFreeOutputBlock() {
        List availableBinaryOutputBlocks = this.getFreeBinaryOutputBlocks(null);
        if (availableBinaryOutputBlocks.size() == 0) {
            return null;
        }
        OutputBlock block = (OutputBlock)availableBinaryOutputBlocks.get(0);
        return block;
    }

    public OutputBlock getFreeOutputBlock(OutputBlock preferredBlock) {
        if (preferredBlock instanceof InternMarkerBlock) {
            return this.getFreeInternMarkerBlock((InternMarkerBlock)preferredBlock);
        }
        List freeBinaryOutputBlocks = this.getFreeBinaryOutputBlocks(null);
        OutputBlock block = this.getFreeOutputBlock();
        for (OutputBlock outputBlock : freeBinaryOutputBlocks) {
            if (preferredBlock != null && !outputBlock.getNumberString().equals(preferredBlock.getNumberString())) continue;
            block = outputBlock;
            break;
        }
        freeBinaryOutputBlocks.remove(block);
        return block;
    }

    public OutputBlock getFreeAnalogOutputBlock(OutputBlock preferredBlock) {
        List freeAnalogOutputBlocks = this.getFreeAnalogOutputBlocks(null);
        OutputBlock block = null;
        for (OutputBlock outputBlock : freeAnalogOutputBlocks) {
            if (preferredBlock != null && !outputBlock.getNumberString().equals(preferredBlock.getNumberString())) continue;
            block = outputBlock;
            break;
        }
        if (block == null && freeAnalogOutputBlocks.size() > 0) {
            block = (OutputBlock)freeAnalogOutputBlocks.get(0);
        }
        freeAnalogOutputBlocks.remove(block);
        return block;
    }

    public InternMarkerBlock getFreeInternMarkerBlock(InternMarkerBlock preferredInternMarkerBlock) {
        if (preferredInternMarkerBlock == null) {
            preferredInternMarkerBlock = new InternMarkerBlock();
        }
        preferredInternMarkerBlock.setNumber(this.getFreeInternMarkerNumber(preferredInternMarkerBlock.getNumber()));
        return preferredInternMarkerBlock;
    }

    public int[] getFreeResources() {
        return this.getFup().getFreeResources();
    }

    public WiringDiagram getFup() {
        WiringDiagram wiringDiagram = null;
        try {
            wiringDiagram = this.getFupCompiler().getFup();
        }
        catch (CompilerException ce) {
            System.out.println(ce.getMessage());
        }
        return wiringDiagram;
    }

    public WiringDiagram getFup(Hardware hw) {
        boolean oldOptimization = this.getFupCompiler().isUseHardwareDependendOptimization();
        this.setCompilerOptions(hw);
        WiringDiagram result = this.getFup();
        this.getFupCompiler().setUseHardwareDependendOptimization(oldOptimization);
        return result;
    }

    public CompilerKopToFup getFupCompiler() {
        if (this.fFupCompiler == null) {
            this.fFupCompiler = new CompilerKopToFup(this);
        }
        return this.fFupCompiler;
    }

    private void setCompilerOptions(Hardware hw) {
        this.getFupCompiler().setUseHardwareDependendOptimization(hw.supports("negatableInputs"));
    }

    protected boolean isBlockAvailable(Block block, Hardware hardware, ArrayList errorList) {
        if (!this.getProgrammingLanguage().isBlockAvailable(block, hardware)) {
            errorList.add(new ErrorInfo(block, "error.convert.block.unknownBlock", hardware));
            return false;
        }
        if (block instanceof LadderDiagramBlock) {
            if (this.getContactSourceBlock(block.getNumberString()) == null) {
                errorList.add(new ErrorInfo(block, "error.notAvailable", hardware));
                return false;
            }
            return true;
        }
        if (block instanceof CoilBlock) {
            return true;
        }
        return block.isAvailable(hardware, null);
    }

    private Block getInputBlock(Block searchedBlock) {
        Enumeration e = this.getBlocks().elements();
        Block block = null;
        while (e.hasMoreElements()) {
            block = (Block)e.nextElement();
            if (!block.getNumberString().equals(searchedBlock.getNumberString())) continue;
            if (this.isRightTerminal(block)) {
                return block;
            }
            return ((ContactBlock)block).getReferencedOutConnector().getOwner();
        }
        return searchedBlock;
    }

    public Vector getInputBlocks() {
        Vector<Block> inputBlocks = new Vector<Block>();
        Enumeration blockEnum = this.getBlocks().elements();
        Block block = null;
        while (blockEnum.hasMoreElements()) {
            block = (Block)blockEnum.nextElement();
            if (!(block instanceof ContactBlock) || !(((ContactBlock)block).getReferencedOutConnector().getOwner() instanceof InputBlock) || inputBlocks.contains(((ContactBlock)block).getReferencedOutConnector().getOwner())) continue;
            inputBlocks.add(((ContactBlock)block).getReferencedOutConnector().getOwner());
        }
        return inputBlocks;
    }

    public Block[] getMaxStackDepthBlocks() {
        Block[] arr = this.getFup().getMaxStackDepthBlocks();
        if (arr.length < 2) {
            return arr;
        }
        Block[] result = new Block[]{arr[0], arr[arr.length - 1]};
        return result;
    }

    public List getNotAllowedContactNames(Block block) {
        ArrayList<Block> notAllowedBlocks = new ArrayList<Block>();
        Iterator rightBlocks = this.getRightBlocksUntilOutput(block, false).iterator();
        Object currentBlock = null;
        while (rightBlocks.hasNext()) {
            block = (Block)rightBlocks.next();
            if (!this.isRightTerminal(block)) continue;
            notAllowedBlocks.add(block);
        }
        return notAllowedBlocks;
    }

    private Block getOutputBlock(Block searchedBlock) {
        return searchedBlock;
    }

    protected Vector getOutputBlocks(boolean virtualOutputsIncluded) {
        Enumeration outputBlocks = super.getOutputBlocks().elements();
        Vector<CoilBlock> outputBlocksWithoutInternalMarker = new Vector<CoilBlock>();
        CoilBlock block = null;
        while (outputBlocks.hasMoreElements()) {
            block = (CoilBlock)outputBlocks.nextElement();
            if (block.getReferencedOutputBlock() instanceof InternMarkerBlock || !virtualOutputsIncluded && block.getReferencedOutputBlock() instanceof VirtualOutputBlock) continue;
            outputBlocksWithoutInternalMarker.addElement(block);
        }
        return outputBlocksWithoutInternalMarker;
    }

    public Vector getOutputBlocks() {
        return this.getOutputBlocks(false);
    }

    public String getResourceInfo() {
        return this.getFup().getResourceInfo();
    }

    public List getRightBlocksUntilOutput(Block startBlock, boolean includeOutput) {
        ArrayList rightBlocks = new ArrayList();
        this.getRightBlocksUntilOutputRecursive(startBlock, rightBlocks, includeOutput);
        return rightBlocks;
    }

    private List getRightBlocksUntilOutputRecursive(Block startBlock, List rightBlocks, boolean includeOutput) {
        if (startBlock instanceof CoilBlock && !(((CoilBlock)startBlock).getReferencedOutputBlock() instanceof InternMarkerBlock)) {
            if (includeOutput) {
                rightBlocks.add(startBlock);
            }
        } else {
            rightBlocks.add(startBlock);
            for (int i = 0; i < startBlock.getOutConnectorCount(); ++i) {
                OutBlockConnector outConnector = startBlock.getOutConnector(i);
                List parallelOutConnectors = outConnector.findParallelOutBlockConnectors();
                parallelOutConnectors.add(outConnector);
                for (OutBlockConnector currentOutConnector : parallelOutConnectors) {
                    InBlockConnectorEnumeration inConnectors = currentOutConnector.getLinkedConnectors();
                    Block nextBlock = null;
                    while (inConnectors.hasMoreElements()) {
                        nextBlock = inConnectors.nextElement().getOwner();
                        this.getRightBlocksUntilOutputRecursive(nextBlock, rightBlocks, includeOutput);
                    }
                }
            }
        }
        return rightBlocks;
    }

    public Hardware[] getSuitableHardware(ArrayList errorList) {
        Vector blockVector = this.getBlocks();
        Hardware[] knownHardware = HardwareFactory.getInstance().getAvailableHardware();
        Hardware[] result = null;
        if (blockVector.size() > 0) {
            Hardware[] suitableHardware = new Hardware[knownHardware.length];
            int j = 0;
            for (int i = 0; i < knownHardware.length; ++i) {
                if (!this.getFup(knownHardware[i]).isSuitable(knownHardware[i], errorList)) continue;
                suitableHardware[j++] = knownHardware[i];
            }
            if (j > 0) {
                result = new Hardware[j];
                System.arraycopy(suitableHardware, 0, result, 0, j);
            }
        } else {
            result = knownHardware;
        }
        return result;
    }

    public List getUsedContactBlocks() {
        ArrayList<Block> contactBlocks = new ArrayList<Block>();
        Enumeration blocks = this.getBlocks().elements();
        Block block = null;
        while (blocks.hasMoreElements()) {
            block = (Block)blocks.nextElement();
            if (!(block instanceof ContactBlock)) continue;
            contactBlocks.add(block);
        }
        return contactBlocks;
    }

    private List getContactsReferencing(Block referencedBlock) {
        ArrayList<ContactBlock> referents = new ArrayList<ContactBlock>();
        Iterator contacts = this.getUsedContactBlocks().iterator();
        ContactBlock contact = null;
        while (contacts.hasNext()) {
            contact = (ContactBlock)contacts.next();
            if (contact.getReferencedOutConnector().getOwner() != referencedBlock) continue;
            referents.add(contact);
        }
        return referents;
    }

    public int[] getUsedResources(Block[] blocks) {
        return this.getFup().getUsedResources(blocks);
    }

    public int[] getUsedResources(Vector usedBlocks) {
        return this.getFup().getUsedResources(usedBlocks);
    }

    public String getUsedResourceString() {
        return this.getFup().getUsedResourceString();
    }

    protected List getUsedRightTerminals(BlockConnector blockConnector) {
        ArrayList<Block> specialBlocks = new ArrayList<Block>();
        Enumeration blocks = this.getBlocks().elements();
        Block block = null;
        while (blocks.hasMoreElements()) {
            block = (Block)blocks.nextElement();
            if (!this.isRightTerminal(block) || blockConnector != null && blockConnector.getSignalType() != block.getOutConnector(0).getSignalType()) continue;
            specialBlocks.add(block);
        }
        return specialBlocks;
    }

    public String insert(Block block) {
        CoilBlock coilBlock;
        String result = null;
        if (block instanceof CoilBlock && (coilBlock = (CoilBlock)block).getReferencedOutputBlock() instanceof InternMarkerBlock) {
            coilBlock.getReferencedOutputBlock().setNumber(this.getFreeInternMarkerNumber(coilBlock.getReferencedOutputBlock().getNumber()));
        }
        if (!this.contains(block)) {
            block.setWiringDiagram(this);
            int numberType = block.getNumberType();
            if (numberType > -1) {
                int blockNumber = block.getNumber();
                int[] resourceArr = this.getNumberResource(block);
                resourceArr[blockNumber - 1] = 2;
            }
            try {
                result = this.addBlock(block);
            }
            catch (NullPointerException e) {
                System.err.println("KOP insert AQ error.");
            }
        }
        return result;
    }

    public void invalidateOutConnectors() {
        super.invalidateOutConnectors();
        Enumeration e = this.getInputBlocks().elements();
        Block block = null;
        OutBlockConnector[] outConnectors = null;
        while (e.hasMoreElements()) {
            block = (Block)e.nextElement();
            outConnectors = block.getOutConnectors();
            for (int j = 0; j < outConnectors.length; ++j) {
                outConnectors[j].setDataInvalid();
            }
        }
    }

    public boolean isCorrect() {
        WiringDiagram wiringDiagramFup = this.getFup();
        return wiringDiagramFup.getUsedResources(wiringDiagramFup.getBlocks())[0] <= this.getHardware().getMaxResource(0);
    }

    public boolean isRightTerminal(Block block) {
        return this.getProgrammingLanguage().isRightTerminal(block);
    }

    public String getBlockNumberPrefix(Block block) {
        return this.getProgrammingLanguage().getBlockNumberPrefix(block);
    }

    public boolean isStackDepthOk() {
        return this.getFup().isStackDepthOk();
    }

    void setFupCompiler(CompilerKopToFup newFupCompiler) {
        this.fFupCompiler = newFupCompiler;
    }

    public HardwareChangedEvent setHardware(Hardware newHardware) {
        boolean headlinePrinted;
        HardwareChangedEvent hwChangedEvent = super.setHardware(newHardware);
        if (hwChangedEvent == null) {
            return hwChangedEvent;
        }
        this.fHardware = newHardware;
        this.fAvailableBinaryInputs = null;
        this.fAvailableAnalogInputs = null;
        this.fAvailableBinaryOutputs = null;
        Iterator contactBlocks = this.getUsedContactBlocks().iterator();
        Block referencedBlock = null;
        Block newReferencedBlock = null;
        ContactBlock contactBlock = null;
        Hashtable substitutionDict = hwChangedEvent.getSubstitutedBlocksDictionary();
        boolean bl = headlinePrinted = substitutionDict.size() > 0;
        while (contactBlocks.hasNext()) {
            contactBlock = (ContactBlock)contactBlocks.next();
            referencedBlock = contactBlock.getReferencedOutConnector().getOwner();
            newReferencedBlock = this.getContactSourceBlock(newHardware.getSubstitutionBlock(referencedBlock).getNumberString());
            if (newReferencedBlock == referencedBlock) continue;
            if (newReferencedBlock != null) {
                contactBlock.connectToValueSource(newReferencedBlock.getOutConnector(0));
                if (!headlinePrinted) {
                    Log.println("msg.blockSubstitute", "Blocks substituted");
                    headlinePrinted = true;
                }
                Log.print(referencedBlock.getLocalizedName(true));
                Log.print("\t-->\t");
                Log.println(newReferencedBlock.getLocalizedName(true));
                continue;
            }
            if (substitutionDict.size() <= 0 || (newReferencedBlock = (Block)substitutionDict.get(referencedBlock)) == null) continue;
            contactBlock.connectToValueSource(newReferencedBlock.getOutConnector(0));
        }
        Enumeration blocks = this.getBlocks().elements();
        Block block = null;
        while (blocks.hasMoreElements()) {
            block = (Block)blocks.nextElement();
            if (!(block instanceof CoilBlock)) continue;
            referencedBlock = ((CoilBlock)block).getReferencedOutputBlock();
            String blockName = newHardware.getSubstitutionBlock(referencedBlock).getNumberString();
            newReferencedBlock = block instanceof AnalogCoilBlock ? this.getAnalogOutputBlock(blockName) : this.getBinaryOutputBlock(blockName);
            if (referencedBlock instanceof InternMarkerBlock || newReferencedBlock == referencedBlock) continue;
            ((CoilBlock)block).setReferencedOutputBlock((OutputBlock)newReferencedBlock);
            if (referencedBlock.getNumberString().equals(newReferencedBlock.getNumberString())) continue;
            if (!headlinePrinted) {
                Log.println("msg.blockSubstitute", "Blocks substituted");
                headlinePrinted = true;
            }
            Log.print(referencedBlock.getLocalizedName(true));
            Log.print("\t-->\t");
            Log.println(newReferencedBlock.getLocalizedName(true));
        }
        return hwChangedEvent;
    }

    public String toString() {
        return "WiringDiagram KOP for:" + this.fHardware.getName();
    }

    public ProgrammingLanguage getProgrammingLanguage() {
        if (this.fProgrammingLanguage == null) {
            this.fProgrammingLanguage = KopProgrammingLanguage.getInstance();
        }
        return this.fProgrammingLanguage;
    }

    public void registerContactsAsBlockNameChangedListener() {
        Enumeration blocks = this.fBlockVector.elements();
        Block block = null;
        while (blocks.hasMoreElements()) {
            block = (Block)blocks.nextElement();
            if (!(block instanceof ContactBlock) || ((ContactBlock)block).getReferencedOutConnector() == null) continue;
            ((ContactBlock)block).getReferencedOutConnector().getOwner().addBlockNameChangedListener((ContactBlock)block);
        }
    }

    public boolean insert(Block[] blocks, HashMap resultDict) {
        int[] fupResources;
        Hardware currentHardware = this.getHardware();
        WiringDiagramKop test = new WiringDiagramKop(currentHardware);
        for (int i = 0; i < blocks.length; ++i) {
            Block block = blocks[i];
            test.addBlock(blocks[i]);
        }
        WiringDiagram testFup = test.getFup();
        WiringDiagram currentFup = this.getFup();
        int[] testResources = testFup.getUsedResources(testFup.getBlocks());
        if (testResources[0] + (fupResources = currentFup.getUsedResources(currentFup.getBlocks()))[0] > currentHardware.getMaxResource(0)) {
            resultDict.put("err", "noResource");
            return false;
        }
        return super.insert(blocks, resultDict);
    }

    public Vector getOpenBlocks() {
        ArrayList visitedBlocks = new ArrayList(this.getBlocks().size());
        Vector outputBlocks = this.getOutputBlocks(true);
        for (Block outputBlock : outputBlocks) {
            this.visitPredecessors(outputBlock, visitedBlocks);
        }
        Vector openBlocks = new Vector(this.getBlocks());
        openBlocks.removeAll(visitedBlocks);
        openBlocks.remove(this.getLeftPowerRailBlock());
        return openBlocks;
    }

    private void visitPredecessors(Block block, List visitedBlocks) {
        if (visitedBlocks.contains(block)) {
            return;
        }
        visitedBlocks.add(block);
        for (InBlockConnector inConnector : block.getAllInConnectors()) {
            Block linkedBlock = inConnector.getLinkedBlock();
            if (linkedBlock == null) continue;
            this.visitPredecessors(linkedBlock, visitedBlocks);
        }
    }

    public HardwareChangedEvent hardwareChanged(Hardware hw) {
        HardwareChangedEvent result = super.hardwareChanged(hw);
        this.setCompilerOptions(hw);
        return result;
    }

    public Block getBlockByNumberExt(int numberType, int blockNumber) {
        Enumeration blockEnum = this.getBlocks().elements();
        Block block = null;
        Block refBlock = null;
        while (blockEnum.hasMoreElements()) {
            block = (Block)blockEnum.nextElement();
            refBlock = block instanceof CoilBlock ? ((CoilBlock)block).getReferencedOutputBlock() : (block instanceof ContactBlock ? ((ContactBlock)block).getReferencedOutConnector().getOwner() : block);
            if (refBlock.getNumberType() != numberType || refBlock.getNumber() != blockNumber) continue;
            return refBlock;
        }
        return null;
    }

    public Block getBlock(int opcode, int blockNumber) {
        Block result = null;
        Block block = null;
        Enumeration enumeration = this.fBlockVector.elements();
        while (enumeration.hasMoreElements()) {
            block = (Block)enumeration.nextElement();
            int curOpcode = 0;
            try {
                curOpcode = block.getOpcode();
            }
            catch (RuntimeException e) {
                curOpcode = -1;
            }
            if (curOpcode != opcode || block.getNumber() != blockNumber) continue;
            result = block;
            break;
        }
        return result;
    }
}

