/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.model;

import DE.siemens.ad.kop.model.FupKopBlockMapping;
import DE.siemens.ad.kop.model.KopBlockGroupAllocation;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockGroup;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.ProgrammingLanguage;
import DE.siemens.ad.logo.model.block.VirtualOutputBlock;
import java.util.List;

public class KopProgrammingLanguage
extends ProgrammingLanguage {
    private static KopProgrammingLanguage cSingletonInstance;
    protected FupKopBlockMapping fFupKopBlockMapping = new FupKopBlockMapping();

    public boolean isInConnectorMultiConnectable() {
        return true;
    }

    private KopProgrammingLanguage() {
        this.fBlockGroupAllocation = KopBlockGroupAllocation.getInstance();
    }

    public BlockGroup getAvailableBlockGroups(Hardware hardware) {
        List availableFupBlockNames = null;
        if (hardware != null) {
            availableFupBlockNames = this.getAllBlockNames((String[][])hardware.getProperty("knownBlocks"));
        }
        List availableKopBlockNames = this.fFupKopBlockMapping.getKopBlocks(availableFupBlockNames);
        BlockGroup root = this.fBlockGroupAllocation.getBlockGroupAllocation(availableKopBlockNames);
        this.setHardware(root, hardware);
        return root;
    }

    public List getAvailableBlockNames(Hardware hardware) {
        List availableFupBlockNames = null;
        if (hardware != null) {
            availableFupBlockNames = this.getAllBlockNames((String[][])hardware.getProperty("knownBlocks"));
        }
        List availableKopBlockNames = this.fFupKopBlockMapping.getKopBlocks(availableFupBlockNames);
        return availableKopBlockNames;
    }

    public boolean isRightTerminal(Block block) {
        if (block instanceof VirtualOutputBlock) {
            return true;
        }
        BlockGroup blockGroup = this.fBlockGroupAllocation.getBlockGroup(block);
        if (blockGroup == null) {
            return false;
        }
        Boolean isRightTerminal = blockGroup.getBlocksAreRightTerminals();
        if (isRightTerminal == null) {
            return false;
        }
        boolean reterunValue = isRightTerminal;
        return reterunValue;
    }

    public String getBlockNumberPrefix(Block block) {
        String numberPrefix;
        BlockGroup blockGroup = this.fBlockGroupAllocation.getBlockGroup(block);
        String returnPrefix = "B";
        if (blockGroup != null && (numberPrefix = blockGroup.getBlockNamePrefix()) != null) {
            returnPrefix = numberPrefix;
        }
        return returnPrefix;
    }

    public String getName() {
        return "LAD";
    }

    public static KopProgrammingLanguage getInstance() {
        if (cSingletonInstance == null) {
            cSingletonInstance = new KopProgrammingLanguage();
        }
        return cSingletonInstance;
    }
}

