/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.app;

import DE.siemens.ad.kop.model.LeftPowerRailBlock;
import DE.siemens.ad.kop.model.block.CoilBlock;
import DE.siemens.ad.kop.model.block.ContactBlock;
import DE.siemens.ad.logo.model.BinaryOutBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.pdraw.simulation.ProcessImageParser;

public class KopProcessImageParser
extends ProcessImageParser {
    public KopProcessImageParser(Hardware hardware) {
        super(hardware);
    }

    protected double getAnalogOutputValue(Block block) {
        int offsetInImage = 0;
        offsetInImage = this.getOffSetInImage(block);
        int byteNr = (block.getNumber() - 1) * 2 + offsetInImage;
        double value = Util.makeSignedWord(this.fProcessImage[byteNr + 1], this.fProcessImage[byteNr]);
        return value;
    }

    protected boolean getDigitalValue(Block block) {
        boolean value = false;
        int offsetInImage = 0;
        offsetInImage = this.getOffSetInImage(block);
        if (offsetInImage == -1) {
            value = this.getBlockValue(block);
        }
        if (offsetInImage >= 0) {
            value = this.getProcessImageValue(block, offsetInImage);
        }
        return value;
    }

    private int getOffSetInImage(Block block) {
        if (block instanceof CoilBlock) {
            return this.getOffsetInProcessImage(((CoilBlock)block).getReferencedOutputBlock().getClass());
        }
        return this.getOffsetInProcessImage(block.getClass());
    }

    protected boolean getBlockValue(Block block) {
        if (block instanceof ContactBlock) {
            Block inputBlock = ((ContactBlock)block).getInConnectors()[0].getLinkedBlock();
            boolean inputValue = inputBlock == null ? false : (inputBlock instanceof LeftPowerRailBlock ? true : this.getDigitalValue(inputBlock));
            Block contactedBlock = ((ContactBlock)block).getReferencedOutConnector().getOwner();
            boolean contactedValue = super.getDigitalValue(contactedBlock);
            ((BinaryOutBlockConnector)contactedBlock.getOutConnector(0)).setBinaryValue(contactedValue);
            return inputValue && contactedValue;
        }
        if (block instanceof LeftPowerRailBlock) {
            return true;
        }
        return super.getBlockValue(block);
    }
}

