/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.app;

import DE.siemens.ad.kop.app.LogoComfortKOP;
import DE.siemens.ad.kop.model.WiringDiagramKop;
import DE.siemens.ad.kop.model.kopfupcompiler.CompilerException;
import DE.siemens.ad.kop.model.kopfupcompiler.CompilerKopToFup;
import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.View;
import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.UntitledFile;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.pdraw.app.FupEditorInfo;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.pdraw.util.LayoutProducer;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class ConvertToFupAction
extends LogoAction {
    public ConvertToFupAction() {
        this.putValue("Name", "Convert to function block diagram");
        this.putValue("textKey", "file.convertToFup");
        this.putValue("defaultText", "file.convertToFup");
        this.putValue("SmallIcon", Global.getIcon("Kop2Fup.gif"));
    }

    public boolean doIt() {
        Application application = Application.getInstance();
        View newFupView = application.createView(new FupEditorInfo().getEditorClassName());
        LogoComfort newFupEditor = (LogoComfort)newFupView.getEditor();
        if (newFupView != null) {
            LogoDrawing newFupDrawing = (LogoDrawing)newFupView.getModel();
            View currentKopView = (View)((Object)((LogoComfortKOP)this.getOwner()).view());
            WiringDiagramKop wiringDiagramKop = (WiringDiagramKop)((LogoDrawing)currentKopView.getModel()).getWiringDiagram();
            CompilerKopToFup kopToFupCompiler = new CompilerKopToFup(wiringDiagramKop);
            WiringDiagram wiringDiagramFup = null;
            try {
                wiringDiagramFup = kopToFupCompiler.getFup();
            }
            catch (CompilerException compilerException) {
                JOptionPane.showMessageDialog(this.getOwner().getWindow(), compilerException.getMessage(), "Error", 0);
                return false;
            }
            newFupEditor.setWiringDiagram(wiringDiagramFup);
            LayoutProducer layoutProducer = new LayoutProducer((LogoDrawingView)newFupView, wiringDiagramFup.getBlocks());
            layoutProducer.layout();
            LogoDrawing oldDrawing = (LogoDrawing)currentKopView.getModel();
            kopToFupCompiler.transferComments(oldDrawing, newFupDrawing);
            newFupDrawing.getInputNamesManager().copyInputOutputNamesFrom(oldDrawing.getInputNamesManager());
            newFupDrawing.updateInputNames();
            String fileName = Util.stripFileExtension(oldDrawing.getFile().getName());
            boolean filenameUsed = false;
            do {
                filenameUsed = false;
                Iterator i = application.getMdiManager().getViews().iterator();
                View testView = null;
                while (i.hasNext() && !filenameUsed) {
                    testView = (View)i.next();
                    if (!testView.getModel().getFile().getName().equals(fileName) || !testView.getEditor().getEditorInfo().getName().equals(newFupView.getEditor().getEditorInfo().getName())) continue;
                    filenameUsed = true;
                }
                if (!filenameUsed) continue;
                fileName = Util.incrementFilenameNumber(fileName);
            } while (filenameUsed);
            newFupDrawing.setFile(new UntitledFile(fileName));
            application.addDocument(newFupView);
        }
        return true;
    }

    public boolean needsWaitCursor() {
        return true;
    }
}

