/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.Storable;
import java.awt.Color;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class StorableOutput {
    private PrintWriter fStream;
    private Vector fMap;
    private int fIndent;
    protected static final String STRING_NULL_ID = "<$!null!$>";

    public StorableOutput(OutputStream stream) {
        this.fStream = new PrintWriter(stream);
        this.fMap = new Vector();
        this.fIndent = 0;
    }

    public void close() {
        this.fStream.close();
    }

    private void decrementIndent() {
        this.fIndent -= 4;
        if (this.fIndent < 0) {
            this.fIndent = 0;
        }
    }

    private void incrementIndent() {
        this.fIndent += 4;
    }

    private void map(Storable storable) {
        if (!this.fMap.contains(storable)) {
            this.fMap.addElement(storable);
        }
    }

    private boolean mapped(Storable storable) {
        return this.fMap.contains(storable);
    }

    private void space() {
        this.fStream.print(' ');
    }

    private void startNewLine() {
        this.fStream.println();
        for (int i = 0; i < this.fIndent; ++i) {
            this.space();
        }
    }

    public void writeBoolean(boolean b) {
        if (b) {
            this.fStream.print(1);
        } else {
            this.fStream.print(0);
        }
        this.space();
    }

    public void writeColor(Color c) {
        this.writeInt(c.getRed());
        this.writeInt(c.getGreen());
        this.writeInt(c.getBlue());
    }

    public void writeDouble(double d) {
        NumberFormat formatter = NumberFormat.getNumberInstance(Locale.US);
        formatter.setMaximumFractionDigits(18);
        formatter.setGroupingUsed(false);
        String s = formatter.format(d);
        this.fStream.print(s);
        this.space();
    }

    public void writeInt(int i) {
        this.fStream.print(i);
        this.space();
    }

    public void writeLong(long l) {
        this.fStream.print(l);
        this.space();
    }

    private void writeRef(Storable storable) {
        int ref = this.fMap.indexOf(storable);
        this.fStream.print("REF");
        this.space();
        this.fStream.print(ref);
        this.space();
    }

    public void writeStorable(Storable storable) {
        if (storable == null) {
            this.fStream.print("NULL");
            this.space();
            return;
        }
        if (this.mapped(storable)) {
            this.writeRef(storable);
            return;
        }
        this.incrementIndent();
        this.startNewLine();
        this.map(storable);
        this.fStream.print('\"' + storable.getClass().getName() + '\"');
        this.space();
        storable.write(this);
        this.space();
        this.decrementIndent();
    }

    public void writeString(String s) {
        if (s == null) {
            this.writeString("STRING_NULL_ID");
        } else {
            this.fStream.print('\"');
            block6: for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '\n': {
                        this.fStream.print('\\');
                        this.fStream.print('n');
                        continue block6;
                    }
                    case '\"': {
                        this.fStream.print('\\');
                        this.fStream.print('\"');
                        continue block6;
                    }
                    case '\\': {
                        this.fStream.print('\\');
                        this.fStream.print('\\');
                        continue block6;
                    }
                    case '\t': {
                        this.fStream.print('\\');
                        this.fStream.print('\t');
                        continue block6;
                    }
                    default: {
                        this.fStream.print(c);
                    }
                }
            }
            this.fStream.print('\"');
            this.space();
        }
    }

    public void writeVector(Vector vector) {
        this.writeInt(vector.size());
        Enumeration e = vector.elements();
        while (e.hasMoreElements()) {
            this.writeStorable((Storable)e.nextElement());
        }
    }

    public void writeClass(Class classObject) {
        this.writeString(classObject.getName());
    }
}

