/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import java.awt.Point;
import java.awt.Rectangle;

public class Geom {
    public static final int NORTH = 1;
    public static final int SOUTH = 2;
    public static final int WEST = 3;
    public static final int EAST = 4;

    private Geom() {
    }

    public static Point angleToPoint(Rectangle r, double angle) {
        double si = Math.sin(angle);
        double co = Math.cos(angle);
        double e = 1.0001659393310547E-4;
        int x = 0;
        int y = 0;
        if (Math.abs(si) > e) {
            x = (int)((1.0 + co / Math.abs(si)) / 2.0 * (double)r.width);
            x = Geom.range(0, r.width, x);
        } else if (co >= 0.0) {
            x = r.width;
        }
        if (Math.abs(co) > e) {
            y = (int)((1.0 + si / Math.abs(co)) / 2.0 * (double)r.height);
            y = Geom.range(0, r.height, y);
        } else if (si >= 0.0) {
            y = r.height;
        }
        return new Point(r.x + x, r.y + y);
    }

    public static Point center(Rectangle r) {
        return new Point(r.x + r.width / 2, r.y + r.height / 2);
    }

    public static int direction(int x1, int y1, int x2, int y2) {
        int direction = 0;
        int vy = y2 - y1;
        int vx = x2 - x1;
        direction = vy < vx && vx > -vy ? 4 : (vy > vx && vy > -vx ? 1 : (vx < vy && vx < -vy ? 3 : 2));
        return direction;
    }

    public static Point east(Rectangle r) {
        return new Point(r.x + r.width, r.y + r.height / 2);
    }

    public static Point intersect(int xa, int ya, int xb, int yb, int xc, int yc, int xd, int yd) {
        double denom = (xb - xa) * (yd - yc) - (yb - ya) * (xd - xc);
        double rnum = (ya - yc) * (xd - xc) - (xa - xc) * (yd - yc);
        if (denom == 0.0) {
            if (rnum == 0.0) {
                if (xa < xb && (xb < xc || xb < xd) || xa > xb && (xb > xc || xb > xd)) {
                    return new Point(xb, yb);
                }
                return new Point(xa, ya);
            }
            return null;
        }
        double r = rnum / denom;
        double snum = (ya - yc) * (xb - xa) - (xa - xc) * (yb - ya);
        double s = snum / denom;
        if (0.0 <= r && r <= 1.0 && 0.0 <= s && s <= 1.0) {
            int px = (int)((double)xa + (double)(xb - xa) * r);
            int py = (int)((double)ya + (double)(yb - ya) * r);
            return new Point(px, py);
        }
        return null;
    }

    public static long length(long x1, long y1, long x2, long y2) {
        return (long)Math.sqrt(Geom.length2(x1, y1, x2, y2));
    }

    public static long length2(long x1, long y1, long x2, long y2) {
        return (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1);
    }

    public static boolean lineContainsPoint(int x1, int y1, int x2, int y2, int px, int py) {
        Rectangle r = new Rectangle(new Point(x1, y1));
        r.add(x2, y2);
        r.grow(2, 2);
        if (!r.contains(px, py)) {
            return false;
        }
        if (x1 == x2) {
            return Math.abs(px - x1) < 3;
        }
        if (y1 == y2) {
            return Math.abs(py - y1) < 3;
        }
        double a = (double)(y1 - y2) / (double)(x1 - x2);
        double b = (double)y1 - a * (double)x1;
        double x = ((double)py - b) / a;
        double y = a * (double)px + b;
        return Math.min(Math.abs(x - (double)px), Math.abs(y - (double)py)) < 4.0;
    }

    public static boolean lineIntersectsRectangle(int x1, int y1, int x2, int y2, Rectangle rect) {
        Rectangle r = new Rectangle(new Point(x1, y1));
        r.add(x2, y2);
        r.grow(1, 1);
        return rect.intersects(r) && (x1 == x2 || y1 == y2);
    }

    public static Point north(Rectangle r) {
        return new Point(r.x + r.width / 2, r.y);
    }

    public static Point ovalAngleToPoint(Rectangle r, double angle) {
        Point center = Geom.center(r);
        Point p = Geom.polarToPoint(angle, r.width / 2, r.height / 2);
        return new Point(center.x + p.x, center.y + p.y);
    }

    public static double pointToAngle(Rectangle r, Point p) {
        int px = p.x - (r.x + r.width / 2);
        int py = p.y - (r.y + r.height / 2);
        return Math.atan2(py * r.width, px * r.height);
    }

    public static Point polarToPoint(double angle, double fx, double fy) {
        double si = Math.sin(angle);
        double co = Math.cos(angle);
        return new Point((int)(fx * co + 1.5 - 1.0), (int)(fy * si + 1.5 - 1.0));
    }

    public static int range(int min, int max, int value) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    public static Point south(Rectangle r) {
        return new Point(r.x + r.width / 2, r.y + r.height);
    }

    public static Point west(Rectangle r) {
        return new Point(r.x, r.y + r.height / 2);
    }
}

