/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.standard.StandardDrawingView;
import DE.siemens.ad.logo.app.comp.PopupWindow;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class FloatingTextField {
    private JTextArea fEditArea = new JTextArea(4, 20);
    private Container fContainer;
    protected PopupWindow fPopupWindow;
    protected JScrollPane scrollPane = new JScrollPane(this.fEditArea);

    public FloatingTextField() {
        this.fEditArea.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent ke) {
                if (FloatingTextField.this.fContainer instanceof StandardDrawingView) {
                    ((StandardDrawingView)FloatingTextField.this.fContainer).keyPressed(ke);
                }
            }
        });
    }

    public void addActionListener(ActionListener listener) {
    }

    protected Point calculatePopupPosition(Rectangle popupBounds) {
        Point position = popupBounds.getLocation();
        JViewport viewPort = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this.fContainer);
        Point bottomRight = new Point(popupBounds.x + popupBounds.width, popupBounds.y + popupBounds.height);
        bottomRight.translate(-viewPort.getViewPosition().x, -viewPort.getViewPosition().y);
        int dx = viewPort.getExtentSize().width - this.fContainer.getLocation().x - bottomRight.x - 15;
        int dy = viewPort.getExtentSize().height - this.fContainer.getLocation().y - bottomRight.y - 15;
        if (dx < 0) {
            position.translate(dx, 0);
        }
        if (dy < 0) {
            position.translate(0, dy);
        }
        return position;
    }

    public void createOverlay(Container container) {
        this.createOverlay(container, null);
    }

    public void createOverlay(Container container, Font font) {
        if (font != null) {
            this.fEditArea.setFont(font);
        }
        this.fContainer = container;
    }

    public void endOverlay() {
        this.fContainer.requestFocus();
        if (this.fEditArea == null) {
            return;
        }
        this.fPopupWindow.setVisible(false);
    }

    public Dimension getPreferredSize(int cols) {
        return this.fEditArea.getPreferredSize();
    }

    public String getText() {
        return this.fEditArea.getText();
    }

    public void removeActionListener(ActionListener listener) {
    }

    public void setBounds(Rectangle r, String text) {
        this.fEditArea.setText(text);
        this.fEditArea.setVisible(true);
        r.grow(10, 5);
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.fContainer);
        this.fPopupWindow = new PopupWindow(window);
        this.fPopupWindow.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.fPopupWindow.getContentPane().add(this.scrollPane);
        Point popupPosition = this.calculatePopupPosition(r);
        this.fEditArea.requestFocus();
        this.fPopupWindow.show(this.fContainer, new Rectangle(popupPosition.getLocation().x, popupPosition.getLocation().y, r.width, r.height));
    }
}

