/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.ColorEntry;
import java.awt.Color;

public class ColorMap {
    static ColorEntry[] fMap = new ColorEntry[]{new ColorEntry("color.black", Color.black), new ColorEntry("color.blue", Color.blue), new ColorEntry("color.green", Color.green), new ColorEntry("color.red", Color.red), new ColorEntry("color.pink", Color.pink), new ColorEntry("color.magenta", Color.magenta), new ColorEntry("color.orange", Color.orange), new ColorEntry("color.yellow", Color.yellow), new ColorEntry("color.aquamarina", new Color(7396243)), new ColorEntry("color.seagreen", new Color(2330216)), new ColorEntry("color.darkgray", Color.darkGray), new ColorEntry("color.lightgray", Color.lightGray), new ColorEntry("color.white", Color.white), new ColorEntry("color.none", new Color(16762782))};
    public static final String USER_DEFINED = "RGB=";

    public static Color color(int index) {
        if (index < ColorMap.size() && index >= 0) {
            return ColorMap.fMap[index].fColor;
        }
        throw new ArrayIndexOutOfBoundsException("Color index: " + index);
    }

    public static Color color(String name) {
        if (name.startsWith(USER_DEFINED)) {
            return ColorMap.getUserDefinedColor(name);
        }
        for (int i = 0; i < fMap.length; ++i) {
            if (!ColorMap.fMap[i].fName.equals(name)) continue;
            return ColorMap.fMap[i].fColor;
        }
        return Color.black;
    }

    public static int colorIndex(Color color) {
        for (int i = 0; i < fMap.length; ++i) {
            if (!ColorMap.fMap[i].fColor.equals(color)) continue;
            return i;
        }
        return -1;
    }

    public static String[] colorKeys() {
        String[] colorKeys = new String[fMap.length];
        for (int i = 0; i < fMap.length; ++i) {
            colorKeys[i] = ColorMap.fMap[i].fName;
        }
        return colorKeys;
    }

    public static Color getUserDefinedColor(String userDefinedString) {
        return new Color(Integer.parseInt(userDefinedString.substring(USER_DEFINED.length())));
    }

    public static boolean isTransparent(Color color) {
        return color.equals(ColorMap.color("color.none"));
    }

    public static boolean isUserdefinedColor(String colorName) {
        return colorName.startsWith(USER_DEFINED);
    }

    public static String name(int index) {
        if (index < ColorMap.size() && index >= 0) {
            return ColorMap.fMap[index].fName;
        }
        throw new ArrayIndexOutOfBoundsException("Color index: " + index);
    }

    public static String name(Color color) {
        int index = ColorMap.colorIndex(color);
        if (index == -1) {
            return USER_DEFINED + color.getRGB();
        }
        if (index < ColorMap.size() && index >= 0) {
            return ColorMap.fMap[index].fName;
        }
        throw new ArrayIndexOutOfBoundsException("Color index: " + index);
    }

    public static int size() {
        return fMap.length;
    }
}

